/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.Generator;
import org.jboss.soa.esb.listeners.config.mappers.MapperUtil;
import org.jboss.soa.esb.listeners.config.xbeanmodel.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel.FtpBusDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.FtpListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.FtpMessageFilterDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.FtpProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.Listener;
import org.jboss.soa.esb.listeners.gateway.ReadOnlyRemoteGatewayListener;
import org.jboss.soa.esb.listeners.gateway.RemoteGatewayListener;
import org.w3c.dom.Element;

public class FtpListenerMapper {
    private static final String FTP_SEPARATOR = "/";

    public static Element map(Element root, FtpListenerDocument.FtpListener listener, Generator.XMLBeansModel model) throws ConfigurationException {
        FtpProviderDocument.FtpProvider provider;
        FtpBusDocument.FtpBus bus;
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        listenerNode.setAttribute("name", listener.getName());
        try {
            bus = (FtpBusDocument.FtpBus)model.getBus(listener.getBusidref());
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <ftp-listener> must reference a <ftp-bus>.");
        }
        try {
            provider = (FtpProviderDocument.FtpProvider)model.getProvider((Bus)bus);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <ftp-provider> instance.  Unexpected exception - this should have caused a validation error!");
        }
        FtpMessageFilterDocument.FtpMessageFilter messageFilter = listener.getFtpMessageFilter();
        if (messageFilter == null && (messageFilter = bus.getFtpMessageFilter()) == null) {
            throw new ConfigurationException("No <ftp-detination> defined on either <ftp-listener> [" + listener.getName() + "] or <ftp-bus> [" + bus.getBusid() + "].");
        }
        MapperUtil.mapDefaultAttributes((Listener)listener, listenerNode, model);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);
        if (listener.getIsGateway()) {
            if (messageFilter.getReadOnly()) {
                listenerNode.setAttribute("gatewayClass", ReadOnlyRemoteGatewayListener.class.getName());
            } else {
                listenerNode.setAttribute("gatewayClass", RemoteGatewayListener.class.getName());
            }
            FtpListenerMapper.mapFtpEprProperties(listenerNode, provider, messageFilter);
            MapperUtil.mapEPRProperties((Listener)listener, listenerNode, model);
        } else {
            Element eprNode = YADOMUtil.addElement(listenerNode, "EPR");
            FtpListenerMapper.mapFtpEprProperties(eprNode, provider, messageFilter);
            MapperUtil.mapEPRProperties((Listener)listener, eprNode, model);
            YADOMUtil.removeEmptyAttributes(eprNode);
        }
        YADOMUtil.removeEmptyAttributes(listenerNode);
        return listenerNode;
    }

    private static void mapFtpEprProperties(Element toElement, FtpProviderDocument.FtpProvider provider, FtpMessageFilterDocument.FtpMessageFilter messageFilter) {
        String filterPassword;
        String inputDir = messageFilter.getDirectory();
        if (!inputDir.startsWith(FTP_SEPARATOR)) {
            inputDir = FTP_SEPARATOR + inputDir;
        }
        String urlPassword = (filterPassword = messageFilter.getPassword()) == null ? "" : ":" + filterPassword;
        toElement.setAttribute("URL", messageFilter.getProtocol() + "://" + messageFilter.getUsername() + urlPassword + "@" + provider.getHostname() + inputDir);
        toElement.setAttribute("inputSuffix", messageFilter.getInputSuffix());
        toElement.setAttribute("workSuffix", messageFilter.getWorkSuffix());
        toElement.setAttribute("postDelete", String.valueOf(messageFilter.getPostDelete()));
        if (!messageFilter.getPostDelete()) {
            toElement.setAttribute("postDir", messageFilter.getPostDirectory());
            toElement.setAttribute("postSuffix", messageFilter.getPostSuffix());
        }
        toElement.setAttribute("errorDelete", String.valueOf(messageFilter.getErrorDelete()));
        if (!messageFilter.getErrorDelete()) {
            toElement.setAttribute("errorDir", messageFilter.getErrorDirectory());
            toElement.setAttribute("errorSuffix", messageFilter.getErrorSuffix());
        }
        toElement.setAttribute("passive", String.valueOf(messageFilter.getPassive()));
        if (FtpMessageFilterDocument.FtpMessageFilter.Protocol.SFTP.equals(messageFilter.getProtocol())) {
            toElement.setAttribute("certificate", messageFilter.getCertificateUrl());
            toElement.setAttribute("passphrase", messageFilter.getCertificatePassphrase());
        }
        if (FtpMessageFilterDocument.FtpMessageFilter.Protocol.FTPS.equals(messageFilter.getProtocol())) {
            toElement.setAttribute("certificate", messageFilter.getCertificateUrl());
            toElement.setAttribute("certificateName", messageFilter.getCertificateName());
        }
    }
}

