/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config.mappers;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.Generator;
import org.jboss.soa.esb.listeners.config.mappers.MapperUtil;
import org.jboss.soa.esb.listeners.config.mappers.SecurityMapper;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ActionDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ActionsDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.MepType;
import org.jboss.soa.esb.listeners.config.xbeanmodel.PropertyDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ServiceDocument;
import org.w3c.dom.Element;

public class ActionMapper {
    private static final Logger logger = Logger.getLogger(ActionMapper.class);

    public static void map(Element listenerConfigTree, ServiceDocument.Service listenerService, Generator.XMLBeansModel model) throws ConfigurationException {
        if (listenerService.getActions() != null) {
            String faultxsd;
            String outxsd;
            String inxsd;
            ActionsDocument.Actions actions = listenerService.getActions();
            MepType.Enum mep = actions.getMep();
            if (mep != null) {
                listenerConfigTree.setAttribute("mep", mep.toString());
            }
            if ((inxsd = actions.getInXsd()) != null) {
                listenerConfigTree.setAttribute("inXsd", inxsd);
            }
            if ((outxsd = actions.getOutXsd()) != null) {
                listenerConfigTree.setAttribute("outXsd", outxsd);
            }
            if ((faultxsd = actions.getFaultXsd()) != null) {
                listenerConfigTree.setAttribute("faultXsd", faultxsd);
            }
            if (actions.isSetValidate()) {
                listenerConfigTree.setAttribute("validate", Boolean.toString(actions.getValidate()));
            }
            SecurityMapper.map(listenerConfigTree, listenerService);
            List actionList = actions.getActionList();
            HashMap<String, String> hm = new HashMap<String, String>();
            for (ActionDocument.Action action : actionList) {
                ActionMapper.mapAction(listenerConfigTree, action);
                if (hm.containsKey(action.getName())) {
                    throw new ConfigurationException("Tried to register a duplicate action name.  Service " + listenerService.getName() + " already contains an action named " + action.getName() + ".    Action names must be unique per service.");
                }
                hm.put(action.getName(), action.getName());
            }
        }
    }

    private static void mapAction(Element listenerConfigTree, ActionDocument.Action action) {
        Element actionConfigTree = YADOMUtil.addElement(listenerConfigTree, "action");
        List properties = action.getPropertyList();
        actionConfigTree.setAttribute("action", action.getName());
        actionConfigTree.setAttribute("class", action.getClass1());
        actionConfigTree.setAttribute("process", action.getProcess());
        for (PropertyDocument.Property property : properties) {
            Element propertyElement = listenerConfigTree.getOwnerDocument().createElement("property");
            MapperUtil.serialize((XmlObject)property, propertyElement);
            if (property.getValue() != null) {
                actionConfigTree.setAttribute(property.getName(), property.getValue());
            }
            if (!propertyElement.hasChildNodes()) continue;
            YADOMUtil.copyChildNodes(propertyElement, actionConfigTree);
        }
        YADOMUtil.removeEmptyAttributes(actionConfigTree);
    }
}

