/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.webservice.ESBContractGenerator;
import org.jboss.internal.soa.esb.webservice.ESBServiceContractPublisher;
import org.jboss.internal.soa.esb.webservice.ESBServiceEndpointInfo;
import org.jboss.internal.soa.esb.webservice.JAXWSProviderClassGenerator;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameConverter;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.listeners.config.JBoss4ESBDeployerMBean;
import org.jboss.soa.esb.listeners.config.JBoss4ESBDeployment;
import org.jboss.soa.esb.listeners.config.JBoss4ESBDeploymentMetaData;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ActionDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ActionsDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JbossesbDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ServiceDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ServicesDocument;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss4ESBDeployer
extends SubDeployerSupport
implements SubDeployer,
JBoss4ESBDeployerMBean {
    private static final Logger log = Logger.getLogger(JBoss4ESBDeployer.class);
    private ServiceControllerMBean serviceController;
    private Properties actionArtifactProperties;
    private final File esbWarFiles;
    private final Set<String> esbNames = new HashSet<String>();
    private static final String PREFIX_CANONICAL_NAME = "jboss.esb:deployment=";
    private static final String ESB_ARTIFACT_NAME = "jbossesb.esb";

    public JBoss4ESBDeployer() {
        this.setSuffixes(new String[]{".esb"});
        this.setRelativeOrder(1000);
        ServerConfig config = ServerConfigLocator.locate();
        this.esbWarFiles = new File(config.getServerTempDeployDir(), "esbwarfiles");
        this.esbWarFiles.mkdirs();
    }

    public static boolean hasFile(DeploymentInfo di, String filePath) {
        String urlStr = di.url.getFile();
        try {
            URL dd = di.localCl.findResource(filePath);
            if (dd != null) {
                String ddStr;
                if (di.localUrl != null) {
                    urlStr = di.localUrl.toString();
                }
                if ((ddStr = dd.toString()).indexOf(urlStr) >= 0) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.toString();
        return urlStr.endsWith(".esb") || urlStr.endsWith(".esb/") || urlStr.endsWith("-esb.xml");
    }

    protected void startService() throws Exception {
        InputStream actionArtifactIS = ClassUtil.getResourceAsStream("/actionArtifactMap.properties", this.getClass());
        if (actionArtifactIS == null) {
            log.debug((Object)"No action artifact mapping");
        } else {
            log.debug((Object)"Loading action artifact mapping");
            Properties properties = new Properties();
            properties.load(actionArtifactIS);
            this.actionArtifactProperties = properties;
        }
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.mainDeployer.addDeployer((SubDeployer)this);
        LifecycleResourceManager.deactivateHook();
    }

    protected void stopService() throws Exception {
        LifecycleResourceManager.getSingleton().cleanupAllResources();
        super.stopService();
    }

    protected URL getDocumentUrl(DeploymentInfo di) {
        String urlStr = di.url.toString();
        if (urlStr.endsWith(".esb") || urlStr.endsWith(".esb/")) {
            return di.localCl.getResource("META-INF/jboss-esb.xml");
        }
        return di.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DeploymentInfo di) throws DeploymentException {
        try {
            File warFile;
            String jbossEsbXml;
            URL document;
            File file;
            di.watch = di.url.getProtocol().equalsIgnoreCase("file") ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "META-INF/jboss-esb.xml")) : di.url;
            XmlFileLoader xfl = new XmlFileLoader();
            InputStream in = di.localCl.getResourceAsStream("META-INF/deployment.xml");
            if (in != null) {
                try {
                    Element jboss = xfl.getDocument(in, "META-INF/deployment.xml").getDocumentElement();
                    Element loader = MetaData.getOptionalChild((Element)jboss, (String)"loader-repository");
                    if (loader != null) {
                        LoaderRepositoryFactory.LoaderRepositoryConfig config = LoaderRepositoryFactory.parseRepositoryConfig((Element)loader);
                        di.setRepositoryInfo(config);
                    }
                }
                finally {
                    in.close();
                }
            }
            if ((document = this.getDocumentUrl(di)) == null) {
                throw new DeploymentException("Unable to find document url of META-INF/jboss-esb.xml in: " + di.url);
            }
            InputStream inputStream = document.openStream();
            try {
                StringWriter sw = new StringWriter();
                XMLHelper.replaceSystemProperties(XMLHelper.getXMLStreamReader(inputStream), XMLHelper.getXMLStreamWriter(sw));
                jbossEsbXml = sw.toString();
            }
            finally {
                inputStream.close();
            }
            HashSet<ObjectName> deps = new HashSet<ObjectName>();
            JbossesbDocument.Jbossesb jbossEsb = this.getJbossEsb(jbossEsbXml);
            this.addActionDependencies(di.shortName, jbossEsb, deps);
            JBoss4ESBDeployment deployment = new JBoss4ESBDeployment(jbossEsbXml, di.shortName);
            this.initialiseDeploymentName(deployment);
            String deploymentName = deployment.getDeploymentName();
            di.context.put(JBoss4ESBDeploymentMetaData.class, new JBoss4ESBDeploymentMetaData(deployment, deploymentName, deps));
            super.init(di);
            ClassLoader origCL = Thread.currentThread().getContextClassLoader();
            ArrayList<ContractReferencePublisher> publishers = new ArrayList<ContractReferencePublisher>();
            try {
                Thread.currentThread().setContextClassLoader(di.localCl);
                warFile = this.createWebserviceWars(di.shortName, jbossEsb, deploymentName, publishers);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origCL);
            }
            if (warFile != null) {
                deployment.setPublishers(publishers);
                URL warFileURL = warFile.toURL();
                this.deployUrl(di, warFileURL, warFile.getName());
            }
        }
        catch (Exception e) {
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException("failed to initialize", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void create(DeploymentInfo di) throws DeploymentException {
        log.info((Object)("create esb service, " + di.shortName));
        try {
            String name;
            ObjectName on;
            JBoss4ESBDeploymentMetaData metaData = (JBoss4ESBDeploymentMetaData)di.context.get(JBoss4ESBDeploymentMetaData.class);
            Set<ObjectName> deps = metaData.getDependencies();
            InputStream in = di.localCl.getResourceAsStream("META-INF/deployment.xml");
            if (in != null) {
                try {
                    Iterator esbDepends;
                    XmlFileLoader xfl = new XmlFileLoader();
                    Element jboss = xfl.getDocument(in, "META-INF/deployment.xml").getDocumentElement();
                    Iterator depends = MetaData.getChildrenByTagName((Element)jboss, (String)"depends");
                    if (depends != null) {
                        while (depends.hasNext()) {
                            Element depend = (Element)depends.next();
                            ObjectName depOn = new ObjectName(MetaData.getElementContent((Element)depend));
                            deps.add(depOn);
                        }
                    }
                    if ((esbDepends = MetaData.getChildrenByTagName((Element)jboss, (String)"esb-depends")) != null && esbDepends.hasNext()) {
                        HashMap<String, DeploymentInfo> subDeploymentLocationMap;
                        if (di.subDeployments.size() > 0) {
                            subDeploymentLocationMap = new HashMap<String, DeploymentInfo>();
                            Set subDeployments = di.subDeployments;
                            for (DeploymentInfo subDI : subDeployments) {
                                String urlPath = subDI.url.getPath();
                                String deployablePath = urlPath.endsWith("/") ? urlPath.substring(0, urlPath.length() - 1) : urlPath;
                                int lastSeparator = deployablePath.lastIndexOf(47);
                                String deployable = lastSeparator >= 0 ? deployablePath.substring(lastSeparator + 1) : deployablePath;
                                if (subDeploymentLocationMap.put(deployable, subDI) == null) continue;
                                throw new DeploymentException("Duplicate subDeployment name: " + deployable);
                            }
                        } else {
                            throw new DeploymentException("No subdeployments to match esb-depends");
                        }
                        do {
                            Element depend;
                            String deployable;
                            DeploymentInfo subDI;
                            if ((subDI = (DeploymentInfo)subDeploymentLocationMap.get(deployable = MetaData.getElementContent((Element)(depend = (Element)esbDepends.next())))) == null || !subDI.context.containsKey("org.jboss.web.AbstractWebContainer.webModule")) {
                                throw new DeploymentException("Could not locate WAR subdeployment matching: " + deployable);
                            }
                            ObjectName jmxName = (ObjectName)subDI.context.get("org.jboss.web.AbstractWebContainer.webModule");
                            deps.add(jmxName);
                        } while (esbDepends.hasNext());
                    }
                }
                finally {
                    in.close();
                }
            }
            if (this.server.isRegistered(on = ObjectNameConverter.convert((String)(name = PREFIX_CANONICAL_NAME + metaData.getDeploymentName())))) {
                throw new DeploymentException("Duplicate registration for " + name);
            }
            JBoss4ESBDeployment deployment = metaData.getDeployment();
            deployment.setClassloader((ClassLoader)di.ucl);
            this.server.registerMBean(deployment, on);
            di.deployedObject = on;
            log.debug((Object)("Deploying: " + di.url));
            this.serviceController.create(di.deployedObject, deps);
        }
        catch (Exception e) {
            throw new DeploymentException("Error during create of ESB Module: " + di.url, (Throwable)e);
        }
        super.create(di);
    }

    private JbossesbDocument.Jbossesb getJbossEsb(String configuration) throws DeploymentException {
        try {
            StringReader sr = new StringReader(configuration);
            return JbossesbDocument.Factory.parse((Reader)sr).getJbossesb();
        }
        catch (Exception ex) {
            throw new DeploymentException("Failed to parse jboss-esb.xml", (Throwable)ex);
        }
    }

    private void addActionDependencies(String deploymentName, JbossesbDocument.Jbossesb jbossEsb, Set<ObjectName> deps) throws MalformedObjectNameException {
        HashSet<String> artifacts = new HashSet<String>();
        artifacts.add(ESB_ARTIFACT_NAME);
        ServicesDocument.Services services = jbossEsb.getServices();
        if (services != null) {
            HashSet<String> actionClasses = new HashSet<String>();
            for (ServiceDocument.Service service : services.getServiceList()) {
                ActionsDocument.Actions actions = service.getActions();
                if (actions == null) continue;
                for (ActionDocument.Action action : actions.getActionList()) {
                    actionClasses.add(action.getClass1());
                }
            }
            int numActionClasses = actionClasses.size();
            if (numActionClasses > 0) {
                for (String actionClass : actionClasses) {
                    String artifact = (String)this.actionArtifactProperties.get(actionClass);
                    if (artifact == null) continue;
                    artifacts.add(artifact);
                }
            }
        }
        for (String artifact : artifacts) {
            if (deploymentName.equals(artifact)) continue;
            String canonicalName = PREFIX_CANONICAL_NAME + artifact;
            ObjectName on = ObjectNameConverter.convert((String)canonicalName);
            deps.add(on);
        }
    }

    private File createWebserviceWars(String esbName, JbossesbDocument.Jbossesb jbossEsb, String deploymentName, List<ContractReferencePublisher> publishers) throws DeploymentException {
        ServicesDocument.Services services = jbossEsb.getServices();
        if (services != null) {
            ArrayList<ServiceDocument.Service> endpointServices = new ArrayList<ServiceDocument.Service>();
            for (ServiceDocument.Service service : jbossEsb.getServices().getServiceList()) {
                String inXsd;
                ActionsDocument.Actions actions = service.getActions();
                if (actions == null || actions.isSetWebservice() && !actions.getWebservice() || (inXsd = actions.getInXsd()) == null) continue;
                endpointServices.add(service);
            }
            if (endpointServices.size() > 0) {
                StringWriter servletDefinition = new StringWriter();
                StringWriter servletMapping = new StringWriter();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(baos);
                zos.setComment("ESB war file for exposing webservices: " + esbName);
                try {
                    JAXWSProviderClassGenerator generator = new JAXWSProviderClassGenerator();
                    for (ServiceDocument.Service service : endpointServices) {
                        ESBServiceEndpointInfo serviceInfo = new ESBServiceEndpointInfo(service);
                        String wsdl = ESBContractGenerator.generateWSDL(service, serviceInfo);
                        this.addFile(zos, serviceInfo.getWSDLFileName(), wsdl);
                        byte[] wsClass = generator.generate(service.getCategory(), service.getName(), serviceInfo);
                        String wsClassName = serviceInfo.getClassName().replace('.', '/') + ".class";
                        this.addFile(zos, "WEB-INF/classes/" + wsClassName, wsClass);
                        servletDefinition.append("<servlet><servlet-name>");
                        servletDefinition.append(serviceInfo.getServletName());
                        servletDefinition.append("</servlet-name><servlet-class>");
                        servletDefinition.append(serviceInfo.getClassName());
                        servletDefinition.append("</servlet-class></servlet>");
                        servletMapping.append("<servlet-mapping><servlet-name>");
                        servletMapping.append(serviceInfo.getServletName());
                        servletMapping.append("</servlet-name><url-pattern>");
                        servletMapping.append(serviceInfo.getServletPath());
                        servletMapping.append("</url-pattern></servlet-mapping>");
                        Service esbService = new Service(service.getCategory(), service.getName());
                        ESBServiceContractPublisher publisher = new ESBServiceContractPublisher(esbService, service.getDescription(), serviceInfo.getServletName());
                        publishers.add(publisher);
                    }
                    StringWriter webXml = new StringWriter();
                    webXml.append("<web-app xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                    webXml.append(" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\" version=\"2.4\">");
                    webXml.append(servletDefinition.getBuffer());
                    webXml.append(servletMapping.getBuffer());
                    webXml.append("</web-app>");
                    this.addFile(zos, "WEB-INF/web.xml", webXml.toString());
                    zos.close();
                    File warFile = this.getESBWarFile(deploymentName, esbName, true);
                    FileOutputStream fos = new FileOutputStream(warFile);
                    fos.write(baos.toByteArray());
                    fos.close();
                    return warFile;
                }
                catch (Exception ex) {
                    throw new DeploymentException("Failed to create webservice artifact", (Throwable)ex);
                }
            }
        }
        return null;
    }

    private void addFile(ZipOutputStream zos, String filename, String contents) throws IOException {
        this.addFile(zos, filename, contents.getBytes());
    }

    private void addFile(ZipOutputStream zos, String filename, byte[] contents) throws IOException {
        ZipEntry entry = new ZipEntry(filename);
        zos.putNextEntry(entry);
        zos.write(contents);
        zos.closeEntry();
    }

    public synchronized void start(DeploymentInfo di) throws DeploymentException {
        try {
            this.serviceController.start(di.deployedObject);
        }
        catch (Exception e) {
            try {
                this.stop(di);
                this.destroy(di);
            }
            catch (DeploymentException deploymentException) {
                // empty catch block
            }
            throw new DeploymentException("Error during start of ESB Module: " + di.url, (Throwable)e);
        }
        super.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        if (di.deployedObject != null) {
            try {
                this.serviceController.stop(di.deployedObject);
            }
            catch (Exception e) {
                throw new DeploymentException("Error during stop of ESB Module: " + di.url, (Throwable)e);
            }
        }
        super.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        JBoss4ESBDeploymentMetaData metaData = (JBoss4ESBDeploymentMetaData)di.context.get(JBoss4ESBDeploymentMetaData.class);
        if (metaData != null) {
            String deploymentName = metaData.getDeploymentName();
            File warFile = this.getESBWarFile(deploymentName, di.shortName, false);
            if (warFile != null) {
                warFile.delete();
                warFile.getParentFile().delete();
            }
            this.removeDeploymentName(deploymentName);
        }
        if (di.deployedObject != null) {
            try {
                this.serviceController.destroy(di.deployedObject);
                this.server.unregisterMBean(di.deployedObject);
            }
            catch (Exception e) {
                throw new DeploymentException("Error during stop of ESB Module: " + di.url, (Throwable)e);
            }
        }
        super.destroy(di);
    }

    private File getESBWarFile(String deploymentName, String esbName, boolean createDir) {
        File esbDir = new File(this.esbWarFiles, deploymentName);
        if (!esbDir.exists()) {
            if (!createDir) {
                return null;
            }
            esbDir.mkdir();
        }
        int lastSeparator = esbName.lastIndexOf(46);
        String warFileName = (lastSeparator >= 0 ? esbName.substring(0, lastSeparator) : esbName) + ".war";
        return new File(esbDir, warFileName);
    }

    private synchronized void initialiseDeploymentName(JBoss4ESBDeployment deployment) {
        String deploymentName = deployment.getDeploymentName();
        if (!this.esbNames.add(deploymentName)) {
            deployment.setDeploymentName(deploymentName + ",uid=" + System.identityHashCode(deployment));
        }
    }

    private synchronized void removeDeploymentName(String deploymentName) {
        this.esbNames.remove(deploymentName);
    }
}

