/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.ESBAwareGenerator;
import org.jboss.soa.esb.listeners.config.GatewayGenerator;
import org.jboss.soa.esb.listeners.config.xbeanmodel.AbstractScheduledListener;
import org.jboss.soa.esb.listeners.config.xbeanmodel.Bus;
import org.jboss.soa.esb.listeners.config.xbeanmodel.BusProvider;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JbossesbDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JcaGatewayDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ListenersDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.PropertyDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.Provider;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ProvidersDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.Schedule;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ScheduleProviderDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ServiceDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ServicesDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator {
    private static Logger logger = Logger.getLogger(Generator.class);
    public static final String ESB_CONFIG_GATEWAY_XML_FILE = "jbossesb-gateway.xml";
    public static final String ESB_CONFIG_XML_FILE = "jbossesb-listener.xml";
    private XMLBeansModel model;
    private OutputStream gatewayOutputStream;
    private OutputStream listenerOutputStream;

    public Generator(InputStream config, OutputStream listenerOutputStream, OutputStream gatewayOutputStream) throws ConfigurationException, IOException {
        this(config);
        this.gatewayOutputStream = gatewayOutputStream;
        this.listenerOutputStream = listenerOutputStream;
    }

    public Generator(InputStream config) throws ConfigurationException, IOException {
        if (config == null) {
            throw new IllegalArgumentException("null 'config' arg in constructor call.");
        }
        this.model = Generator.parseConfig(config);
        this.assertOneScheduleProviderConfig(this.model);
    }

    private void assertOneScheduleProviderConfig(XMLBeansModel model) throws ConfigurationException {
        ProvidersDocument.Providers providersConfig = model.jbossesb.getProviders();
        if (providersConfig == null) {
            return;
        }
        List providers = providersConfig.getProviderList();
        int numScheduleProviders = 0;
        for (Provider provider : providers) {
            if (!(provider instanceof ScheduleProviderDocument.ScheduleProvider)) continue;
            ++numScheduleProviders;
        }
        if (numScheduleProviders > 1) {
            throw new ConfigurationException("Configuration contains " + numScheduleProviders + " <schedule-provider> configurations.  Only one of this provider type can exist per configuration.");
        }
    }

    public static XMLBeansModel parseConfig(InputStream config) throws IOException, ConfigurationException {
        try {
            JbossesbDocument doc = JbossesbDocument.Factory.parse((InputStream)config);
            return new XMLBeansModel(doc);
        }
        catch (XmlException e) {
            throw new ConfigurationException("Error while processing ESB Listener configuration stream.", e);
        }
    }

    public void generate() throws ConfigurationException {
        ESBAwareGenerator awareGenerator = new ESBAwareGenerator(this.model);
        Document awareConfig = awareGenerator.generate();
        YADOMUtil.serialize((Node)awareConfig, this.listenerOutputStream);
        GatewayGenerator gatewayGenerator = new GatewayGenerator(this.model);
        Document gatewayConfig = gatewayGenerator.generate();
        YADOMUtil.serialize((Node)gatewayConfig, this.gatewayOutputStream);
    }

    public void generate(File outdir) throws ConfigurationException {
        if (outdir == null) {
            throw new IllegalArgumentException("null 'outdir' arg in method call.");
        }
        if (!outdir.exists()) {
            outdir.mkdirs();
            if (!outdir.exists()) {
                throw new IllegalArgumentException("Failed to create 'outdir' [" + outdir.getAbsolutePath() + "].");
            }
        }
        if (!outdir.isDirectory()) {
            throw new IllegalArgumentException("'outdir' exists, but is not a directory.");
        }
        ESBAwareGenerator awareGenerator = new ESBAwareGenerator(this.model);
        Document awareConfig = awareGenerator.generate();
        logger.info((Object)("Serializing ESB Aware Listener 'ConfigTree' configuration to [" + new File(outdir, ESB_CONFIG_XML_FILE).getAbsolutePath() + "]."));
        YADOMUtil.serialize((Node)awareConfig, outdir, ESB_CONFIG_XML_FILE);
        GatewayGenerator gatewayGenerator = new GatewayGenerator(this.model);
        Document gatewayConfig = gatewayGenerator.generate();
        logger.info((Object)("Serializing ESB Gateway 'ConfigTree' configuration to [" + new File(outdir, ESB_CONFIG_GATEWAY_XML_FILE).getAbsolutePath() + "]."));
        YADOMUtil.serialize((Node)gatewayConfig, outdir, ESB_CONFIG_GATEWAY_XML_FILE);
    }

    public static Properties toProperties(List<PropertyDocument.Property> configProperties) {
        Properties properties = new Properties();
        for (PropertyDocument.Property property : configProperties) {
            properties.setProperty(property.getName(), property.getValue());
        }
        return properties;
    }

    public XMLBeansModel getModel() {
        return this.model;
    }

    public static boolean exposesInVMListener(ServiceDocument.Service service) {
        if (service.xgetInvmScope() != null && service.xgetInvmScope().getStringValue() != null) {
            return service.xgetInvmScope().getStringValue().equals("GLOBAL");
        }
        String systemDefaultScope = System.getProperty("jboss.esb.invm.scope.default", "GLOBAL");
        String defaultScope = ModulePropertyManager.getPropertyManager("core").getProperty("jboss.esb.invm.scope.default", systemDefaultScope);
        return defaultScope.equals("GLOBAL");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLBeansModel {
        private JbossesbDocument.Jbossesb jbossesb;

        private XMLBeansModel(JbossesbDocument xmlBeansDoc) {
            this.jbossesb = xmlBeansDoc.getJbossesb();
        }

        public List<Listener> getGatewayListeners() throws ConfigurationException {
            return this.getListeners(true);
        }

        public List<Listener> getESBAwareListeners() throws ConfigurationException {
            return this.getListeners(false);
        }

        public ServiceDocument.Service getService(Listener listener) {
            List<ServiceDocument.Service> services = this.getServices();
            for (ServiceDocument.Service service : services) {
                List listenerList;
                ListenersDocument.Listeners listeners = service.getListeners();
                if (listeners == null || (listenerList = listeners.getListenerList()) == null) continue;
                for (Listener serviceListener : listenerList) {
                    if (serviceListener != listener) continue;
                    return service;
                }
            }
            throw new IllegalStateException("No Service instance found for the supplied Listener instance.  This should not be possible if the Listener instance was provided by this configuration.  Where has this Listener instance come from?");
        }

        public List<ServiceDocument.Service> getServices() {
            ServicesDocument.Services services = this.jbossesb.getServices();
            if (services != null) {
                return this.jbossesb.getServices().getServiceList();
            }
            return Collections.emptyList();
        }

        public Bus getBus(String busid) throws ConfigurationException {
            List providers = this.jbossesb.getProviders().getProviderList();
            for (Provider provider : providers) {
                if (!(provider instanceof BusProvider)) continue;
                List buses = ((BusProvider)provider).getBusList();
                for (Bus bus : buses) {
                    if (!bus.getBusid().equals(busid)) continue;
                    return bus;
                }
            }
            throw new ConfigurationException("Invalid ESB Configuration: No <bus> configuration matching busid reference value [" + busid + "].");
        }

        public Provider getProvider(Bus bus) {
            List providers = this.jbossesb.getProviders().getProviderList();
            for (Provider provider : providers) {
                if (!(provider instanceof BusProvider)) continue;
                List buses = ((BusProvider)provider).getBusList();
                for (Bus installedBus : buses) {
                    if (installedBus != bus) continue;
                    return provider;
                }
            }
            throw new IllegalStateException("No Provider instance found for the supplied Bus config instance.  This should not be possible if the Bus instance was provided by this configuration.  Where has this Bus instance come from?");
        }

        public Schedule getSchedule(String id) {
            if (id == null || this.jbossesb.getProviders() == null) {
                return null;
            }
            List providers = this.jbossesb.getProviders().getProviderList();
            for (Provider provider : providers) {
                if (!(provider instanceof ScheduleProviderDocument.ScheduleProvider)) continue;
                ScheduleProviderDocument.ScheduleProvider scheduleProvider = (ScheduleProviderDocument.ScheduleProvider)provider;
                List schedules = scheduleProvider.getScheduleList();
                for (Schedule schedule : schedules) {
                    if (!id.equals(schedule.getScheduleid())) continue;
                    return schedule;
                }
            }
            return null;
        }

        public ScheduleProviderDocument.ScheduleProvider getScheduleProvider() {
            if (this.jbossesb.getProviders() == null) {
                return null;
            }
            List providers = this.jbossesb.getProviders().getProviderList();
            for (Provider provider : providers) {
                if (!(provider instanceof ScheduleProviderDocument.ScheduleProvider)) continue;
                return (ScheduleProviderDocument.ScheduleProvider)provider;
            }
            return null;
        }

        public int getScheduledListenerCount() {
            int count = 0;
            if (this.jbossesb.getServices() != null) {
                List<ServiceDocument.Service> services = this.getServices();
                for (ServiceDocument.Service service : services) {
                    ListenersDocument.Listeners listeners = service.getListeners();
                    if (listeners == null) continue;
                    for (Listener listener : listeners.getListenerList()) {
                        if (!(listener instanceof AbstractScheduledListener)) continue;
                        ++count;
                    }
                }
            }
            return count;
        }

        private boolean isGateway(Listener listener) {
            return listener.getIsGateway() || listener instanceof JcaGatewayDocument.JcaGateway;
        }

        private List<Listener> getListeners(boolean isGateway) throws ConfigurationException {
            ArrayList<Listener> gateways = new ArrayList<Listener>();
            if (this.jbossesb.getServices() != null) {
                List<ServiceDocument.Service> services = this.getServices();
                for (ServiceDocument.Service service : services) {
                    boolean listenerAdded = false;
                    ListenersDocument.Listeners listeners = service.getListeners();
                    if (listeners != null) {
                        for (Listener listener : listeners.getListenerList()) {
                            if (this.isGateway(listener) != isGateway) continue;
                            gateways.add(listener);
                            listenerAdded = true;
                        }
                    }
                    if (Generator.exposesInVMListener(service) || isGateway || listenerAdded) continue;
                    throw new ConfigurationException("Service configuration for Service '" + service.getCategory() + ":" + service.getName() + "' doesn't define a Message-Aware Listener (i.e. is-gateway='false').");
                }
            }
            return gateways;
        }

        public String getParameterReloadSecs() {
            return this.jbossesb.getParameterReloadSecs().getStringValue();
        }

        public static String getProperty(List<PropertyDocument.Property> properties, String name, String defaultVal) {
            for (PropertyDocument.Property property : properties) {
                if (!property.getName().equals(name)) continue;
                return property.getValue();
            }
            return defaultVal;
        }
    }
}

