/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.config;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.Generator;
import org.jboss.soa.esb.listeners.config.mappers.FsListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.FtpListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.GroovyListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.HibernateListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.JbrListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.JcaGatewayMapper;
import org.jboss.soa.esb.listeners.config.mappers.JmsListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.ScheduleMapper;
import org.jboss.soa.esb.listeners.config.mappers.SqlListenerMapper;
import org.jboss.soa.esb.listeners.config.mappers.UntypedListenerMapper;
import org.jboss.soa.esb.listeners.config.xbeanmodel.AbstractScheduledListener;
import org.jboss.soa.esb.listeners.config.xbeanmodel.FsListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.FtpListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.GroovyListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.HibernateListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JbrListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JcaGatewayDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.JmsListenerDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.Listener;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ServiceDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.SqlListenerDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GatewayGenerator {
    private static final Logger logger = Logger.getLogger(GatewayGenerator.class);
    private Generator.XMLBeansModel model;

    public GatewayGenerator(Generator.XMLBeansModel model) {
        this.model = model;
    }

    public Document generate() throws ConfigurationException {
        Document doc = YADOMUtil.createDocument();
        doc.appendChild(doc.createComment("\n\tNOTE: DO NOT MODIFY\n\tThis file was auto-generated.\n"));
        Element root = YADOMUtil.addElement(doc, "jbossesb-gateways");
        root.setAttribute("parameterReloadSecs", this.model.getParameterReloadSecs());
        List<ServiceDocument.Service> services = this.model.getServices();
        HashMap<String, HashMap> hm = new HashMap<String, HashMap>();
        for (ServiceDocument.Service service : services) {
            HashMap hc;
            if (hm.containsKey(service.getCategory())) {
                hc = (HashMap)hm.get(service.getCategory());
                if (hc.containsKey(service.getName())) {
                    throw new ConfigurationException("Service names must be unique within a category.  The service name " + service.getName() + " is already defined within the " + service.getCategory() + " category.");
                }
                hc.put(service.getName(), service.getName());
                continue;
            }
            hc = new HashMap();
            hc.put(service.getName(), service.getName());
            hm.put(service.getCategory(), hc);
        }
        List<Listener> gateways = this.model.getGatewayListeners();
        for (Listener gateway : gateways) {
            this.addGatewayConfig(root, gateway);
        }
        return doc;
    }

    private void addGatewayConfig(Element root, Listener gateway) throws ConfigurationException {
        Element listenerConfig = gateway instanceof JmsListenerDocument.JmsListener ? JmsListenerMapper.map(root, (JmsListenerDocument.JmsListener)gateway, this.model) : (gateway instanceof FsListenerDocument.FsListener ? FsListenerMapper.map(root, (FsListenerDocument.FsListener)gateway, this.model) : (gateway instanceof JcaGatewayDocument.JcaGateway ? JcaGatewayMapper.map(root, (JcaGatewayDocument.JcaGateway)gateway, this.model) : (gateway instanceof FtpListenerDocument.FtpListener ? FtpListenerMapper.map(root, (FtpListenerDocument.FtpListener)gateway, this.model) : (gateway instanceof SqlListenerDocument.SqlListener ? SqlListenerMapper.map(root, (SqlListenerDocument.SqlListener)gateway, this.model) : (gateway instanceof JbrListenerDocument.JbrListener ? JbrListenerMapper.map(root, (JbrListenerDocument.JbrListener)gateway, this.model) : (gateway instanceof GroovyListenerDocument.GroovyListener ? GroovyListenerMapper.map(root, (GroovyListenerDocument.GroovyListener)gateway, this.model) : (gateway instanceof HibernateListenerDocument.HibernateListener ? HibernateListenerMapper.map(root, (HibernateListenerDocument.HibernateListener)gateway, this.model) : UntypedListenerMapper.map(root, gateway, this.model))))))));
        if (gateway instanceof AbstractScheduledListener) {
            ScheduleMapper.map(listenerConfig, (AbstractScheduledListener)gateway, this.model);
        }
    }
}

