/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Initializable;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ScheduledEventMessageComposer;
import org.jboss.soa.esb.listeners.lifecycle.AbstractScheduledManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.message.ActionProcessingPipeline;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.schedule.ScheduledEventListener;
import org.jboss.soa.esb.schedule.SchedulingException;
import org.jboss.soa.esb.util.ClassUtil;

public class ScheduleListener
extends AbstractScheduledManagedLifecycle {
    private static final long serialVersionUID = 1L;
    private ActionProcessingPipeline pipeline;
    private Initializable eventProcessor;
    private final TransactionStrategy transactionStrategy;

    public ScheduleListener(ConfigTree config) throws ConfigurationException {
        super(config);
        String eventProcessorClass = config.getRequiredAttribute("event-processor");
        try {
            this.eventProcessor = (Initializable)ClassUtil.forName(eventProcessorClass, ScheduleListener.class).newInstance();
        }
        catch (ClassCastException e) {
            this.throwBadImplException(eventProcessorClass);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Event Processor class [" + eventProcessorClass + "] not found in classpath.", e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate Event Processor class [" + eventProcessorClass + "].", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to instantiate Event Processor class [" + eventProcessorClass + "].", e);
        }
        boolean transacted = config.getBooleanAttribute("transacted", false);
        this.transactionStrategy = TransactionStrategy.getTransactionStrategy(transacted);
        if (!(this.eventProcessor instanceof ScheduledEventListener) && !(this.eventProcessor instanceof ScheduledEventMessageComposer)) {
            this.throwBadImplException(eventProcessorClass);
        }
        this.eventProcessor.initialize(config);
        if (this.eventProcessor instanceof ScheduledEventMessageComposer) {
            this.pipeline = new ActionProcessingPipeline(this.getConfig());
            this.pipeline.initialise();
        }
    }

    private void throwBadImplException(String eventProcessorClass) throws ConfigurationException {
        throw new ConfigurationException("The 'even-processor' class '" + eventProcessorClass + "' must implement one of '" + ScheduledEventMessageComposer.class.getName() + "' or '" + ScheduledEventListener.class.getName() + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchedule() throws SchedulingException {
        try {
            this.transactionStrategy.begin();
            boolean rollbackOnly = true;
            try {
                if (this.eventProcessor instanceof ScheduledEventMessageComposer) {
                    ScheduledEventMessageComposer composer = (ScheduledEventMessageComposer)this.eventProcessor;
                    Message message = composer.composeMessage();
                    if (message != null) {
                        this.pipeline.process(message);
                        composer.onProcessingComplete(message);
                    }
                } else {
                    ((ScheduledEventListener)this.eventProcessor).onSchedule();
                }
                rollbackOnly = false;
            }
            finally {
                if (rollbackOnly) {
                    this.transactionStrategy.rollbackOnly();
                }
                this.transactionStrategy.terminate();
            }
        }
        catch (TransactionStrategyException tse) {
            throw new SchedulingException("Unexpected transaction strategy exception", tse);
        }
    }

    protected void doScheduledDestroy() throws ManagedLifecycleException {
        this.eventProcessor.uninitialize();
        if (this.pipeline != null) {
            this.pipeline.destroy();
        }
    }
}

