/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.FTPSEpr;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.addressing.eprs.JDBCEpr;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.addressing.eprs.SFTPEpr;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.util.Util;

public class ListenerUtil {
    private static Logger logger = Logger.getLogger(ListenerUtil.class);
    private static final String s_Sfx = "_column";
    private static final boolean LOGWARN = true;
    private static final Logger _logger = Logger.getLogger(ListenerUtil.class);

    private ListenerUtil() {
    }

    public static void tryToDeliver(Message message, String category, String name) throws MessageDeliverException, JMSException, RegistryException {
        logger.warn((Object)("**** DEPRECATED ***: Please do not call '" + ListenerUtil.class.getSimpleName() + ".tryToDeliver'! Use '" + ServiceInvoker.class.getSimpleName() + ".deliverAsync' instead."));
        new ServiceInvoker(category, name).deliverAsync(message);
    }

    public static EPR assembleEpr(ConfigTree tree) throws ConfigurationException {
        String urlString = tree.getAttribute("URL");
        String protocol = null == urlString ? tree.getAttribute("protocol") : urlString.split(":")[0];
        try {
            if ("invm".equals(protocol)) {
                return ListenerUtil.inVMEprFromElement(tree);
            }
            if ("jms".equals(protocol)) {
                return ListenerUtil.jmsEprFromElement(tree);
            }
            if ("file".equals(protocol)) {
                return ListenerUtil.fileEprFromElement(tree);
            }
            if ("ftp".equals(protocol)) {
                return ListenerUtil.fileEprFromElement(tree);
            }
            if ("ftps".equals(protocol)) {
                return ListenerUtil.fileEprFromElement(tree);
            }
            if ("sftp".equals(protocol)) {
                return ListenerUtil.fileEprFromElement(tree);
            }
            if ("jdbc".equals(protocol)) {
                return ListenerUtil.jdbcEprFromElement(tree);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            _logger.error((Object)"Problem", (Throwable)e);
            throw new ConfigurationException(e);
        }
        throw new ConfigurationException("Unknown protocol <" + protocol + ">");
    }

    public static InVMEpr inVMEprFromElement(ConfigTree tree) throws ConfigurationException {
        try {
            String uriString = tree.getRequiredAttribute("URL");
            URI uri = new URI(uriString);
            String protocol = uri.getScheme();
            if (protocol.equals("invm")) {
                return new InVMEpr(uri);
            }
            throw new ConfigurationException("Not an InVMEpr");
        }
        catch (URISyntaxException ex) {
            throw new ConfigurationException(ex);
        }
        catch (ConfigurationException ex) {
            throw ex;
        }
    }

    public static JMSEpr jmsEprFromElement(ConfigTree tree) throws ConfigurationException {
        try {
            String name = tree.getRequiredAttribute("destination-name");
            Set<String> names = tree.getAttributeNames();
            Properties environment = new Properties();
            String jndiPrefixesValue = tree.getAttribute("jndi-prefixes");
            if (jndiPrefixesValue != null) {
                environment.put("jndi-prefixes", jndiPrefixesValue);
            }
            String[] jndiPrefixes = JMSEpr.getJndiPrefixes(jndiPrefixesValue);
            block2: for (String attributeName : names) {
                for (String jndiPrefix : jndiPrefixes) {
                    if (!attributeName.startsWith(jndiPrefix)) continue;
                    environment.setProperty(attributeName, tree.getAttribute(attributeName));
                    continue block2;
                }
            }
            String type = ListenerUtil.getAttrAndWarn(tree, "destination-type", "queue");
            String jndiURL = tree.getAttribute("jndi-URL");
            if (jndiURL == null) {
                jndiURL = Configuration.getJndiServerURL();
            }
            environment.setProperty("java.naming.provider.url", jndiURL);
            String jndiContextFactory = tree.getAttribute("jndi-context-factory");
            if (jndiContextFactory == null) {
                jndiContextFactory = Configuration.getJndiServerContextFactory();
            }
            environment.setProperty("java.naming.factory.initial", jndiContextFactory);
            String jndiPkgPrefix = tree.getAttribute("jndi-pkg-prefix");
            if (jndiPkgPrefix == null) {
                jndiPkgPrefix = Configuration.getJndiServerPkgPrefix();
            }
            environment.setProperty("java.naming.factory.url.pkgs", jndiPkgPrefix);
            String jmsFactoryClass = ListenerUtil.getAttrAndWarn(tree, "connection-factory", "ConnectionFactory");
            String selector = tree.getAttribute("message-selector");
            if (Util.isNullString(selector)) {
                _logger.debug((Object)("No value specified for message-selector attribute -  All messages in queue <" + name + "> will be picked up by listener"));
            }
            String username = tree.getAttribute("jms-security-principal");
            String password = tree.getAttribute("jms-security-credential");
            JMSEpr epr = new JMSEpr("1.1", type, name, jmsFactoryClass, environment, selector, Boolean.valueOf(tree.getAttribute("persistent")), tree.getAttribute("acknowledge-mode"), username, password, Boolean.valueOf(tree.getAttribute("transacted")));
            return epr;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static FileEpr fileEprFromElement(ConfigTree tree) throws ConfigurationException {
        try {
            String cert;
            FileEpr epr;
            String urlString = tree.getRequiredAttribute("URL");
            URI uri = new URI(urlString);
            String scheme = uri.getScheme();
            if ("file".equals(scheme)) {
                if (!new File(uri).isDirectory()) {
                    throw new ConfigurationException("Attribute URL must reference a directory");
                }
                epr = new FileEpr(uri);
            } else if ("ftp".equals(scheme)) {
                epr = new FTPEpr(uri);
            } else if ("ftps".equals(scheme)) {
                cert = tree.getAttribute("certificate");
                String name = tree.getAttribute("certificateName");
                epr = new FTPSEpr(uri, cert, name);
            } else if ("sftp".equals(scheme)) {
                cert = tree.getAttribute("certificate");
                if (cert == null) {
                    epr = new SFTPEpr(uri);
                } else {
                    String passphrase = tree.getAttribute("passphrase");
                    epr = new SFTPEpr(uri, new URI(cert), passphrase);
                }
            } else {
                throw new ConfigurationException("Unsupported file protocol : " + scheme);
            }
            String inputSuffix = tree.getAttribute("inputSuffix");
            if (!Util.isNullString(inputSuffix)) {
                epr.setInputSuffix(inputSuffix);
            }
            boolean bErrorDel = Boolean.parseBoolean(ListenerUtil.getAttrAndWarn(tree, "errorDelete", "true"));
            String errorDir = tree.getAttribute("errorDir");
            String errorSuffix = tree.getAttribute("errorSuffix");
            if (bErrorDel && (null != errorDir || null != errorSuffix)) {
                _logger.warn((Object)"If you don't specify errorDelete'false' ,errorDir and errorSuffix will have no effect because files in error will be deleted");
            }
            if (null == errorDir) {
                errorDir = uri.getPath();
                ListenerUtil.warnDefault("errorDir", errorDir);
            }
            if (null == errorSuffix) {
                errorSuffix = ".esbERROR";
                ListenerUtil.warnDefault("errorSuffix", errorSuffix);
            }
            epr.setErrorDelete(bErrorDel);
            epr.setErrorDirectory(errorDir);
            epr.setErrorSuffix(errorSuffix);
            boolean bPostDel = Boolean.parseBoolean(ListenerUtil.getAttrAndWarn(tree, "postDelete", "true"));
            boolean bPostRemove = Boolean.parseBoolean(ListenerUtil.getAttrAndWarn(tree, "postRename", "true"));
            epr.setPostRename(bPostRemove);
            String postDir = tree.getAttribute("postDir");
            String postSuffix = tree.getAttribute("postSuffix");
            if (bPostDel && (null != postDir || null != postSuffix)) {
                _logger.warn((Object)"If you don't specify postDelete'false' ,postDir and postSuffix will have no effect because processed input messages will be deleted");
            }
            if (null == postDir) {
                postDir = uri.getPath();
                ListenerUtil.warnDefault("postDir", postDir);
            }
            if (null == postSuffix) {
                postSuffix = ".esbDONE";
                ListenerUtil.warnDefault("postSuffix", postSuffix);
            }
            epr.setPostDelete(bPostDel);
            epr.setPostDirectory(postDir);
            epr.setPostSuffix(postSuffix);
            if (epr instanceof FTPEpr) {
                FTPEpr ftp = (FTPEpr)epr;
                ftp.setPassive(Boolean.valueOf(ListenerUtil.getAttrAndWarn(tree, "passive", "false")));
            }
            return epr;
        }
        catch (URISyntaxException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public static JDBCEpr jdbcEprFromElement(ConfigTree tree) throws ConfigurationException {
        String url = tree.getRequiredAttribute("URL");
        if (!url.toLowerCase().startsWith("jdbc")) {
            throw new ConfigurationException("URL in URL must be a jdbc URL");
        }
        try {
            boolean bPostDel = Boolean.valueOf(tree.getAttribute("postDelete", "true"));
            boolean bErrorDel = Boolean.valueOf(tree.getAttribute("errorDelete", "true"));
            JDBCEpr epr = new JDBCEpr(url, bPostDel, bErrorDel);
            String datasource = tree.getAttribute("datasource");
            if (datasource == null) {
                epr.setDriver(tree.getRequiredAttribute("driver"));
                epr.setUserName(ListenerUtil.getAttrAndWarn(tree, "username", ""));
                epr.setPassword(ListenerUtil.getAttrAndWarn(tree, "password", ""));
            } else {
                epr.setDatasource(datasource);
            }
            epr.setTableName(tree.getRequiredAttribute("tablename"));
            epr.setMessageIdColumn(ListenerUtil.getColName(tree, "message_id_column"));
            epr.setStatusColumn(ListenerUtil.getColName(tree, "status_column"));
            epr.setDataColumn(ListenerUtil.getColName(tree, "message_column"));
            epr.setTimestampColumn(ListenerUtil.getColName(tree, "insert_timestamp_column"));
            return epr;
        }
        catch (URISyntaxException ex) {
            throw new ConfigurationException(ex);
        }
    }

    private static String getColName(ConfigTree tree, String tag) throws ConfigurationException {
        String defaultColname = tag.endsWith(s_Sfx) ? tag.substring(0, tag.length() - s_Sfx.length()) : null;
        return ListenerUtil.getAttrAndWarn(tree, tag, defaultColname);
    }

    public static String getAttrAndWarn(ConfigTree tree, String tag, String defaultValue) throws ConfigurationException {
        String value = null;
        try {
            value = tree.getAttribute(tag);
            if (null == value) {
                if (null == defaultValue) {
                    throw new ConfigurationException("Missing or invalid " + tag + " attribute");
                }
                ListenerUtil.warnDefault(tag, defaultValue);
                value = defaultValue;
            }
            return value;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static String getValue(ConfigTree p_oP, String p_sAtt, String p_sDefault) {
        String sVal = p_oP.getAttribute(p_sAtt);
        return sVal != null ? sVal : p_sDefault;
    }

    public static String getValue(ConfigTree p_oP, String p_sAtt) {
        return ListenerUtil.getValue(p_oP, p_sAtt, null);
    }

    public static String obtainAtt(ConfigTree p_oP, String p_sAtt, String p_sDefault) throws ConfigurationException {
        String sVal = ListenerUtil.getValue(p_oP, p_sAtt, p_sDefault);
        if (sVal == null && p_sDefault == null) {
            throw new ConfigurationException("Missing or invalid <" + p_sAtt + "> attribute");
        }
        return sVal != null ? sVal : p_sDefault;
    }

    private static void warnDefault(String tag, String defaultValue) {
        _logger.debug((Object)("No value specified for " + tag + " attribute" + " -  Using default value: '" + defaultValue + "'"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getMaxMillisGatewayWait(ConfigTree tree, Logger logr) throws ConfigurationException {
        long maxWait = -1L;
        String sAux = tree.getAttribute("max-millis-for-response");
        if (!Util.isNullString(sAux)) {
            try {
                maxWait = Long.parseLong(sAux);
                if (maxWait >= 1L) return maxWait;
                logr.info((Object)("Value specified for max-millis-for-response (" + maxWait + ") implies that this will be an 'inbound-only' gateway"));
                return maxWait;
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid value for max-millis-for-response", e);
            }
        } else {
            logr.info((Object)"No value specified for: max-millis-for-response -  This will be an 'inbound-only' gateway");
        }
        return maxWait;
    }
}

