/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http.protocol;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import org.apache.commons.httpclient.contrib.ssl.AuthSSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.protocol.AbstractProtocolSocketFactoryBuilder;

public class AuthSSLProtocolSocketFactoryBuilder
extends AbstractProtocolSocketFactoryBuilder {
    public ProtocolSocketFactory newInstance() throws ConfigurationException {
        String keyStorePW = this.getKeystorePassword();
        String trustStorePW = this.getTruststorePassword();
        URL keyStoreURL = this.getKeystoreURL();
        URL trustStoreURL = this.getTruststoreURL();
        try {
            return new AuthSSLProtocolSocketFactory(keyStoreURL, keyStorePW, trustStoreURL, trustStorePW);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationException("Failed to create AuthSSLProtocolSocketFactory instance.", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to create AuthSSLProtocolSocketFactory instance.", e);
        }
    }
}

