/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http.configurators;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.contrib.ssl.StrictSSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.commons.ssl.SSLClient;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.Configurator;
import org.jboss.soa.esb.http.protocol.ProtocolSocketFactoryBuilder;
import org.jboss.soa.esb.util.ClassUtil;

public class HttpProtocol
extends Configurator {
    public void configure(HttpClient httpClient, Properties properties) throws ConfigurationException {
        String factory;
        URI targetURI = this.getTargetURI(properties, true);
        String scheme = targetURI.getScheme();
        int port = targetURI.getPort();
        KeyMaterial keyMaterial = null;
        if (!scheme.startsWith("http")) {
            return;
        }
        if (scheme.equals("https")) {
            factory = properties.getProperty("protocol-socket-factory", StrictSSLProtocolSocketFactory.class.getName());
            keyMaterial = this.getKeyMaterial(properties);
            if (port == -1) {
                port = 443;
            }
        } else {
            factory = properties.getProperty("protocol-socket-factory", DefaultProtocolSocketFactory.class.getName());
            if (port == -1) {
                port = 80;
            }
        }
        this.assertPropertySetAndNotBlank(factory, "protocol-socket-factory");
        ProtocolSocketFactory socketFactory = this.createFactoryClass(factory, keyMaterial, properties);
        Protocol protocol = new Protocol(scheme, socketFactory, port);
        Protocol.registerProtocol((String)scheme, (Protocol)protocol);
    }

    private KeyMaterial getKeyMaterial(Properties properties) throws ConfigurationException {
        String keyStore;
        block9: {
            keyStore = properties.getProperty("keystore", "/keystore");
            String keyStorePassword = properties.getProperty("keystore-passw", "changeit");
            InputStream keyStoreStream = ClassUtil.getResourceAsStream(keyStore, HttpProtocol.class);
            try {
                if (keyStoreStream == null) {
                    File keyStoreFile = new File(keyStore);
                    if (keyStoreFile.exists() && !keyStoreFile.isDirectory()) {
                        return new KeyMaterial((InputStream)new FileInputStream(keyStoreFile), keyStorePassword.toCharArray());
                    }
                } else {
                    return new KeyMaterial(keyStoreStream, keyStorePassword.toCharArray());
                }
                if (keyStoreStream != null) break block9;
                try {
                    URI fileURI = new URI(keyStore);
                    if (fileURI.isAbsolute()) {
                        return new KeyMaterial(fileURI.toURL().openStream(), keyStorePassword.toCharArray());
                    }
                }
                catch (URISyntaxException e) {
                    throw new ConfigurationException("Failed to load keystore '" + keyStore + "'.");
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to load keystore '" + keyStore + "'.", e);
            }
            catch (GeneralSecurityException e) {
                throw new ConfigurationException("Failed to load keystore '" + keyStore + "'.", e);
            }
        }
        throw new ConfigurationException("Failed to locate keystore '" + keyStore + "'.");
    }

    private ProtocolSocketFactory createFactoryClass(String factory, KeyMaterial keyMaterial, Properties properties) throws ConfigurationException {
        ProtocolSocketFactory socketFactory;
        block16: {
            socketFactory = null;
            try {
                Class factoryClass = ClassUtil.forName(factory, HttpProtocol.class);
                if (ProtocolSocketFactoryBuilder.class.isAssignableFrom(factoryClass)) {
                    try {
                        ProtocolSocketFactoryBuilder factoryBuilder = (ProtocolSocketFactoryBuilder)factoryClass.newInstance();
                        factoryBuilder.setConfiguration(properties);
                        socketFactory = factoryBuilder.newInstance();
                        break block16;
                    }
                    catch (InstantiationException e) {
                        throw new ConfigurationException("Failed to instantiate ProtocolSocketFactoryBuilder implementation class [" + factory + "]. Must provide a default constructor.", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ConfigurationException("Failed to instantiate ProtocolSocketFactoryBuilder implementation class [" + factory + "]. Must provide a default constructor.", e);
                    }
                }
                socketFactory = (ProtocolSocketFactory)factoryClass.newInstance();
            }
            catch (ClassCastException e) {
                throw new ConfigurationException("Class [" + factory + "] must implement [" + ProtocolSocketFactory.class.getName() + "].", e);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("ProtocolSocketFactory implementation class [" + factory + "] not found in classpath.", e);
            }
            catch (InstantiationException e) {
                throw new ConfigurationException("Failed to instantiate ProtocolSocketFactory implementation class [" + factory + "].", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to instantiate ProtocolSocketFactory implementation class [" + factory + "].", e);
            }
        }
        if (socketFactory instanceof SSLClient && keyMaterial != null) {
            try {
                ((SSLClient)socketFactory).setKeyMaterial(keyMaterial);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ConfigurationException("Failed to configure SSL Keystore on SSLClient.", e);
            }
            catch (KeyStoreException e) {
                throw new ConfigurationException("Failed to configure SSL Keystore on SSLClient.", e);
            }
            catch (KeyManagementException e) {
                throw new ConfigurationException("Failed to configure SSL Keystore on SSLClient.", e);
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to configure SSL Keystore on SSLClient.", e);
            }
            catch (CertificateException e) {
                throw new ConfigurationException("Failed to configure SSL Keystore on SSLClient.", e);
            }
        }
        return socketFactory;
    }
}

