/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.http.configurators;

import java.net.URI;
import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.Configurator;

public class AuthBASIC
extends Configurator {
    public void configure(HttpClient httpClient, Properties properties) throws ConfigurationException {
        String authScopePort;
        String authScopeHost;
        URI targetURI = this.getTargetURI(properties, false);
        String username = properties.getProperty("auth-username");
        String password = properties.getProperty("auth-password");
        String authScopeRealm = properties.getProperty("authscope-realm");
        if (targetURI != null) {
            authScopeHost = properties.getProperty("authscope-host", targetURI.getHost());
            authScopePort = properties.getProperty("authscope-port", Integer.toString(targetURI.getPort()));
        } else {
            authScopeHost = properties.getProperty("authscope-host");
            authScopePort = properties.getProperty("authscope-port");
        }
        this.assertPropertySetAndNotBlank(username, "auth-username");
        this.assertPropertySetAndNotBlank(password, "auth-password");
        this.assertPropertySetAndNotBlank(authScopeHost, "authscope-host");
        this.assertPropertyIsInteger(authScopePort, "authscope-port");
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
        AuthScope authScope = authScopeRealm != null && !authScopeRealm.trim().equals("") ? new AuthScope(authScopeHost, Integer.parseInt(authScopePort), authScopeRealm) : new AuthScope(authScopeHost, Integer.parseInt(authScopePort));
        httpClient.getState().setCredentials(authScope, (Credentials)creds);
    }
}

