/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.helpers.persist;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.jboss.soa.esb.ConfigurationException;

public class HibernateSessionFactory {
    public static final String HIBERNATE_JNDI = "java:comp/env/hibernate/SessionFactory";
    private static final Logger m_Logger = Logger.getLogger(HibernateSessionFactory.class);

    private HibernateSessionFactory() {
    }

    public static SessionFactory getInstance(Configuration f_cfg) throws ConfigurationException {
        return HibernateSessionFactory.init(f_cfg);
    }

    public static boolean isAlive(Configuration f_cfg) {
        boolean result = false;
        SessionFactory sf = null;
        String cfgName = f_cfg.getProperty("hibernate.session_factory_name");
        InitialContext ic = null;
        if (cfgName != null) {
            try {
                ic = new InitialContext();
                sf = (SessionFactory)ic.lookup(cfgName);
                result = !sf.isClosed();
                m_Logger.debug((Object)("Connection isAlive is " + result + "."));
            }
            catch (NamingException ne) {
                // empty catch block
            }
        }
        return result;
    }

    private static SessionFactory init(Configuration f_cfg) throws ConfigurationException {
        String cfgName = f_cfg.getProperty("hibernate.session_factory_name");
        SessionFactory sf = null;
        InitialContext ic = null;
        if (cfgName != null) {
            try {
                ic = new InitialContext();
                sf = (SessionFactory)ic.lookup(cfgName);
                m_Logger.debug((Object)"Found SessionFactory in JNDI.");
            }
            catch (NamingException ne) {
                m_Logger.debug((Object)"Could not find SessionFactory in JNDI.", (Throwable)ne);
            }
        } else {
            f_cfg.setProperty("hibernate.session_factory_name", HIBERNATE_JNDI);
            cfgName = HIBERNATE_JNDI;
        }
        if (sf == null) {
            if (f_cfg != null) {
                m_Logger.debug((Object)"Build SessionFactory from Configuration.");
                f_cfg.buildSessionFactory();
            } else {
                throw new ConfigurationException("Hibernate Configuration is null");
            }
        }
        return sf;
    }

    public static void close(Configuration f_cfg) {
        SessionFactory sf = null;
        String cfgName = f_cfg.getProperty("hibernate.session_factory_name");
        InitialContext ic = null;
        if (cfgName != null) {
            try {
                ic = new InitialContext();
                sf = (SessionFactory)ic.lookup(cfgName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (sf != null) {
            sf.close();
        }
        sf = null;
    }
}

