/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.helpers;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.lifecycle.LifecycleResource;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingContextPool {
    private static final Logger LOGGER = Logger.getLogger(NamingContextPool.class);
    private static final int DEFAULT_POOL_SIZE = 20;
    private static final int DEFAULT_SLEEP_PERIOD = 30;
    private static final int DEFAULT_RETRY_COUNT = 10;
    private static final String DEFAULT_KEY = "<empty key>";
    private static final String DEFAULT_TEST_LOOKUP = "__dummy2";
    private static final int POOL_SIZE;
    private static final int SLEEP_PERIOD;
    private static final int RETRY_COUNT;
    private static final String TEST_LOOKUP;
    private static final LifecycleResourceFactory<NamingContextPool> lifecycleNamingContextPoolFactory;
    private static final LifecycleResource<NamingContextPool> lifecycleNamingContextPoolResource;
    private final Map<String, List<Context>> freeContexts = new HashMap<String, List<Context>>();
    private final Map<Context, String> freeContextOrder = new LinkedHashMap<Context, String>();
    private final Map<Context, String> inUseContexts = new HashMap<Context, String>();
    private int numContexts;
    private boolean destroyed;

    private NamingContextPool() {
    }

    Context getContext(Properties env) throws NamingContextException {
        long end = System.currentTimeMillis() + (long)(SLEEP_PERIOD * 1000);
        String key = NamingContextPool.getKey(env);
        boolean emitExpiry = LOGGER.isDebugEnabled();
        NamingContextPool namingContextPool = this;
        synchronized (namingContextPool) {
            block5: while (true) {
                while (true) {
                    long now;
                    long delay;
                    if (this.destroyed) {
                        throw new NamingContextException("Naming Context Pool has been previosuly destroyed");
                    }
                    Context context = this.getContext(env, key);
                    if (context != null) {
                        return context;
                    }
                    if (emitExpiry) {
                        LOGGER.debug((Object)"The Naming Context pool was exhausted, waiting for one to be released.");
                        emitExpiry = false;
                    }
                    if ((delay = end - (now = System.currentTimeMillis())) <= 0L) {
                        throw new NamingContextException("Could not obtain a Naming Context from the pool after " + SLEEP_PERIOD + "s.");
                    }
                    try {
                        this.wait(delay);
                        continue block5;
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    synchronized void releaseContext(Context context) throws NamingContextException {
        if (this.destroyed) {
            throw new NamingContextException("Naming Context Pool has been previosuly destroyed");
        }
        String key = this.inUseContexts.remove(context);
        if (key == null) {
            throw new NamingContextException("Cannot release a context which is not in use.");
        }
        this.freeContextOrder.put(context, key);
        List<Context> contexts = this.freeContexts.get(key);
        if (contexts != null) {
            contexts.add(context);
        } else {
            ArrayList<Context> newContexts = new ArrayList<Context>();
            newContexts.add(context);
            this.freeContexts.put(key, newContexts);
        }
        this.notifyAll();
    }

    synchronized Context replaceContext(Context context, Properties env) throws NamingContextException {
        if (this.destroyed) {
            throw new NamingContextException("Naming Context Pool has been previosuly destroyed");
        }
        String key = this.inUseContexts.remove(context);
        if (key == null) {
            throw new NamingContextException("Cannot release a context which is not in use.");
        }
        --this.numContexts;
        this.closeContext(context);
        return this.createContext(env, key);
    }

    synchronized void closeAllContexts() {
        this.closeAllContexts(this.freeContextOrder.keySet().iterator());
        if (this.inUseContexts.size() > 0) {
            LOGGER.warn((Object)"Forcing closure of in-use Naming Contexts");
            this.closeAllContexts(this.inUseContexts.keySet().iterator());
        }
        this.inUseContexts.clear();
        this.freeContextOrder.clear();
        this.freeContexts.clear();
        this.destroyed = true;
    }

    private Context getContext(Properties env, String key) throws NamingContextException {
        Context context = this.getFreeContext(key);
        if (context != null) {
            return context;
        }
        if (this.numContexts == POOL_SIZE) {
            if (this.freeContextOrder.size() == 0) {
                return null;
            }
            Iterator<Map.Entry<Context, String>> freeContextIter = this.freeContextOrder.entrySet().iterator();
            Map.Entry<Context, String> freeContextEntry = freeContextIter.next();
            Context freeContext = freeContextEntry.getKey();
            String freeContextKey = freeContextEntry.getValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Ejecting Naming Context from pool, key: " + freeContextKey));
            }
            this.freeContextOrder.remove(freeContext);
            List<Context> contexts = this.freeContexts.get(freeContextKey);
            contexts.remove(freeContext);
            if (contexts.size() == 0) {
                this.freeContexts.remove(freeContextKey);
            }
            --this.numContexts;
            this.closeContext(freeContext);
        }
        return this.createContext(env, key);
    }

    private Context getFreeContext(String key) {
        int size;
        List<Context> contexts = this.freeContexts.get(key);
        if (contexts != null && (size = contexts.size()) > 0) {
            Context context = contexts.remove(size - 1);
            this.freeContextOrder.remove(context);
            this.inUseContexts.put(context, key);
            return context;
        }
        return null;
    }

    private Context createContext(Properties env, String key) throws NamingContextException {
        NamingException cachedException = null;
        for (int count = 0; count < RETRY_COUNT; ++count) {
            InitialContext context;
            try {
                context = new InitialContext(env);
                try {
                    context.lookup(TEST_LOOKUP);
                }
                catch (NameNotFoundException nfne) {}
            }
            catch (NamingException ne) {
                cachedException = ne;
                continue;
            }
            this.inUseContexts.put(context, key);
            ++this.numContexts;
            return context;
        }
        throw new NamingContextException("Failed to create Naming Context", cachedException);
    }

    private void closeAllContexts(Iterator<Context> contextIter) {
        while (contextIter.hasNext()) {
            this.closeContext(contextIter.next());
        }
    }

    private void closeContext(Context context) {
        try {
            context.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public static Context getNamingContext(Properties properties) throws NamingContextException {
        return NamingContextPool.getPool().getContext(properties);
    }

    public static void releaseNamingContext(Context context) throws NamingContextException {
        NamingContextPool.getPool().releaseContext(context);
    }

    public static Context replaceNamingContext(Context context, Properties env) throws NamingContextException {
        return NamingContextPool.getPool().replaceContext(context, env);
    }

    private static NamingContextPool getPool() throws NamingContextException {
        try {
            return lifecycleNamingContextPoolResource.getLifecycleResource();
        }
        catch (LifecycleResourceException lre) {
            throw new NamingContextException("Unexpected lifecycle resource exception", lre);
        }
    }

    private static String getKey(Properties properties) {
        if (properties == null || properties.size() == 0) {
            return DEFAULT_KEY;
        }
        TreeMap<String, String> orderedProperties = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            orderedProperties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return orderedProperties.toString();
    }

    private static int getIntProperty(PropertyManager prop, String name, int defaultValue) {
        String value = prop.getProperty(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                LOGGER.warn((Object)("Could not parse value for property: " + name + ", value: " + value));
            }
        }
        return defaultValue;
    }

    static {
        lifecycleNamingContextPoolFactory = new NamingContextPoolFactory();
        lifecycleNamingContextPoolResource = new LifecycleResource<NamingContextPool>(lifecycleNamingContextPoolFactory, 400000);
        PropertyManager prop = ModulePropertyManager.getPropertyManager("core");
        POOL_SIZE = NamingContextPool.getIntProperty(prop, "org.jboss.soa.esb.namingcontext.poolsize", 20);
        SLEEP_PERIOD = NamingContextPool.getIntProperty(prop, "org.jboss.soa.esb.namingcontext.sleepperiod", 30);
        RETRY_COUNT = NamingContextPool.getIntProperty(prop, "org.jboss.soa.esb.namingcontext.retrycount", 10);
        TEST_LOOKUP = prop.getProperty("org.jboss.soa.esb.jndi.test.lookup", DEFAULT_TEST_LOOKUP);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamingContextPoolFactory
    implements LifecycleResourceFactory<NamingContextPool> {
        private NamingContextPoolFactory() {
        }

        @Override
        public NamingContextPool createLifecycleResource(String lifecycleIdentity) throws LifecycleResourceException {
            return new NamingContextPool();
        }

        @Override
        public void destroyLifecycleResource(NamingContextPool resource, String lifecycleIdentity) throws LifecycleResourceException {
            resource.closeAllContexts();
        }
    }
}

