/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.helpers;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class NamingContext {
    private static final Logger _logger = Logger.getLogger(NamingContext.class);
    public static final int MAX_RETRIES = 10;
    public static final String JBOSS_PROVIDER_URL = "localhost";
    public static final String JBOSS_INITIAL_CONTEXT_FACTORY = "org.jnp.interfaces.NamingContextFactory";
    public static final String JBOSS_URL_PKG_PREFIX = "";
    private static ConcurrentHashMap<String, Context> _contextCache = new ConcurrentHashMap();

    public static Context getServerContext(Properties properties) {
        String key = NamingContext.getKey(properties);
        if (_contextCache.containsKey(key)) {
            return _contextCache.get(key);
        }
        boolean bCtxOK = false;
        InitialContext oCtx = null;
        for (int i1 = 0; !bCtxOK && i1 < 10; ++i1) {
            try {
                oCtx = new InitialContext(properties);
                oCtx.list("__dummy2@#$%");
                bCtxOK = true;
                continue;
            }
            catch (NamingException nex) {
                bCtxOK = true;
            }
        }
        if (bCtxOK) {
            _contextCache.put(key, oCtx);
            return oCtx;
        }
        _logger.error((Object)("Can't connect to JNDI Server <" + properties.get("java.naming.provider.url") + ">"));
        return null;
    }

    public static Context getFreshServerContext(Properties properties) {
        String key = NamingContext.getKey(properties);
        if (_contextCache.containsKey(key)) {
            Context context = _contextCache.get(key);
            try {
                context.close();
            }
            catch (NamingException ne) {
                _logger.warn((Object)"Could not close JNDI connection.");
            }
            _contextCache.remove(key);
        }
        return NamingContext.getServerContext(properties);
    }

    private static String getKey(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        StringBuffer compositeKey = new StringBuffer("-");
        for (Object keyObject : properties.keySet()) {
            String key = (String)keyObject;
            String value = properties.getProperty(key);
            compositeKey.append(key).append("=").append(value).append("-");
        }
        return compositeKey.toString();
    }

    public static void closeAllContexts() {
        for (String key : _contextCache.keySet()) {
            try {
                _logger.debug((Object)("Closing JNDI connection for key: " + key));
                _contextCache.get(key).close();
            }
            catch (NamingException ne) {
                _logger.warn((Object)("Could not close JNDI connection for key: " + key));
            }
            _contextCache.remove(key);
        }
    }
}

