/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.couriers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.DeliverOnlyCourier;
import org.jboss.internal.soa.esb.couriers.PickUpOnlyCourier;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.addressing.util.DefaultReplyTo;
import org.jboss.soa.esb.couriers.Courier;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.CourierMarshalUnmarshalException;
import org.jboss.soa.esb.couriers.CourierTransportException;
import org.jboss.soa.esb.couriers.TwoWayCourier;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.ContextObjectInputStream;
import org.jboss.soa.esb.util.Util;
import org.xml.sax.SAXException;

public class CourierUtil {
    protected static Logger _logger = Logger.getLogger(CourierUtil.class);

    private CourierUtil() {
    }

    public static EPR getDefaultReplyToEpr(EPR toEpr) throws CourierException, MalformedEPRException {
        return DefaultReplyTo.getReplyTo(toEpr);
    }

    public static Properties propertiesFromSelector(String selector) throws ConfigurationException {
        Properties oRet = new Properties();
        if (!Util.isNullString(selector)) {
            for (String sCurr : selector.split(",")) {
                String[] sa = sCurr.split("=");
                if (sa.length != 2 || sa[1].charAt(0) != '\'' || sa[1].charAt(-1 + sa[1].length()) != '\'') {
                    throw new ConfigurationException("Illegal message selector syntax <" + selector + ">  list of comma separated key='value' expected");
                }
                KeyValuePair oNew = new KeyValuePair(sa[0], sa[1].substring(0, -1 + sa[1].length()).substring(1));
                oRet.put(oNew.getKey(), oNew.getValue());
            }
        }
        return oRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File messageToLocalFile(File directory, Message message) throws IOException, ParserConfigurationException {
        File tmpFile = File.createTempFile("EsbFileCourier_", ".__esbPart", directory);
        Serializable serial = Util.serialize(message);
        FileOutputStream writer = null;
        try {
            writer = new FileOutputStream(tmpFile);
            new ObjectOutputStream(writer).writeObject(serial);
            writer.flush();
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
        return tmpFile;
    }

    public static Message messageFromLocalFile(File from) throws FileNotFoundException, IOException, ClassNotFoundException, ClassCastException, ParserConfigurationException, SAXException, CourierException {
        FileInputStream reader = null;
        Serializable serial = null;
        int retry = 10;
        while (retry > 0) {
            serial = null;
            try {
                reader = new FileInputStream(from);
                serial = (Serializable)new ContextObjectInputStream(reader).readObject();
                Message message = Util.deserialize(serial);
                return message;
            }
            catch (StreamCorruptedException ex) {
                --retry;
            }
            catch (IOException ex) {
                if (serial == null) {
                    throw new CourierTransportException(ex);
                }
                throw new CourierMarshalUnmarshalException(ex);
            }
            catch (Exception e) {
                e.printStackTrace();
                _logger.debug((Object)(from + " " + e.toString()));
                throw new CourierException(e);
            }
            finally {
                if (null != reader) {
                    reader.close();
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {}
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytesFromLocalFile(File from) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(from);
        byte[] buff = new byte[1000];
        int iQ = 0;
        try {
            while ((iQ = in.read(buff)) >= 0) {
                if (iQ <= 0) continue;
                out.write(buff, 0, iQ);
            }
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != out) {
                out.close();
            }
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bytesToLocalFile(byte[] bytes, File to) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(to);
            out.write(bytes);
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deliverMessage(Message message) throws URISyntaxException, CourierException, MalformedEPRException {
        EPR toEpr = message.getHeader().getCall().getTo();
        Courier courier = CourierFactory.getCourier(toEpr);
        try {
            courier.deliver(message);
        }
        finally {
            CourierUtil.cleanCourier(courier);
        }
    }

    public static void cleanCourier(PickUpOnlyCourier courier) {
        if (null != courier) {
            try {
                courier.cleanup();
            }
            catch (Throwable e) {
                _logger.error((Object)("Problems invoking clean() Method for class " + courier.getClass().getSimpleName()), e);
            }
        }
    }

    public static void cleanCourier(DeliverOnlyCourier courier) {
        if (null != courier) {
            try {
                courier.cleanup();
            }
            catch (Exception e) {
                _logger.error((Object)("Problems invoking clean() Method for class " + courier.getClass().getSimpleName()), (Throwable)e);
            }
        }
    }

    public static void cleanCourier(TwoWayCourier courier) {
        if (null != courier) {
            try {
                courier.cleanup();
            }
            catch (Exception e) {
                _logger.error((Object)("Problems invoking clean() Method for class " + courier.getClass().getSimpleName()), (Throwable)e);
            }
        }
    }
}

