/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.couriers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.InVMCourier;
import org.jboss.internal.soa.esb.couriers.TwoWayCourierImpl;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.couriers.Courier;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.TwoWayCourier;
import org.jboss.soa.esb.lifecycle.LifecycleResource;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceFactory;

public class CourierFactory {
    private static final Logger LOGGER = Logger.getLogger(CourierFactory.class);
    private static final LifecycleResourceFactory<Map<TwoWayCourier, Exception>> lifecycleCourierFactory = new LifecycleCourierFactory();
    private static final LifecycleResource<Map<TwoWayCourier, Exception>> lifecycleCouriers = new LifecycleResource<Map<TwoWayCourier, Exception>>(lifecycleCourierFactory, 100000);
    private final Map<String, InVMCourier> inVMCouriers = new ConcurrentHashMap<String, InVMCourier>();
    private static CourierFactory instance = new CourierFactory();

    protected CourierFactory() {
    }

    public static CourierFactory getInstance() {
        return instance;
    }

    protected static void setInstance(CourierFactory instance) {
        CourierFactory.instance = instance;
    }

    public TwoWayCourier getMessageCourier(EPR toEPR) throws CourierException, MalformedEPRException {
        return CourierFactory.getCourier(toEPR, null);
    }

    public static Courier getCourier(EPR toEPR) throws CourierException, MalformedEPRException {
        if (toEPR instanceof InVMEpr) {
            TwoWayCourierImpl courier = new TwoWayCourierImpl(CourierFactory.getInstance().getInVMCourier((InVMEpr)toEPR), null);
            courier.setToEpr(toEPR);
            return courier;
        }
        return CourierFactory.getCourier(toEPR, null);
    }

    public static TwoWayCourier getPickupCourier(EPR replyToEPR) throws CourierException, MalformedEPRException {
        if (replyToEPR instanceof InVMEpr) {
            TwoWayCourierImpl courier = new TwoWayCourierImpl(null, CourierFactory.getInstance().getInVMCourier((InVMEpr)replyToEPR));
            courier.setReplyToEpr(replyToEPR);
            return courier;
        }
        return CourierFactory.getCourier(null, replyToEPR);
    }

    public synchronized InVMCourier getInVMCourier(InVMEpr epr) {
        String address = epr.getAddr().getAddress();
        InVMCourier courier = this.inVMCouriers.get(address);
        if (courier == null) {
            courier = new InVMCourier(epr);
            this.inVMCouriers.put(address, courier);
        }
        courier.setActive(true);
        return courier;
    }

    public static TwoWayCourier getCourier(EPR toEPR, EPR replyToEPR) throws CourierException, MalformedEPRException {
        TwoWayCourierImpl result = new TwoWayCourierImpl(toEPR, replyToEPR);
        CourierFactory.registerCourier(result);
        return result;
    }

    private static synchronized void registerCourier(TwoWayCourier courier) throws CourierException {
        Exception ex = LOGGER.isDebugEnabled() ? new Exception("Courier Assignment stacktrace") : null;
        try {
            lifecycleCouriers.getLifecycleResource().put(courier, ex);
        }
        catch (LifecycleResourceException lre) {
            throw new CourierException("Unexpected lifecycle resource exception while registering courier", lre);
        }
    }

    public static synchronized void deregisterCourier(TwoWayCourier courier) {
        block2: {
            try {
                lifecycleCouriers.getLifecycleResource().remove(courier);
            }
            catch (LifecycleResourceException lre) {
                LOGGER.warn((Object)("Unexpected error removing courier: " + lre.getMessage()));
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug((Object)"Unexpected error removing courier", (Throwable)lre);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LifecycleCourierFactory
    implements LifecycleResourceFactory<Map<TwoWayCourier, Exception>> {
        private LifecycleCourierFactory() {
        }

        @Override
        public Map<TwoWayCourier, Exception> createLifecycleResource(String lifecycleIdentity) throws LifecycleResourceException {
            return new HashMap<TwoWayCourier, Exception>();
        }

        @Override
        public void destroyLifecycleResource(Map<TwoWayCourier, Exception> resource, String lifecycleIdentity) throws LifecycleResourceException {
            if (resource.size() > 0) {
                LOGGER.warn((Object)("Calling cleanup on existing couriers for identity " + lifecycleIdentity));
                Iterator<Map.Entry<TwoWayCourier, Exception>> entryIter = resource.entrySet().iterator();
                while (entryIter.hasNext()) {
                    Map.Entry<TwoWayCourier, Exception> entry = entryIter.next();
                    entryIter.remove();
                    if (LOGGER.isDebugEnabled() && entry.getValue() != null) {
                        LOGGER.debug((Object)"Courier allocation stacktrace", (Throwable)entry.getValue());
                    }
                    try {
                        entry.getKey().cleanup();
                    }
                    catch (Exception ex) {
                        LOGGER.warn((Object)"Unexpected exception cleaning up courier", (Throwable)ex);
                    }
                }
            }
        }
    }
}

