/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.couriers;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.couriers.Courier;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourierCollection {
    private final Courier[] couriers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CourierCollection(Collection<EPR> eprs) throws MalformedEPRException, CourierException {
        if (eprs != null && eprs.size() > 0) {
            ArrayList<Courier> courierList = new ArrayList<Courier>();
            try {
                for (EPR epr : eprs) {
                    Courier courier = CourierFactory.getCourier(epr);
                    if (courier == null) {
                        throw new CourierException("Null courier returned for EPR: " + epr);
                    }
                    courierList.add(courier);
                }
                this.couriers = courierList.toArray(new Courier[courierList.size()]);
                courierList.clear();
            }
            finally {
                if (courierList.size() > 0) {
                    for (Courier courier : courierList) {
                        CourierUtil.cleanCourier(courier);
                    }
                }
            }
        } else {
            this.couriers = null;
        }
    }

    public boolean deliver(Message message) throws CourierException, MalformedEPRException {
        if (this.couriers != null) {
            for (Courier courier : this.couriers) {
                courier.deliver(message);
            }
            return true;
        }
        return false;
    }

    public void cleanup() {
        for (Courier courier : this.couriers) {
            CourierUtil.cleanCourier(courier);
        }
    }
}

