/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.common;

import javax.transaction.Synchronization;
import javax.transaction.xa.XAResource;
import org.jboss.soa.esb.common.TransactionStrategyException;

public abstract class TransactionStrategy {
    private static final TransactionStrategy NULL_TRANSACTION_STRATEGY;
    private static volatile TransactionStrategy transactionStrategy;

    public static TransactionStrategy getTransactionStrategy(boolean transacted) {
        return transacted ? transactionStrategy : NULL_TRANSACTION_STRATEGY;
    }

    public static void setTransactionStrategy(TransactionStrategy transactionStrategy) {
        TransactionStrategy.transactionStrategy = transactionStrategy == null ? NULL_TRANSACTION_STRATEGY : transactionStrategy;
    }

    public abstract void begin() throws TransactionStrategyException;

    public abstract void terminate() throws TransactionStrategyException;

    public abstract void rollbackOnly() throws TransactionStrategyException;

    public abstract Object getTransaction() throws TransactionStrategyException;

    public abstract Object suspend() throws TransactionStrategyException;

    public abstract boolean isActive() throws TransactionStrategyException;

    public abstract void resume(Object var1) throws TransactionStrategyException;

    public abstract void registerSynchronization(Synchronization var1) throws TransactionStrategyException;

    public abstract void enlistResource(XAResource var1) throws TransactionStrategyException;

    static {
        transactionStrategy = NULL_TRANSACTION_STRATEGY = new NullTransactionStrategy();
    }

    private static class NullTransactionStrategy
    extends TransactionStrategy {
        private NullTransactionStrategy() {
        }

        public void begin() throws TransactionStrategyException {
        }

        public void terminate() throws TransactionStrategyException {
        }

        public void rollbackOnly() throws TransactionStrategyException {
        }

        public Object getTransaction() throws TransactionStrategyException {
            return null;
        }

        public Object suspend() throws TransactionStrategyException {
            return null;
        }

        public void resume(Object tx) throws TransactionStrategyException {
            throw new TransactionStrategyException("Unsupported in this transaction strategy");
        }

        public void registerSynchronization(Synchronization sync) throws TransactionStrategyException {
            throw new TransactionStrategyException("Unsupported in this transaction strategy");
        }

        public void enlistResource(XAResource resource) throws TransactionStrategyException {
            throw new TransactionStrategyException("Unsupported in this transaction strategy");
        }

        public boolean isActive() throws TransactionStrategyException {
            return false;
        }

        public String toString() {
            return "NullTransactionStrategy";
        }
    }
}

