/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.soa.esb.common.JBossESBPropertyServiceMBean;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.tm.TransactionManagerLocator;

public class JBossESBPropertyService
extends ServiceMBeanSupport
implements JBossESBPropertyServiceMBean {
    private static final String ESB_PROPERTY_FILE = "jbossesb-properties.xml";
    private String propertyFile;

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createService() throws Exception {
        String bindHost = System.getProperty("jboss.esb.bind.address");
        if (bindHost == null) {
            String bindAddress = System.getProperty("jboss.bind.address");
            String esbBindAddress = ServerConfigUtil.fixRemoteAddress((String)bindAddress);
            System.setProperty("jboss.esb.bind.address", esbBindAddress);
        }
        if (this.propertyFile != null) {
            InputStream xmlPropertyIS;
            File baseFile = new File(this.propertyFile);
            if (!baseFile.isAbsolute()) {
                URL resourceURL = Thread.currentThread().getContextClassLoader().getResource(this.propertyFile);
                xmlPropertyIS = resourceURL.openStream();
            } else {
                xmlPropertyIS = new FileInputStream(baseFile);
            }
            try {
                ServerConfig serverConfig = ServerConfigLocator.locate();
                File dataDir = serverConfig.getServerDataDir();
                File esbPropertyFile = new File(dataDir, ESB_PROPERTY_FILE);
                FileOutputStream esbPropertyOS = new FileOutputStream(esbPropertyFile);
                try {
                    XMLHelper.replaceSystemProperties(XMLHelper.getXMLStreamReader(xmlPropertyIS), XMLHelper.getXMLStreamWriter(esbPropertyOS));
                }
                finally {
                    esbPropertyOS.close();
                }
                System.setProperty("org.jboss.soa.esb.propertyFile", "abs://" + esbPropertyFile.getAbsolutePath());
            }
            finally {
                xmlPropertyIS.close();
            }
        }
        TransactionStrategy.setTransactionStrategy(new JTATransactionStrategy());
    }

    private static class JTATransactionStrategy
    extends TransactionStrategy {
        private static final Logger LOGGER = Logger.getLogger(JTATransactionStrategy.class);
        private final TransactionManager tm = TransactionManagerLocator.getInstance().locate();

        JTATransactionStrategy() {
        }

        public void begin() throws TransactionStrategyException {
            try {
                this.tm.begin();
                LOGGER.trace((Object)"Transaction started on current thread");
            }
            catch (Throwable th) {
                LOGGER.debug((Object)"Failed to start transaction on current thread", th);
                throw new TransactionStrategyException("Failed to begin transaction on current thread", th);
            }
        }

        public void terminate() throws TransactionStrategyException {
            try {
                int status = this.tm.getStatus();
                switch (status) {
                    case 0: {
                        LOGGER.trace((Object)"Committing transaction on current thread");
                        this.tm.commit();
                        break;
                    }
                    case 1: {
                        LOGGER.trace((Object)"Rollback transaction on current thread");
                        this.tm.rollback();
                        break;
                    }
                    default: {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace((Object)("Suspending transaction on current thread, status: " + status));
                        }
                        this.tm.suspend();
                        break;
                    }
                }
            }
            catch (Throwable th) {
                LOGGER.debug((Object)"Failed to terminate transaction on current thread", th);
                throw new TransactionStrategyException("Failed to terminate transaction on current thread", th);
            }
        }

        public void rollbackOnly() throws TransactionStrategyException {
            try {
                this.tm.setRollbackOnly();
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Failed to mark the transaction on current thread for rollback", th);
            }
        }

        public Object getTransaction() throws TransactionStrategyException {
            try {
                return this.tm.getTransaction();
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when trying to getTransaction: ", th);
            }
        }

        public Object suspend() throws TransactionStrategyException {
            try {
                return this.tm.suspend();
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when trying to suspend transaction: ", th);
            }
        }

        public void resume(Object tx) throws TransactionStrategyException {
            try {
                this.tm.resume((Transaction)tx);
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when trying to resume transaction: ", th);
            }
        }

        public void registerSynchronization(Synchronization sync) throws TransactionStrategyException {
            try {
                this.tm.getTransaction().registerSynchronization(sync);
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when registering synchronization: ", th);
            }
        }

        public void enlistResource(XAResource resource) throws TransactionStrategyException {
            try {
                this.tm.getTransaction().enlistResource(resource);
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when enlisting resource", th);
            }
        }

        public boolean isActive() throws TransactionStrategyException {
            try {
                return this.tm.getStatus() == 0;
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when trying to get transaction status: ", th);
            }
        }

        public String toString() {
            return "JTATransactionStrategy";
        }
    }
}

