/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.client;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.addressing.helpers.EPRHelper;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.services.security.PrivateCryptoUtil;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.addressing.PortReference;
import org.jboss.soa.esb.addressing.util.DefaultReplyTo;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.CourierMarshalUnmarshalException;
import org.jboss.soa.esb.couriers.CourierServiceBindException;
import org.jboss.soa.esb.couriers.CourierTransportException;
import org.jboss.soa.esb.couriers.CourierUtil;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.couriers.TwoWayCourier;
import org.jboss.soa.esb.listeners.RegistryUtil;
import org.jboss.soa.esb.listeners.ha.LoadBalancePolicy;
import org.jboss.soa.esb.listeners.ha.ServiceClusterInfo;
import org.jboss.soa.esb.listeners.ha.ServiceClusterInfoImpl;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.listeners.message.errors.Factory;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.util.Type;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;
import org.jboss.soa.esb.services.security.SecurityContext;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInvoker {
    public static final String INTERNAL_SERVICE_CATEGORY = "JBossESB-Internal";
    public static final String DEAD_LETTER_SERVICE_NAME = "DeadLetterService";
    public static final String DELIVER_TO = "org.jboss.soa.esb.deliver.to";
    private static boolean removeDeadEprs;
    private static boolean exceptionOnDeliveryFailure;
    private static Logger logger;
    private final Service service;
    private final List<PortReference.Extension> extensions;
    private final LoadBalancePolicy loadBalancer;
    private ServiceClusterInfo serviceClusterInfo;
    private Date expirationDate;
    private final long registryCacheLife;
    private static ServiceInvoker dlQueueInvoker;
    public static final Service dlqService;

    public ServiceInvoker(Service service) throws MessageDeliverException {
        this(service, null);
    }

    public ServiceInvoker(Service service, List<PortReference.Extension> extensions) throws MessageDeliverException {
        AssertArgument.isNotNull(service, "service");
        this.service = service;
        this.extensions = extensions;
        String lbClass = Configuration.getLoadBalancerPolicy();
        this.registryCacheLife = Long.valueOf(Configuration.getRegistryCacheLife());
        try {
            Class c = ClassUtil.forName(lbClass, this.getClass());
            this.loadBalancer = (LoadBalancePolicy)c.newInstance();
            this.loadServiceClusterInfo();
        }
        catch (ClassNotFoundException clf) {
            logger.error((Object)("No such LoadBalancePolicy class = " + lbClass));
            throw new MessageDeliverException(clf.getMessage(), clf);
        }
        catch (InstantiationException ie) {
            logger.error((Object)("Could not instatiate LoadBalancePolicy class = " + lbClass));
            throw new MessageDeliverException(ie.getMessage(), ie.getCause());
        }
        catch (IllegalAccessException iae) {
            logger.error((Object)("Illegal access while instantiating LoadBalancePolicy class = " + lbClass));
            throw new MessageDeliverException(iae.getMessage(), iae);
        }
    }

    public ServiceInvoker(String serviceCategory, String serviceName) throws MessageDeliverException {
        this(new Service(serviceCategory, serviceName));
    }

    public Message deliverSync(Message message, long timeoutMillis) throws MessageDeliverException, RegistryException, FaultMessageException {
        AssertArgument.isNotNull(message, "message");
        try {
            message = this.post(message, new EPRInvoker(timeoutMillis));
        }
        catch (MessageDeliverException mde) {
            if ("true".equalsIgnoreCase(Configuration.getRedeliveryDlsOn()) && !this.service.equals(dlqService)) {
                message.getProperties().setProperty(DELIVER_TO, this.service);
                logger.info((Object)("Delivering message [" + message.getHeader() + "] to DLQ."));
                ServiceInvoker.deliverToDeadLetterService(message);
            }
            throw mde;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverAsync(Message message) throws MessageDeliverException {
        AssertArgument.isNotNull(message, "message");
        try {
            this.post(message, new EPRInvoker());
        }
        catch (MessageDeliverException mde) {
            if (message.getProperties().getProperty("org.jboss.soa.esb.deliver.isRedelivery") == null && "true".equalsIgnoreCase(Configuration.getRedeliveryDlsOn()) && !this.service.equals(dlqService)) {
                message.getProperties().setProperty("org.jboss.soa.esb.messagestore.classification", "RDLVR");
                message.getProperties().setProperty(DELIVER_TO, this.service);
                try {
                    logger.info((Object)("Delivering message [" + message.getHeader() + "] to RDLVRQ."));
                    ServiceInvoker.deliverToDeadLetterService(message);
                }
                finally {
                    message.getProperties().remove("org.jboss.soa.esb.messagestore.classification");
                    message.getProperties().remove(DELIVER_TO);
                }
            }
            throw mde;
        }
        catch (FaultMessageException ex) {
            throw new MessageDeliverException("Unexpected FaultMessageException during message delivery.", ex);
        }
    }

    protected static synchronized void deliverToDeadLetterService(Message message) throws MessageDeliverException {
        if (!"true".equalsIgnoreCase(Configuration.getRedeliveryDlsOn())) {
            logger.debug((Object)"org.jboss.soa.esb.dls.redeliver is turned off");
        } else {
            if (dlQueueInvoker == null) {
                dlQueueInvoker = new ServiceInvoker(dlqService);
            }
            dlQueueInvoker.deliverAsync(message);
        }
    }

    private Message post(Message message, EPRInvoker eprInvoker) throws MessageDeliverException, FaultMessageException {
        boolean staleEPRCache = true;
        boolean initialPass = true;
        while (staleEPRCache) {
            EPR epr;
            if (this.serviceClusterInfo.getEPRs().size() == 0 || new Date().after(this.expirationDate)) {
                this.loadServiceClusterInfo();
                if (initialPass && this.serviceClusterInfo.getEPRs().size() == 0) {
                    initialPass = false;
                } else {
                    staleEPRCache = false;
                }
            }
            while ((epr = this.loadBalancer.chooseEPR(this.serviceClusterInfo)) != null) {
                try {
                    Message replyMessage;
                    Subject subject = Subject.getSubject(AccessController.getContext());
                    if (subject != null) {
                        logger.info((Object)("Subject in ServiceInvoker " + subject));
                        try {
                            byte[] encrypted = PrivateCryptoUtil.INSTANCE.encrypt(new SecurityContext(subject));
                            message.getContext().setContext("org.jboss.soa.esb.services.security.context", encrypted);
                        }
                        catch (SecurityServiceException e) {
                            logger.error((Object)"Could not encrypt the security conext. Will not be added to the outgoing message", (Throwable)e);
                        }
                    }
                    if ((replyMessage = eprInvoker.attemptDelivery(message, epr)) != null) {
                        replyMessage.getContext().removeContext("org.jboss.soa.esb.services.security.context");
                        if (Type.isFaultMessage(replyMessage)) {
                            Factory.createExceptionFromFault(replyMessage);
                        }
                        return replyMessage;
                    }
                    logger.info((Object)("Unresponsive EPR: " + epr + " for message: " + message.getHeader()));
                    this.serviceClusterInfo.removeDeadEPR(epr);
                    if (removeDeadEprs) {
                        RegistryUtil.unregister(this.service.getCategory(), this.service.getName(), epr);
                    }
                    if (!"true".equals(message.getProperties().getProperty("org.jboss.soa.esb.exceptionOnDeliverFailure", "false")) && !exceptionOnDeliveryFailure) continue;
                    throw new MessageDeliverException("Failed to deliver message [" + message.getHeader() + "] to Service [" + this.service + "].  Told not to retry.");
                }
                catch (MalformedEPRException ex) {
                    logger.info((Object)("Invalid EPR for service (probably ESB-unaware): ignoring for message: " + message.getHeader()));
                    this.serviceClusterInfo.removeDeadEPR(epr);
                }
            }
        }
        throw new MessageDeliverException("Failed to deliver message [" + message.getHeader() + "] to Service [" + this.service + "].  Check for errors.");
    }

    public Service getService() {
        return this.service;
    }

    public String getServiceCategory() {
        return this.service.getCategory();
    }

    public String getServiceName() {
        return this.service.getName();
    }

    protected EPR getReplyToAddress(EPR toEpr) throws ConfigurationException {
        try {
            return DefaultReplyTo.getReplyTo(toEpr);
        }
        catch (CourierException e) {
            throw new ConfigurationException("Bad configuration. Unable to support synchronous reply on 'to' address " + toEpr, e);
        }
        catch (MalformedEPRException e) {
            throw new ConfigurationException("Bad configuration. Unable to support synchronous reply on 'to' address " + toEpr, e);
        }
    }

    protected TwoWayCourier getCourier(EPR epr) throws CourierException, MalformedEPRException {
        return CourierFactory.getInstance().getMessageCourier(epr);
    }

    public void loadServiceClusterInfo() throws MessageDeliverException {
        List<Object> serviceEprs = new ArrayList();
        try {
            serviceEprs = RegistryUtil.getEprs(this.service.getCategory(), this.service.getName());
            if (logger.isDebugEnabled()) {
                for (EPR ePR : serviceEprs) {
                    try {
                        logger.debug((Object)("EPR=" + ePR + " XML=" + EPRHelper.toXMLString(ePR)));
                    }
                    catch (Exception me) {
                        logger.error((Object)me.getMessage(), (Throwable)me);
                    }
                }
            }
        }
        catch (ServiceNotFoundException snfe) {
            logger.info((Object)("Service: " + this.service + " not found in the registry"));
        }
        catch (RegistryException e) {
            throw new MessageDeliverException(e.getMessage(), e);
        }
        this.serviceClusterInfo = new ServiceClusterInfoImpl(this.service.getName(), serviceEprs);
        this.expirationDate = new Date(System.currentTimeMillis() + this.registryCacheLife);
    }

    static {
        logger = Logger.getLogger(ServiceInvoker.class);
        dlqService = new Service(INTERNAL_SERVICE_CATEGORY, DEAD_LETTER_SERVICE_NAME);
        String pruneDead = ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.failure.detect.removeDeadEPR", "false");
        removeDeadEprs = "true".equalsIgnoreCase(pruneDead);
        String exceptionOnFailure = ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.exceptionOnDeliverFailure", "false");
        exceptionOnDeliveryFailure = "true".equalsIgnoreCase(exceptionOnFailure);
    }

    private class EPRInvoker {
        private boolean synchronous = false;
        private long timeout;

        private EPRInvoker() {
            this.synchronous = false;
        }

        private EPRInvoker(long timeout) {
            this.synchronous = true;
            this.timeout = timeout;
        }

        private Message attemptDelivery(Message message, EPR epr) throws FaultMessageException, MalformedEPRException, MessageDeliverException {
            TwoWayCourier courier = null;
            EPR targetEPR = ServiceInvoker.this.extensions != null && ServiceInvoker.this.extensions.size() > 0 ? EPRHelper.copyEPR(epr, ServiceInvoker.this.extensions) : epr;
            try {
                courier = ServiceInvoker.this.getCourier(targetEPR);
            }
            catch (CourierException e) {
                logger.debug((Object)("Courier lookup failed for EPR [" + targetEPR + "] for Service [" + ServiceInvoker.this.service + "] and Message [" + message.getHeader() + "]."), (Throwable)e);
            }
            catch (MalformedEPRException e) {
                logger.info((Object)("Badly formed EPR [" + targetEPR + "] for Service [" + ServiceInvoker.this.service + "] and Message [" + message.getHeader() + "]." + e.getMessage()));
                throw e;
            }
            catch (Throwable t) {
                logger.warn((Object)("Unexpected exception during Courier lookup for EPR [" + targetEPR + "] for Service [" + ServiceInvoker.this.service + "] and Message [" + message.getHeader() + "]."), t);
            }
            if (courier != null) {
                EPR currentEpr = message.getHeader().getCall().getTo();
                try {
                    EPR replyToEPR = message.getHeader().getCall().getReplyTo();
                    message.getHeader().getCall().setTo(targetEPR);
                    if (this.synchronous) {
                        if (replyToEPR == null) {
                            replyToEPR = ServiceInvoker.this.getReplyToAddress(targetEPR);
                        }
                        if (replyToEPR == null) {
                            logger.debug((Object)("Not using epr [" + targetEPR + "] for Service [" + ServiceInvoker.this.service + "] and Message [" + message.getHeader() + "]. No reply-to address available for synchronous response."));
                            Message message2 = null;
                            return message2;
                        }
                        message.getHeader().getCall().setReplyTo(replyToEPR);
                    }
                    if (courier.deliver(message)) {
                        if (this.synchronous) {
                            courier.cleanup();
                            courier.setReplyToEpr(replyToEPR);
                            Message message3 = courier.pickup(this.timeout);
                            return message3;
                        }
                        Message message4 = message;
                        return message4;
                    }
                }
                catch (FaultMessageException e) {
                    throw e;
                }
                catch (CourierServiceBindException e) {
                    logger.debug((Object)("Caught service lookup exception for EPR [" + targetEPR + "] and Service [" + ServiceInvoker.this.service + "] and Message [" + message.getHeader() + "]. " + e.getMessage()));
                }
                catch (CourierMarshalUnmarshalException e) {
                    logger.warn((Object)("Courier indicated (un)marshal related error " + e + " during delivery to EPR [" + targetEPR + "] for Service [" + ServiceInvoker.this.service + "] and Message [" + message.getHeader() + "]. " + e.getMessage()));
                    throw new MessageDeliverException("Caught (un)marshal related exception during attempted send/receive.", e);
                }
                catch (CourierTransportException e) {
                    logger.debug((Object)("Courier indicated transport related error " + e + " during send/receive with EPR [" + targetEPR + "] for Service [" + ServiceInvoker.this.service + "] and Message [" + message.getHeader() + "]. " + e.getMessage()));
                }
                catch (CourierException e) {
                    logger.warn((Object)("Possible configuration error while using Courier for EPR [" + targetEPR + "] and Service [" + ServiceInvoker.this.service + "] and Message [" + message.getHeader() + "]. " + e.getMessage()));
                }
                catch (MalformedEPRException e) {
                    logger.error((Object)("Unexpected error.  Badly formed EPR [" + targetEPR + "] for Service [" + ServiceInvoker.this.service + "]. But the EPR has already been validated!!"));
                    throw e;
                }
                catch (Throwable t) {
                    logger.error((Object)("Unexpected throwable during attempted message delivery using Courier for EPR [" + targetEPR + "] for Service [" + ServiceInvoker.this.service + "] and Message [" + message.getHeader() + "]."), t);
                    throw new MessageDeliverException("Caught unexpected throwable during send. Bailing-out!", t);
                }
                finally {
                    CourierUtil.cleanCourier(courier);
                    if (currentEpr != null) {
                        message.getHeader().getCall().setTo(currentEpr);
                    }
                }
            }
            return null;
        }
    }
}

