/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SFTPEpr
extends FTPEpr {
    public static final String CERTIFICATE_TAG = "certificate";
    public static final String PASSPHRASE_TAG = "passphrase";
    private boolean certificateSet = false;
    private static URI _type;

    public SFTPEpr(EPR epr) {
        super(epr);
        if (epr instanceof SFTPEpr) {
            this.certificateSet = ((SFTPEpr)epr).certificateSet;
        }
    }

    public SFTPEpr(EPR epr, Element header) {
        super(epr, header);
        NodeList nl = header.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String prefix = nl.item(i).getPrefix();
            String tag = nl.item(i).getLocalName();
            try {
                if (prefix == null || !prefix.equals("jbossesb") || tag == null) continue;
                if (tag.equals(CERTIFICATE_TAG)) {
                    this.getAddr().addExtension(CERTIFICATE_TAG, nl.item(i).getTextContent());
                    this.certificateSet = true;
                    continue;
                }
                if (!tag.equals(PASSPHRASE_TAG)) continue;
                this.getAddr().addExtension(PASSPHRASE_TAG, nl.item(i).getTextContent());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public SFTPEpr(URI uri) {
        super(uri);
    }

    public SFTPEpr(URI uri, URI cert) throws URISyntaxException {
        super(uri);
        this.setCertificateURI(cert);
    }

    public SFTPEpr(URI uri, URI cert, String passphrase) throws URISyntaxException {
        super(uri);
        this.setCertificateURI(cert);
        this.setPassphrase(passphrase);
    }

    public SFTPEpr(String url, String cert) throws URISyntaxException {
        super(url);
        this.setCertificateURI(new URI(cert));
    }

    public SFTPEpr(String url, String cert, String passphrase) throws URISyntaxException {
        super(url);
        this.setCertificateURI(new URI(cert));
        this.setPassphrase(passphrase);
    }

    public final void setCertificateURI(URI cert) throws URISyntaxException {
        if (cert == null) {
            throw new IllegalArgumentException();
        }
        if (this.certificateSet) {
            throw new IllegalStateException("Certificate URI already set.");
        }
        this.getAddr().addExtension(CERTIFICATE_TAG, cert.toASCIIString());
        this.certificateSet = true;
    }

    public final URI getCertificateURI() throws URISyntaxException {
        try {
            String cert = this.getAddr().getExtensionValue(CERTIFICATE_TAG);
            if (cert != null) {
                return new URI(cert);
            }
            return null;
        }
        catch (Exception ex) {
            _logger.warn((Object)"Unexpected parsing exception!", (Throwable)ex);
            return null;
        }
    }

    public final void setPassphrase(String passphrase) {
        if (passphrase == null) {
            throw new IllegalArgumentException();
        }
        this.getAddr().addExtension(PASSPHRASE_TAG, passphrase);
    }

    public final String getPassphrase() {
        return this.getAddr().getExtensionValue(PASSPHRASE_TAG);
    }

    public EPR copy() {
        return new SFTPEpr(this);
    }

    public String toString() {
        return "SFTPEpr [ " + super.getAddr().extendedToString() + " ]";
    }

    public static URI type() {
        return _type;
    }

    static {
        try {
            _type = new URI("urn:jboss/esb/epr/type/sftp");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

