/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.codec.binary.Hex;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.addressing.EPR;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InVMEpr
extends EPR {
    public static final long DEFAULT_LOCKSTEP_WAIT_TIME = 10000L;
    public static final String INVM_PROTOCOL = "invm";
    public static final String LOCKSTEP_ENDPOINT_TAG = "lockstep";
    public static final String LOCKSTEP_WAIT_TIME_TAG = "lockstepWait";
    public static final String PASS_BY_VALUE = "passByValue";
    private boolean _lockstep = false;
    private boolean _lockstepTime = false;
    private boolean _passByValue = false;
    private static URI _type;

    public InVMEpr(EPR epr) {
        this.setAddr(epr.getAddr());
    }

    public InVMEpr(EPR epr, Element header) {
        this(epr);
        NodeList nl = header.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                String prefix = nl.item(i).getPrefix();
                String tag = nl.item(i).getLocalName();
                if (prefix == null || !prefix.equals("jbossesb") || tag == null) continue;
                if (tag.equals(LOCKSTEP_ENDPOINT_TAG)) {
                    this.getAddr().addExtension(LOCKSTEP_ENDPOINT_TAG, nl.item(i).getTextContent());
                    this._lockstep = true;
                }
                if (tag.equals(LOCKSTEP_WAIT_TIME_TAG)) {
                    this.getAddr().addExtension(LOCKSTEP_WAIT_TIME_TAG, nl.item(i).getTextContent());
                    this._lockstepTime = true;
                }
                if (!tag.equals(PASS_BY_VALUE)) continue;
                this.getAddr().addExtension(PASS_BY_VALUE, nl.item(i).getTextContent());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public InVMEpr(URI uri) throws URISyntaxException {
        super(uri);
        String serviceId = uri.getHost();
        String lockstep = uri.getQuery();
        String lockstepTime = uri.getFragment();
        String passByReference = uri.getPath();
        if (serviceId == null) {
            throw new URISyntaxException(uri.toString(), "No serviceId specified!");
        }
        if ("true".equalsIgnoreCase(lockstep)) {
            this.setLockstep(true);
            if (lockstepTime != null) {
                try {
                    this.setLockstepWaitTime(Long.parseLong(lockstepTime));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if ("/true".equalsIgnoreCase(passByReference)) {
            this.setPassByValue(true);
        } else {
            this.setPassByValue(false);
        }
    }

    public String getServiceId() {
        try {
            return new URI(this.getAddr().getAddress()).getHost();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setServiceId(String serviceId) {
        if (serviceId == null) {
            throw new IllegalArgumentException();
        }
        this.getAddr().setAddress("invm://" + serviceId);
    }

    public boolean getLockstep() {
        String lockstep = this.getAddr().getExtensionValue(LOCKSTEP_ENDPOINT_TAG);
        return "true".equalsIgnoreCase(lockstep);
    }

    public void setLockstep(boolean lockstep) {
        if (this._lockstep) {
            throw new IllegalStateException("Lockstep already set!");
        }
        if (lockstep) {
            this.getAddr().addExtension(LOCKSTEP_ENDPOINT_TAG, "true");
        } else {
            this.getAddr().addExtension(LOCKSTEP_ENDPOINT_TAG, "false");
        }
        this._lockstep = true;
    }

    public long getLockstepWaitTime() {
        String waitTime = this.getAddr().getExtensionValue(LOCKSTEP_WAIT_TIME_TAG);
        if (waitTime != null) {
            try {
                return Long.parseLong(waitTime);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 10000L;
    }

    public void setLockstepWaitTime(long waitTime) {
        if (this._lockstepTime) {
            throw new IllegalStateException("Lockstep wait time already set!");
        }
        this.getAddr().addExtension(LOCKSTEP_WAIT_TIME_TAG, "" + waitTime);
        this._lockstepTime = true;
    }

    public boolean getPassByValue() {
        String passByValue = this.getAddr().getExtensionValue(PASS_BY_VALUE);
        if (passByValue == null) {
            return false;
        }
        return !"false".equalsIgnoreCase(passByValue);
    }

    public void setPassByValue(boolean val) {
        if (this._passByValue) {
            throw new IllegalStateException("Pass by value already set!");
        }
        this.getAddr().addExtension(PASS_BY_VALUE, "" + val);
        this._passByValue = true;
    }

    public String toString() {
        return "InVMEpr [ " + super.getAddr().extendedToString() + " ]";
    }

    public static String createEncodedServiceId(String catagory, String name) {
        AssertArgument.isNotNullAndNotEmpty(catagory, "catagory");
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        byte[] bytes = (catagory.trim() + name.trim()).getBytes();
        return new String(Hex.encodeHex((byte[])bytes));
    }

    public EPR copy() {
        return new InVMEpr(this);
    }

    public static URI type() {
        return _type;
    }

    static {
        try {
            _type = new URI("urn:jboss/esb/epr/type/invm");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

