/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.PortReference;

public class EPR {
    protected static final Logger _logger = Logger.getLogger(EPR.class);
    private PortReference _addr;

    public EPR() {
        this._addr = new PortReference();
    }

    public EPR(PortReference addr) {
        this._addr = addr;
    }

    public EPR(URI uri) {
        this._addr = new PortReference(uri.toString());
    }

    public EPR(EPR from) {
        this._addr = from._addr.copy();
    }

    public void setAddr(PortReference uri) {
        this._addr = uri;
    }

    public void setURI(URI uri) {
        this.setAddr(new PortReference(uri.toASCIIString()));
    }

    public URI getURI() throws URISyntaxException {
        return new URI(this.getAddr().getAddress());
    }

    public PortReference getAddr() {
        return this._addr;
    }

    public EPR copy() {
        return new EPR(this);
    }

    public String toString() {
        return "EPR: " + this._addr.extendedToString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EPR) {
            return ((EPR)obj)._addr.equals(this._addr);
        }
        return false;
    }
}

