/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.soa.esb.addressing.EPR;

public class Call {
    private EPR _to = null;
    private EPR _from = null;
    private EPR _faultTo = null;
    private EPR _replyTo = null;
    private URI _relatesTo = null;
    private URI _action = null;
    private URI _messageID = null;

    public Call() {
    }

    public Call(Call copy) throws URISyntaxException {
        this._to = copy._to == null ? null : copy._to.copy();
        this._from = copy._from == null ? null : copy._from.copy();
        this._replyTo = copy._replyTo == null ? null : copy._replyTo.copy();
        this._relatesTo = copy._relatesTo == null ? null : new URI(copy._relatesTo.toString());
        this._faultTo = copy._faultTo == null ? null : copy._faultTo.copy();
        this._action = copy._action == null ? null : new URI(copy._action.toString());
        this._messageID = copy._messageID == null ? null : new URI(copy._messageID.toString());
    }

    public Call(EPR epr) {
        this._to = epr;
    }

    public void setTo(EPR epr) {
        if (epr == null) {
            throw new IllegalArgumentException();
        }
        this._to = epr;
    }

    public EPR getTo() {
        return this._to;
    }

    public void setFrom(EPR from) {
        this._from = from;
    }

    public EPR getFrom() {
        return this._from;
    }

    public void setReplyTo(EPR replyTo) {
        this._replyTo = replyTo;
    }

    public EPR getReplyTo() {
        return this._replyTo;
    }

    public void setFaultTo(EPR uri) {
        this._faultTo = uri;
    }

    public EPR getFaultTo() {
        return this._faultTo;
    }

    public void setRelatesTo(URI uri) {
        this._relatesTo = uri;
    }

    public URI getRelatesTo() {
        return this._relatesTo;
    }

    public void setAction(URI uri) {
        this._action = uri;
    }

    public URI getAction() {
        return this._action;
    }

    public void setMessageID(URI uri) {
        this._messageID = uri;
    }

    public URI getMessageID() {
        return this._messageID;
    }

    public final boolean empty() {
        return this._to == null && this._from == null && this._replyTo == null && this._relatesTo == null && this._faultTo == null && this._action == null && this._messageID == null;
    }

    public void copy(Call from) {
        Call fromImpl = from;
        this._to = fromImpl._to;
        this._from = fromImpl._from;
        this._replyTo = fromImpl._replyTo;
        this._relatesTo = fromImpl._relatesTo;
        this._faultTo = fromImpl._faultTo;
        this._action = fromImpl._action;
        this._messageID = fromImpl._messageID;
    }

    public String stringForm() {
        return "To: " + this._to + ", From: " + this._from + ", ReplyTo: " + this._replyTo + ", FaultTo: " + this._faultTo + ", Action: " + this._action + ", MessageID: " + this._messageID + ", RelatesTo: " + this._relatesTo;
    }

    public String toString() {
        String result = "";
        if (this._to != null) {
            result = "To: " + this._to;
        }
        if (this._from != null) {
            result = result + " From: " + this._from;
        }
        if (this._replyTo != null) {
            result = result + " ReplyTo: " + this._replyTo;
        }
        if (this._faultTo != null) {
            result = result + " FaultTo: " + this._faultTo;
        }
        if (this._action != null) {
            result = result + " Action: " + this._action;
        }
        if (this._messageID != null) {
            result = result + " MessageID: " + this._messageID;
        }
        if (this._relatesTo != null) {
            result = result + " RelatesTo: " + this._relatesTo;
        }
        return result;
    }

    public boolean valid() {
        return this._to != null && this._action != null;
    }
}

