/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing.http;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.routing.http.HttpMethodFactory;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public class POSTHttpMethodFactory
implements HttpMethodFactory {
    private URL url;
    private MessagePayloadProxy payloadProxy;

    public void setEndpoint(URL url) {
        this.url = url;
    }

    public void setConfiguration(ConfigTree config) throws ConfigurationException {
        this.payloadProxy = new MessagePayloadProxy(config);
    }

    public HttpMethodBase getInstance(Message message) throws IOException {
        PostMethod method = new PostMethod(this.url.toString());
        try {
            method.setRequestEntity((RequestEntity)new StringRequestEntity(this.payloadProxy.getPayload(message).toString()));
        }
        catch (MessageDeliverException e) {
            IOException ioe = new IOException("Failed to access message payload.");
            ioe.initCause(e);
            throw ioe;
        }
        return method;
    }
}

