/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.routing.AbstractRouter;
import org.jboss.soa.esb.actions.routing.http.HttpHeader;
import org.jboss.soa.esb.actions.routing.http.HttpMethodFactory;
import org.jboss.soa.esb.actions.routing.http.HttpResponse;
import org.jboss.soa.esb.actions.routing.http.ResponseType;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.http.HttpClientFactory;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;

public class HttpRouter
extends AbstractRouter {
    private static Logger logger = Logger.getLogger(HttpRouter.class);
    private ConfigTree config;
    private Properties httpClientProps = new Properties();
    private HttpClient httpclient;
    private URL endpointUrl;
    private String method;
    private HttpMethodFactory methodFactory;
    private ResponseType responseType;
    private String contentType;
    private ConfigTree[] requestHeaders;
    private final String[] mappedHeaderList;

    public HttpRouter(ConfigTree config) throws ConfigurationException {
        super(config);
        this.config = config;
        try {
            this.endpointUrl = new URL(config.getRequiredAttribute("endpointUrl"));
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid endpoint URL '" + config.getRequiredAttribute("endpointUrl") + "'.", e);
        }
        this.extractHttpClientProps(config);
        this.httpclient = HttpClientFactory.createHttpClient(this.httpClientProps);
        this.method = config.getRequiredAttribute("method");
        this.responseType = ResponseType.valueOf(config.getAttribute("responseType", ResponseType.STRING.toString()));
        this.methodFactory = HttpMethodFactory.Factory.getInstance(this.method.toUpperCase(), config, this.endpointUrl);
        this.contentType = config.getAttribute("Content-Type");
        this.mappedHeaderList = this.extractMappedHeaderListConfig();
        this.requestHeaders = config.getChildren("header");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message process(Message message) throws ActionProcessingException {
        HttpMethodBase method = null;
        try {
            method = this.methodFactory.getInstance(message);
            try {
                this.setRequestHeaders(method, message);
                int responseCode = this.httpclient.executeMethod((HttpMethod)method);
                if (responseCode != 200) {
                    logger.warn((Object)("Received status code '" + responseCode + "' on HTTP " + method + " request to '" + this.endpointUrl + "'."));
                }
                this.attachResponseDetails(message, method, responseCode);
                InputStream resultStream = method.getResponseBodyAsStream();
                try {
                    byte[] bytes = StreamUtils.readStream(resultStream);
                    if (this.responseType == ResponseType.STRING) {
                        this.getPayloadProxy().setPayload(message, new String(bytes, method.getResponseCharSet()));
                    } else {
                        this.getPayloadProxy().setPayload(message, bytes);
                    }
                }
                catch (MessageDeliverException e) {
                    e.printStackTrace();
                }
                finally {
                    resultStream.close();
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return message;
    }

    private String[] extractMappedHeaderListConfig() throws ConfigurationException {
        String mappedHeaders = this.config.getAttribute("MappedHeaderList");
        if (mappedHeaders != null) {
            String[] headerList = mappedHeaders.split(",");
            int numHeaders = headerList.length;
            ArrayList<String> headers = new ArrayList<String>(numHeaders);
            for (int count = 0; count < numHeaders; ++count) {
                String header = headerList[count].trim();
                if (header.length() <= 0) continue;
                headers.add(header);
            }
            return headers.toArray(new String[headers.size()]);
        }
        return new String[0];
    }

    private void attachResponseDetails(Message message, HttpMethodBase method, int responseCode) {
        Header[] responseHeaders;
        HttpResponse response = new HttpResponse(responseCode);
        response.setEncoding(method.getResponseCharSet());
        response.setLength(method.getResponseContentLength());
        for (Header responseHeader : responseHeaders = method.getRequestHeaders()) {
            response.addHeader(new HttpHeader(responseHeader.getName(), responseHeader.getValue()));
        }
        message.getBody().add(HttpResponse.RESPONSE_KEY, response);
    }

    private void setRequestHeaders(HttpMethodBase method, Message message) {
        this.setMappedHttpHeaders(method, message);
        for (int i = 0; i < this.requestHeaders.length; ++i) {
            ConfigTree header = this.requestHeaders[i];
            String name = header.getAttribute("name");
            String value = header.getAttribute("value");
            if (name != null && value != null) {
                method.setRequestHeader(name, value);
                continue;
            }
            logger.error((Object)("null Http request header name/value: '" + name + "':'" + value + "'."));
        }
        if (this.contentType != null) {
            method.setRequestHeader("Content-Type", this.contentType);
        } else if (method.getRequestHeader("Content-Type") == null) {
            method.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
        }
    }

    private void setMappedHttpHeaders(HttpMethodBase method, Message message) {
        for (String headerName : this.mappedHeaderList) {
            String headerValue;
            Object header = this.getHttpHeaders(message, headerName);
            if (header == null || (headerValue = header.toString()).length() <= 0) continue;
            method.setRequestHeader(headerName, headerValue);
        }
    }

    private Object getHttpHeaders(Message esbMessage, String headerName) {
        org.jboss.soa.esb.message.Properties ps = esbMessage.getProperties();
        for (String name : ps.getNames()) {
            if (!name.equalsIgnoreCase(headerName)) continue;
            return ps.getProperty(name);
        }
        return null;
    }

    public String[] getMappedHeaderList() {
        return this.mappedHeaderList;
    }

    public void route(Object object) throws ActionProcessingException {
    }

    public void destroy() throws ActionLifecycleException {
        if (this.httpclient != null) {
            HttpClientFactory.shutdown(this.httpclient);
        }
        super.destroy();
    }

    private void extractHttpClientProps(ConfigTree config) {
        String maxThreads;
        ConfigTree[] httpClientConfigTrees = config.getChildren("http-client-property");
        this.httpClientProps.setProperty("target-host-url", this.endpointUrl.toString());
        ConfigTree parent = config.getParent();
        if (parent != null && (maxThreads = config.getParent().getAttribute("maxThreads")) != null) {
            this.httpClientProps.setProperty("max-total-connections", maxThreads);
        }
        for (ConfigTree httpClientProp : httpClientConfigTrees) {
            String propName = httpClientProp.getAttribute("name");
            String propValue = httpClientProp.getAttribute("value");
            if (propName == null || propValue == null) continue;
            this.httpClientProps.setProperty(propName, propValue);
        }
    }
}

