/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPoolContainer;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsSession;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.routing.AbstractRouter;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.notification.jms.DefaultJMSPropertiesSetter;
import org.jboss.soa.esb.notification.jms.JMSPropertiesSetter;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.soa.esb.util.Util;

public class JMSRouter
extends AbstractRouter {
    private static Logger logger = Logger.getLogger(JMSRouter.class);
    public static final String PERSISTENT_ATTR = "persistent";
    public static final String PRIORITY_ATTR = "priority";
    public static final String TIME_TO_LIVE_ATTR = "time-to-live";
    public static final String SECURITY_PRINCIPAL = "security-principal";
    public static final String SECURITY_CREDITIAL = "security-credential";
    public static final String PROPERTY_STRATEGY = "property-strategy";
    private ConfigTree properties;
    private String queueName;
    private JMSSendQueueSetup queueSetup;
    private final JMSPropertiesSetter jmsPropertiesStrategy;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private String jndiContextFactory;
    private String jndiUrl;
    private String jndiPkgPrefix;
    private String connectionFactory;

    public JMSRouter(ConfigTree propertiesTree) throws ConfigurationException, NamingException, JMSException {
        super(propertiesTree);
        String ttlStr;
        this.properties = propertiesTree;
        this.queueName = this.properties.getAttribute("jndiName");
        if (this.queueName == null) {
            throw new ConfigurationException("JMSRouter must specify a 'jndiName' property.");
        }
        boolean persistent = Boolean.parseBoolean(this.properties.getAttribute(PERSISTENT_ATTR, "true"));
        this.deliveryMode = persistent ? 2 : 1;
        String priorityStr = this.properties.getAttribute(PRIORITY_ATTR);
        if (priorityStr != null) {
            this.priority = Integer.parseInt(priorityStr);
        }
        if ((ttlStr = this.properties.getAttribute(TIME_TO_LIVE_ATTR)) != null) {
            this.timeToLive = Long.parseLong(ttlStr);
        }
        this.jndiContextFactory = this.properties.getAttribute("jndi-context-factory");
        this.jndiUrl = this.properties.getAttribute("jndi-URL");
        this.jndiPkgPrefix = this.properties.getAttribute("jndi-pkg-prefix");
        this.connectionFactory = this.properties.getAttribute("connection-factory");
        String propertyStrategy = this.properties.getAttribute(PROPERTY_STRATEGY);
        if (propertyStrategy == null) {
            this.jmsPropertiesStrategy = new DefaultJMSPropertiesSetter();
        } else {
            try {
                Class propertyStrategyClass = ClassUtil.forName(propertyStrategy, this.getClass());
                this.jmsPropertiesStrategy = (JMSPropertiesSetter)propertyStrategyClass.newInstance();
            }
            catch (Throwable th) {
                throw new ConfigurationException("Failed to instantiate property strategy class: " + propertyStrategy, th);
            }
        }
        String securityPrincipal = this.properties.getAttribute(SECURITY_PRINCIPAL);
        String securityCredential = this.properties.getAttribute(SECURITY_CREDITIAL);
        if (securityPrincipal != null && securityCredential == null) {
            throw new ConfigurationException("'security-principal' must be accompanied by a 'security-credential'");
        }
        if (securityCredential != null && securityPrincipal == null) {
            throw new ConfigurationException("'security-credential' must be accompanied by a 'security-principal'");
        }
        this.createQueueSetup(this.queueName, this.jndiContextFactory, this.jndiUrl, this.jndiPkgPrefix, this.connectionFactory, securityPrincipal, securityCredential);
    }

    public Message process(Message message) throws ActionProcessingException {
        this.route(message);
        return null;
    }

    public void route(Object message) throws ActionProcessingException {
        if (!(message instanceof Message)) {
            throw new ActionProcessingException("Cannot send Object [" + message.getClass().getName() + "] to destination [" + this.queueName + "]. Object must be an instance of org.jboss.soa.esb.message.Message) .");
        }
        Message esbMessage = (Message)message;
        try {
            javax.jms.Message jmsMessage = null;
            if (this.unwrap) {
                Object objectFromBody = this.getPayloadProxy().getPayload(esbMessage);
                jmsMessage = this.createJMSMessageWithObjectType(objectFromBody);
            } else {
                jmsMessage = this.createObjectMessage(Util.serialize(esbMessage));
            }
            this.setStringProperties(jmsMessage);
            this.setJMSProperties(esbMessage, jmsMessage);
            this.setJMSReplyTo(jmsMessage, esbMessage);
            this.send(jmsMessage);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Exception while sending message [").append(message).append("] to destination [");
            if (this.queueSetup != null) {
                sb.append(this.queueSetup.destinationName).append("].");
            } else {
                sb.append("null ].");
            }
            String errorMessage = sb.toString();
            logger.error((Object)errorMessage, (Throwable)e);
            throw new ActionProcessingException(errorMessage, e);
        }
    }

    protected javax.jms.Message createJMSMessageWithObjectType(Object objectFromBody) throws JMSException {
        TextMessage jmsMessage = null;
        if (objectFromBody instanceof String) {
            jmsMessage = this.queueSetup.jmsSession.createTextMessage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending Text message: [" + objectFromBody + "] to destination [" + this.queueSetup.destinationName + "]."));
            }
            jmsMessage.setText((String)objectFromBody);
        } else if (objectFromBody instanceof byte[]) {
            jmsMessage = this.queueSetup.jmsSession.createBytesMessage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending byte[] message: [" + objectFromBody + "] to destination [" + this.queueSetup.destinationName + "]."));
            }
            ((BytesMessage)jmsMessage).writeBytes((byte[])objectFromBody);
        } else {
            jmsMessage = this.createObjectMessage(objectFromBody);
        }
        return jmsMessage;
    }

    protected void send(javax.jms.Message jmsMessage) throws JMSException {
        this.queueSetup.jmsProducer.send(jmsMessage);
    }

    protected void setJMSProperties(Message fromESBMessage, javax.jms.Message toJMSMessage) throws JMSException {
        this.jmsPropertiesStrategy.setJMSProperties(fromESBMessage, toJMSMessage);
    }

    protected javax.jms.Message createObjectMessage(Object message) throws JMSException {
        ObjectMessage jmsMessage = this.queueSetup.jmsSession.createObjectMessage();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending Object message: [" + message + "] to destination [" + this.queueSetup.destinationName + "]."));
        }
        jmsMessage.setObject((Serializable)message);
        return jmsMessage;
    }

    private void setStringProperties(javax.jms.Message msg) throws JMSException {
        String messagePropPrefix = "message-prop-";
        for (KeyValuePair property : this.properties.attributesAsList()) {
            String key = property.getKey();
            if (!key.startsWith(messagePropPrefix) || key.length() <= messagePropPrefix.length()) continue;
            msg.setStringProperty(key.substring(messagePropPrefix.length()), property.getValue());
        }
    }

    public Serializable getOkNotification(Message message) {
        return null;
    }

    public Serializable getErrorNotification(Message message) {
        return null;
    }

    protected void finalize() throws Throwable {
        this.queueSetup.close();
        super.finalize();
    }

    protected void createQueueSetup(String queueName) throws ConfigurationException {
        this.createQueueSetup(queueName, null, null, null, null, null, null);
    }

    protected void createQueueSetup(String queueName, String jndiContextFactory, String jndiUrl, String jndiPkgPrefix, String connectionFactory, String securityPrincipal, String securityCredential) throws ConfigurationException {
        try {
            this.queueSetup = new JMSSendQueueSetup(queueName, jndiContextFactory, jndiUrl, jndiPkgPrefix, connectionFactory, securityPrincipal, securityCredential);
            this.queueSetup.setDeliveryMode(this.deliveryMode);
            this.queueSetup.setPriority(this.priority);
            this.queueSetup.setTimeToLive(this.timeToLive);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("JMSRouter DeliveryMode : " + this.deliveryMode));
                logger.debug((Object)("JMSRouter Priority : " + this.priority));
                logger.debug((Object)("JMSRouter TimeToLive : " + this.timeToLive));
            }
        }
        catch (Throwable t) {
            throw new ConfigurationException("Failed to configure JMS Queue for routing.", t);
        }
    }

    protected void setJMSReplyTo(javax.jms.Message jmsMessage, Message esbMessage) throws URISyntaxException, JMSException, NamingException, ConnectionException, NamingContextException {
        Destination destination = (Destination)esbMessage.getProperties().getProperty("javax.jms.message.replyTo");
        if (destination != null) {
            jmsMessage.setJMSReplyTo(destination);
        }
    }

    public boolean isDeliveryModePersistent() {
        return this.deliveryMode == 2;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public String getContextFactoryName() {
        return this.jndiContextFactory;
    }

    public String getJndiURL() {
        return this.jndiUrl;
    }

    public String getJndiPkgPrefix() {
        return this.jndiPkgPrefix;
    }

    public String getConnectionFactory() {
        return this.connectionFactory;
    }

    private static class JMSSendQueueSetup {
        JmsSession jmsSession;
        Destination jmsDestination;
        MessageProducer jmsProducer;
        String destinationName;
        JmsConnectionPool pool;

        private JMSSendQueueSetup(String destinationName) throws NamingException, JMSException, ConnectionException, NamingContextException {
            this(destinationName, null, null, null, null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JMSSendQueueSetup(String destinationName, String jndiContextFactory, String jndiUrl, String jndiPkgPrefix, String connectionFactoryName, String securityPrincipal, String securityCredential) throws NamingException, JMSException, ConnectionException, NamingContextException {
            if (jndiContextFactory == null) {
                jndiContextFactory = Configuration.getJndiServerContextFactory();
            }
            if (jndiUrl == null) {
                jndiUrl = Configuration.getJndiServerURL();
            }
            if (jndiPkgPrefix == null) {
                jndiPkgPrefix = Configuration.getJndiServerPkgPrefix();
            }
            if (connectionFactoryName == null) {
                connectionFactoryName = "ConnectionFactory";
            }
            Properties environment = new Properties();
            environment.setProperty("java.naming.factory.initial", jndiContextFactory);
            environment.setProperty("java.naming.provider.url", jndiUrl);
            environment.setProperty("java.naming.factory.url.pkgs", jndiPkgPrefix);
            Context oCtx = NamingContextPool.getNamingContext(environment);
            try {
                this.pool = securityPrincipal != null ? JmsConnectionPoolContainer.getPool(environment, connectionFactoryName, securityPrincipal, securityCredential) : JmsConnectionPoolContainer.getPool(environment, connectionFactoryName);
                this.destinationName = destinationName;
                this.jmsSession = this.pool.getSession();
                boolean clean = true;
                try {
                    try {
                        this.jmsDestination = (Destination)oCtx.lookup(destinationName);
                    }
                    catch (NamingException ne) {
                        try {
                            oCtx = NamingContextPool.replaceNamingContext(oCtx, environment);
                            this.jmsDestination = (Queue)oCtx.lookup(destinationName);
                        }
                        catch (NamingException nex) {
                            this.jmsDestination = this.jmsSession.createQueue(destinationName);
                        }
                    }
                    this.jmsProducer = this.jmsSession.createProducer(this.jmsDestination);
                    clean = false;
                }
                finally {
                    if (clean) {
                        this.pool.closeSession(this.jmsSession);
                    }
                }
            }
            finally {
                NamingContextPool.releaseNamingContext(oCtx);
            }
        }

        public void setDeliveryMode(int deliveryMode) throws JMSException {
            if (this.jmsProducer != null) {
                this.jmsProducer.setDeliveryMode(deliveryMode);
            }
        }

        public void setPriority(int priority) throws JMSException {
            if (this.jmsProducer != null) {
                this.jmsProducer.setPriority(priority);
            }
        }

        public void setTimeToLive(long ttl) throws JMSException {
            if (this.jmsProducer != null) {
                this.jmsProducer.setTimeToLive(ttl);
            }
        }

        private void close() {
            try {
                this.pool.closeSession(this.jmsSession);
                if (this.jmsProducer != null) {
                    this.jmsProducer.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to close JMS Queue Setup.", (Throwable)e);
            }
        }
    }
}

