/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.client.MessageMulticaster;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;

public class StaticWiretap
extends AbstractActionPipelineProcessor {
    public static final String ROUTE_TO_TAG = "route-to";
    protected ConfigTree _config;
    protected MessageMulticaster messageMulticaster;
    protected static Logger _logger = Logger.getLogger(StaticWiretap.class);

    public StaticWiretap(ConfigTree config) throws ConfigurationException, RegistryException {
        this._config = config;
    }

    public Message process(Message message) throws ActionProcessingException {
        try {
            this.messageMulticaster.sendToAll(message);
            return message;
        }
        catch (RegistryException e) {
            throw new ActionProcessingException(e);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
    }

    public void initialise() throws ActionLifecycleException {
        this.messageMulticaster = new MessageMulticaster(this._config.getAttribute("action", "%unset%"));
        ConfigTree[] destList = this._config.getChildren(ROUTE_TO_TAG);
        if (null == destList || destList.length < 1) {
            _logger.warn((Object)"Missing or empty destination list - This action class won't have any effect");
            return;
        }
        for (ConfigTree curr : destList) {
            try {
                String category = curr.getAttribute("service-category", "");
                String name = curr.getRequiredAttribute("service-name");
                Service service = new Service(category, name);
                this.messageMulticaster.addRecipient(service);
            }
            catch (Exception e) {
                throw new ActionLifecycleException("Problems with destination list", e);
            }
        }
    }
}

