/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.AggregationDetails;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregator
extends AbstractActionPipelineProcessor {
    public static final String AGGEGRATOR_TAG = "aggregatorTag";
    public static final String SPLITTER_TIME_STAMP = "splitterTimeStamp";
    private Map<String, Map<Integer, Message>> aggregatedMessageMap = new ConcurrentHashMap<String, Map<Integer, Message>>();
    private TimeoutChecker _timeoutChecker = null;
    protected ConfigTree config;
    private Logger logger = Logger.getLogger(Aggregator.class);
    private Long timeoutInMillis = null;
    private Set<String> receivedSplits = new HashSet<String>();
    private String splitId;

    private Aggregator() {
    }

    public Aggregator(ConfigTree config) throws ConfigurationException, RegistryException {
        this.config = config;
        String timeoutAttr = config.getAttribute("timeoutInMillies", null);
        if (timeoutAttr != null) {
            this.logger.warn((Object)"Aggregator config: timeoutInMillies is deprecated. Use timeoutInMillis in future.");
        } else {
            timeoutAttr = config.getAttribute("timeoutInMillis", null);
        }
        if (timeoutAttr != null) {
            try {
                this.timeoutInMillis = Long.valueOf(timeoutAttr);
            }
            catch (NumberFormatException ex) {
                this.logger.error((Object)("Invalid value for timeoutInMillis: " + timeoutAttr));
                throw new ConfigurationException(ex);
            }
        }
        this.logger.debug((Object)("Aggregator config:  timeoutInMillis=" + this.timeoutInMillis));
        this.splitId = config.getAttribute("splitId");
    }

    @Override
    public void initialise() throws ActionLifecycleException {
        this._timeoutChecker = new TimeoutChecker();
        this._timeoutChecker.start();
    }

    public Map<String, Map<Integer, Message>> getAggregatedMessageMap() {
        return this.aggregatedMessageMap;
    }

    @Override
    public void destroy() throws ActionLifecycleException {
        this._timeoutChecker.terminate();
        this._timeoutChecker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message process(Message message) throws ActionProcessingException {
        List<String> aggregatorTags = Aggregator.getAggregatorTags(message);
        if (aggregatorTags != null && aggregatorTags.size() > 0) {
            String aggregatorTag = aggregatorTags.get(aggregatorTags.size() - 1);
            AggregationDetails aggrDetails = new AggregationDetails(aggregatorTag);
            this.assertAggregationDetailsOK(aggrDetails);
            message.getProperties().setProperty(SPLITTER_TIME_STAMP, aggrDetails.getSeriesTimestamp());
            Map<String, Map<Integer, Message>> map = this.aggregatedMessageMap;
            synchronized (map) {
                Map<Integer, Message> messageMap = this.aggregatedMessageMap.get(aggrDetails.getSeriesUuid());
                if (this.isTimedOut(aggrDetails.getSeriesTimestamp())) {
                    if (messageMap != null) {
                        if (!messageMap.containsKey(aggrDetails.getMessageNumber())) {
                            messageMap.put(aggrDetails.getMessageNumber(), message);
                        }
                        message = this.createAggregateMessage(aggrDetails.getSeriesUuid(), messageMap);
                    } else {
                        this.logger.debug((Object)"Ignoring this message since we are already timedout on this message.");
                        message = null;
                    }
                } else {
                    if (messageMap == null) {
                        messageMap = new ConcurrentHashMap<Integer, Message>();
                        this.aggregatedMessageMap.put(aggrDetails.getSeriesUuid(), messageMap);
                    }
                    if (messageMap.containsKey(aggrDetails.getMessageNumber())) {
                        this.logger.warn((Object)"Received duplicate message, ignoring it but this should not happen.");
                    } else {
                        messageMap.put(aggrDetails.getMessageNumber(), message);
                    }
                    message = messageMap.size() == aggrDetails.getSeriesSize() ? this.createAggregateMessage(aggrDetails.getSeriesUuid(), messageMap) : null;
                }
            }
        } else {
            message = this.createAggregateMessage(message);
        }
        return message;
    }

    private void assertAggregationDetailsOK(AggregationDetails aggrDetails) throws ActionProcessingException {
        if (this.splitId != null) {
            if (!this.splitId.equals(aggrDetails.getSplitId())) {
                throw new ActionProcessingException("Invalid aggregation config on aggregator '" + this.config.getAttribute("action") + "' .  " + "This aggregator is configured " + "to only aggregate message with an aggregation 'spliId' of '" + this.splitId + "'. " + "The splitId on the received message is '" + aggrDetails.getSplitId() + "'. " + "A nested aggregation point may be missing, or may have been bypassed.");
            }
        } else {
            if (!this.receivedSplits.contains(aggrDetails.getSplitId())) {
                this.receivedSplits.add(aggrDetails.getSplitId());
            }
            if (this.receivedSplits.size() > 1) {
                this.logger.warn((Object)("Aggregator action '" + this.config.getAttribute("action") + "' has received " + "split messages from more multiple 'splitId' sources: " + this.receivedSplits + "\n" + "You may need to configure an intermediate/nested aggregator at " + "some point in the message flow."));
            }
        }
    }

    public static List<String> getAggregatorTags(Message message) {
        return (List)message.getProperties().getProperty(AGGEGRATOR_TAG);
    }

    public static void setAggregatorTags(Message message, List<String> tags) {
        if (tags != null) {
            message.getProperties().setProperty(AGGEGRATOR_TAG, tags);
        } else {
            message.getProperties().remove(AGGEGRATOR_TAG);
        }
    }

    public static AggregationDetails getAggregatorDetails(Message message, int tagIndex) throws ActionProcessingException {
        List<String> tags = Aggregator.getAggregatorTags(message);
        if (tags == null || tags.isEmpty()) {
            return null;
        }
        return new AggregationDetails(tags.get(tagIndex));
    }

    public static void decorate(Message message) {
    }

    public Message createAggregateMessage(Message message) throws ActionProcessingException {
        Message aggregatedMessage = MessageFactory.getInstance().getMessage();
        Aggregator.setAggregatorTags(message, null);
        try {
            aggregatedMessage.getAttachment().addItem(Util.serialize(message));
        }
        catch (ParserConfigurationException e) {
            throw new ActionProcessingException("Message attachment serialization failure", e);
        }
        catch (IOException e) {
            throw new ActionProcessingException("Message attachment serialization failure", e);
        }
        return aggregatedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message createAggregateMessage(String uuId, Map<Integer, Message> messageMap) throws ActionProcessingException {
        Message aggregatedMessage = MessageFactory.getInstance().getMessage();
        List<String> aggregatedMessageTags = this.copyAggregationTags(messageMap);
        Aggregator.setAggregatorTags(aggregatedMessage, aggregatedMessageTags);
        for (Message attachmentMessage : messageMap.values()) {
            try {
                Aggregator.setAggregatorTags(attachmentMessage, null);
                aggregatedMessage.getAttachment().addItem(Util.serialize(attachmentMessage));
            }
            catch (ParserConfigurationException e) {
                throw new ActionProcessingException("Message attachment serialization failure", e);
            }
            catch (IOException e) {
                throw new ActionProcessingException("Message attachment serialization failure", e);
            }
        }
        Map<String, Map<Integer, Message>> map = this.aggregatedMessageMap;
        synchronized (map) {
            this.aggregatedMessageMap.remove(uuId);
        }
        return aggregatedMessage;
    }

    private List<String> copyAggregationTags(Map<Integer, Message> messageMap) {
        List<String> nestedAggregationTags = Aggregator.getAggregatorTags(messageMap.values().iterator().next());
        if (nestedAggregationTags != null && nestedAggregationTags.size() > 1) {
            ArrayList<String> aggregatedMessageTags = new ArrayList<String>();
            aggregatedMessageTags.addAll(nestedAggregationTags);
            aggregatedMessageTags.remove(aggregatedMessageTags.size() - 1);
            return aggregatedMessageTags;
        }
        return null;
    }

    private boolean isTimedOut(long splitterTimeStamp) {
        if (this.timeoutInMillis != null) {
            long now = new Date().getTime();
            long expiration = splitterTimeStamp + this.timeoutInMillis;
            if (this.logger.isDebugEnabled()) {
                DateFormat dateFormat = DateFormat.getTimeInstance();
                this.logger.debug((Object)("Current time=" + dateFormat.format(new Date(now)) + " message expiration=" + dateFormat.format(new Date(expiration))));
            }
            if (now > expiration) {
                this.logger.debug((Object)"message expired.");
                return true;
            }
            this.logger.debug((Object)"message is alive.");
        }
        return false;
    }

    class TimeoutChecker
    extends Thread {
        private final Lock terminateLock = new ReentrantLock();
        private final Condition terminateCondition = this.terminateLock.newCondition();
        private boolean terminated;
        ServiceInvoker dlQueueInvoker;

        TimeoutChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.dlQueueInvoker = new ServiceInvoker("JBossESB-Internal", "DeadLetterService");
            }
            catch (MessageDeliverException e) {
                Aggregator.this.logger.error((Object)"Unable to initialise Dead Letter Channel Service Invoker for Aggregation timeout checker. Not using Dead Letter Channel.", (Throwable)e);
            }
            boolean running = true;
            while (running) {
                if (Aggregator.this.timeoutInMillis != null) {
                    for (Map messageMap : Aggregator.this.aggregatedMessageMap.values()) {
                        Object aggregateMessage;
                        List<String> aggregatorTag;
                        Message message = (Message)messageMap.values().iterator().next();
                        long timeStamp = (Long)message.getProperties().getProperty(Aggregator.SPLITTER_TIME_STAMP);
                        if (!Aggregator.this.isTimedOut(timeStamp) || (aggregatorTag = Aggregator.getAggregatorTags(message)) == null || aggregatorTag.isEmpty()) continue;
                        AggregationDetails aggrDetails = new AggregationDetails(aggregatorTag.get(aggregatorTag.size() - 1));
                        try {
                            Aggregator.this.logger.info((Object)("Deleting message aggregation series: " + aggrDetails.getSeriesUuid()));
                            if (this.dlQueueInvoker == null) continue;
                            aggregateMessage = Aggregator.this.createAggregateMessage(aggrDetails.getSeriesUuid(), messageMap);
                            this.dlQueueInvoker.deliverAsync((Message)aggregateMessage);
                        }
                        catch (Throwable e) {
                            Aggregator.this.logger.error((Object)"Error delivering timed out aggregation message to Dead Letter Service.", e);
                        }
                        finally {
                            aggregateMessage = Aggregator.this.aggregatedMessageMap;
                            synchronized (aggregateMessage) {
                                Aggregator.this.aggregatedMessageMap.remove(aggrDetails.getSeriesUuid());
                            }
                        }
                    }
                }
                this.terminateLock.lock();
                try {
                    if (!this.terminated) {
                        this.terminateCondition.await(500L, TimeUnit.MILLISECONDS);
                    }
                    running = !this.terminated;
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    this.terminateLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            this.terminateLock.lock();
            try {
                this.terminated = true;
                this.terminateCondition.signalAll();
            }
            finally {
                this.terminateLock.unlock();
            }
        }
    }
}

