/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.webservice;

import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.jboss.internal.soa.esb.webservice.ESBServiceEndpointInfo;
import org.jboss.internal.soa.esb.webservice.OneWayBaseWebService;
import org.jboss.internal.soa.esb.webservice.RequestResponseBaseWebService;
import org.jboss.internal.soa.esb.webservice.WebServicePublishException;

public class JAXWSProviderClassGenerator {
    private final ClassPool pool = new ClassPool();
    private final CtClass oneWaySuperClass;
    private final CtClass requestResponseSuperClass;

    public JAXWSProviderClassGenerator() throws WebServicePublishException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            this.pool.appendClassPath((ClassPath)new LoaderClassPath(tccl));
        }
        this.pool.appendClassPath((ClassPath)new LoaderClassPath(JAXWSProviderClassGenerator.class.getClassLoader()));
        try {
            this.oneWaySuperClass = this.pool.get(OneWayBaseWebService.class.getName());
            this.requestResponseSuperClass = this.pool.get(RequestResponseBaseWebService.class.getName());
        }
        catch (NotFoundException nfe) {
            throw new WebServicePublishException("Failed to obtain superclasses", nfe);
        }
    }

    public byte[] generate(String category, String service, ESBServiceEndpointInfo epInfo) throws WebServicePublishException {
        try {
            this.pool.get(epInfo.getClassName());
            throw new WebServicePublishException("Duplicate class within context: " + epInfo.getClassName());
        }
        catch (NotFoundException nfe) {
            CtClass seiClass = this.pool.makeClass(epInfo.getClassName());
            try {
                if (epInfo.isOneWay()) {
                    seiClass.setSuperclass(this.oneWaySuperClass);
                } else {
                    seiClass.setSuperclass(this.requestResponseSuperClass);
                }
                ConstPool constantPool = seiClass.getClassFile().getConstPool();
                AnnotationsAttribute attribute = new AnnotationsAttribute(constantPool, "RuntimeVisibleAnnotations");
                Annotation annotation = new Annotation("javax.xml.ws.WebServiceProvider", constantPool);
                StringMemberValue strValue1 = new StringMemberValue(constantPool);
                strValue1.setValue(epInfo.getWSDLFileName());
                annotation.addMemberValue("wsdlLocation", (MemberValue)strValue1);
                StringMemberValue strValue2 = new StringMemberValue(constantPool);
                strValue2.setValue(epInfo.getServiceName());
                annotation.addMemberValue("serviceName", (MemberValue)strValue2);
                StringMemberValue strValue3 = new StringMemberValue(constantPool);
                strValue3.setValue(epInfo.getPortName());
                annotation.addMemberValue("portName", (MemberValue)strValue3);
                StringMemberValue strValue4 = new StringMemberValue(constantPool);
                strValue4.setValue(epInfo.getNamespace());
                annotation.addMemberValue("targetNamespace", (MemberValue)strValue4);
                attribute.addAnnotation(annotation);
                Annotation annotation2 = new Annotation("javax.xml.ws.ServiceMode", constantPool);
                EnumMemberValue enumValue = new EnumMemberValue(constantPool);
                enumValue.setType("javax.xml.ws.Service$Mode");
                enumValue.setValue("MESSAGE");
                annotation2.addMemberValue("value", (MemberValue)enumValue);
                attribute.addAnnotation(annotation2);
                seiClass.getClassFile().addAttribute((AttributeInfo)attribute);
                String constructorStr = "super(\"" + category + "\"," + "\"" + service + "\");";
                CtConstructor defaultConstructor = new CtConstructor(null, seiClass);
                defaultConstructor.setBody(constructorStr);
                seiClass.addConstructor(defaultConstructor);
                return seiClass.toBytecode();
            }
            catch (Exception e) {
                throw new WebServicePublishException("Failed to generate jaxws dispatch class for ESB service", e);
            }
        }
    }
}

