/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.webservice;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ActionsDocument;
import org.jboss.soa.esb.listeners.config.xbeanmodel.MepType;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ServiceDocument;

public class ESBServiceEndpointInfo {
    private static final String DEFAULT_ENCODING;
    private static final Logger LOGGER;
    private final String requestName;
    private final String responseName;
    private final String faultName;
    private final String bindingName;
    private final String serviceName;
    private final String portName;
    private final String operationName;
    private final String servletName;
    private final String servletPath;
    private final String wsdlFileName;
    private final String packageName;
    private final String className;
    private final String namespace;
    private final boolean isOneWay;
    private final String action;

    public ESBServiceEndpointInfo(ServiceDocument.Service service) throws UnsupportedEncodingException {
        String name = service.getName();
        this.requestName = name + "Req";
        this.responseName = name + "Res";
        this.faultName = name + "Fault";
        this.bindingName = name + "Binding";
        this.serviceName = name + "Service";
        this.portName = name + "PortType";
        this.operationName = name + "Op";
        String serviceCategory = service.getCategory().replace('/', '_');
        String serviceName = service.getName().replace('/', '_');
        this.servletName = serviceCategory + "_" + serviceName;
        this.servletPath = "/" + serviceCategory + "/" + serviceName;
        this.wsdlFileName = "WEB-INF/wsdl/" + serviceCategory + "/" + serviceName + ".wsdl";
        this.packageName = "esb.ws." + serviceCategory + "." + serviceName;
        this.className = this.packageName + ".Implementation";
        this.namespace = "http://soa.jboss.org/" + URLEncoder.encode(service.getCategory(), DEFAULT_ENCODING);
        this.action = this.namespace + "/" + this.operationName;
        ActionsDocument.Actions actions = service.getActions();
        if (actions != null) {
            boolean bl = this.isOneWay = actions.getOutXsd() == null;
            if (this.isOneWay) {
                if (actions.getFaultXsd() != null) {
                    LOGGER.warn((Object)("Fault schemas ignored for OneWay service " + serviceCategory + ":" + serviceName));
                }
                if (MepType.REQUEST_RESPONSE.equals(actions.getMep())) {
                    LOGGER.warn((Object)("No response specified for RequestResponse service " + serviceCategory + ":" + serviceName));
                }
            }
        } else {
            this.isOneWay = false;
        }
    }

    public String getRequestName() {
        return this.requestName;
    }

    public String getResponseName() {
        return this.responseName;
    }

    public String getFaultName() {
        return this.faultName;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getWSDLFileName() {
        return this.wsdlFileName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isOneWay() {
        return this.isOneWay;
    }

    static {
        LOGGER = Logger.getLogger(ESBServiceEndpointInfo.class);
        DEFAULT_ENCODING = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("file.encoding");
            }
        });
    }
}

