/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.webservice;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.soa.esb.Service;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;

public class ESBServiceContractPublisher
implements ContractReferencePublisher {
    private String address;
    private final String endpointName;
    private final Service service;
    private final String description;

    public ESBServiceContractPublisher(Service service, String description, String jaxwsEndpoint) {
        this.service = service;
        this.description = description;
        this.endpointName = jaxwsEndpoint;
    }

    public Service getService() {
        return this.service;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getServiceURI() {
        String address = this.getEndpointAddress();
        if (address != null) {
            try {
                return new URI(address);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public URI getServiceContractURI() {
        String address = this.getEndpointAddress();
        if (address != null) {
            try {
                return new URI(address + "?wsdl");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getEndpointAddress() {
        if (this.address != null) {
            return this.address;
        }
        SPIProvider spiProv = SPIProviderResolver.getInstance().getProvider();
        EndpointRegistryFactory factory = (EndpointRegistryFactory)spiProv.getSPI(EndpointRegistryFactory.class);
        EndpointRegistry registry = factory.getEndpointRegistry();
        Set objectNames = registry.getEndpoints();
        for (ObjectName objectName : objectNames) {
            String endpoint = objectName.getKeyProperty("endpoint");
            if (endpoint == null || !endpoint.equals(this.endpointName)) continue;
            Endpoint ep = registry.getEndpoint(objectName);
            this.address = ep.getAddress();
            return this.address;
        }
        return null;
    }
}

