/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.webservice;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWebService
implements Provider<SOAPMessage> {
    private static final QName SERVER_FAULT_QN = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    private static final boolean RETURN_STACK_TRACES;
    private static final Logger LOGGER;
    protected final ServiceInvoker serviceInvoker;

    protected BaseWebService(String category, String name) throws MessageDeliverException {
        this.serviceInvoker = new ServiceInvoker(category, name);
    }

    public SOAPMessage invoke(SOAPMessage request) {
        Message esbReq = MessageFactory.getInstance().getMessage();
        try {
            SOAPBody soapBody = request.getSOAPBody();
            if (soapBody == null) {
                throw new WebServiceException("Missing SOAP body from request");
            }
            Iterator children = soapBody.getChildElements();
            boolean found = false;
            while (children.hasNext()) {
                Node node = (Node)children.next();
                if (!(node instanceof SOAPElement)) continue;
                if (found) {
                    throw new SOAPException("Found multiple SOAPElements in SOAPBody");
                }
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                YADOMUtil.serialize((org.w3c.dom.Node)node, new StreamResult(byteStream), true);
                byteStream.close();
                esbReq.getBody().add(byteStream.toString());
                found = true;
            }
            if (!found) {
                throw new SOAPException("Could not find SOAPElement in SOAPBody");
            }
            Message esbRes = this.deliverMessage(esbReq);
            if (esbRes != null) {
                Object input = esbRes.getBody().get();
                if (input == null) {
                    throw new SOAPException("Null response from service");
                }
                String soapRes = input.toString();
                Document respDoc = YADOMUtil.parseStream(new ByteArrayInputStream(soapRes.getBytes()), false, false, true);
                SOAPMessage response = javax.xml.soap.MessageFactory.newInstance().createMessage();
                response.getSOAPBody().addDocument(respDoc);
                return response;
            }
            return javax.xml.soap.MessageFactory.newInstance().createMessage();
        }
        catch (WebServiceException wse) {
            throw wse;
        }
        catch (Exception ex) {
            try {
                FaultMessageException fme;
                Message faultMessage;
                SOAPMessage faultMsg = null;
                if (ex instanceof FaultMessageException && (faultMessage = (fme = (FaultMessageException)ex).getReturnedMessage()) != null) {
                    Body body = faultMessage.getBody();
                    QName faultCode = (QName)body.get("org.jboss.soa.esb.message.fault.detail.code");
                    String faultDescription = (String)body.get("org.jboss.soa.esb.message.fault.detail.description");
                    String faultDetail = (String)body.get("org.jboss.soa.esb.message.fault.detail.detail");
                    if (faultCode != null) {
                        faultMsg = javax.xml.soap.MessageFactory.newInstance().createMessage();
                        SOAPFault fault = faultMsg.getSOAPBody().addFault(faultCode, faultDescription);
                        if (faultDetail != null) {
                            try {
                                Document detailDoc = YADOMUtil.parseStream(new ByteArrayInputStream(faultDetail.getBytes()), false, false, true);
                                Detail detail = fault.addDetail();
                                detail.appendChild((org.w3c.dom.Node)detailDoc.getDocumentElement());
                            }
                            catch (Exception ex2) {
                                LOGGER.warn((Object)"Failed to parse fault detail", (Throwable)ex2);
                            }
                        }
                    } else {
                        Throwable cause = fme.getCause();
                        SOAPMessage sOAPMessage = faultMsg = cause != null ? this.generateFault(cause) : this.generateFault(ex);
                    }
                }
                if (faultMsg == null) {
                    faultMsg = this.generateFault(ex);
                }
                return faultMsg;
            }
            catch (SOAPException soape) {
                throw new WebServiceException("Unexpected exception generating fault response", (Throwable)soape);
            }
        }
    }

    private SOAPMessage generateFault(Throwable th) throws SOAPException {
        SOAPMessage faultMsg = javax.xml.soap.MessageFactory.newInstance().createMessage();
        if (RETURN_STACK_TRACES) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            pw.close();
            faultMsg.getSOAPBody().addFault(SERVER_FAULT_QN, sw.toString());
        } else {
            faultMsg.getSOAPBody().addFault(SERVER_FAULT_QN, th.getMessage());
        }
        return faultMsg;
    }

    protected abstract Message deliverMessage(Message var1) throws Exception;

    static {
        LOGGER = Logger.getLogger(BaseWebService.class);
        PropertyManager propertyManager = ModulePropertyManager.getPropertyManager("transports");
        String returnStackTraces = propertyManager.getProperty("org.jboss.soa.esb.ws.returnStackTrace");
        RETURN_STACK_TRACES = Boolean.parseBoolean(returnStackTraces);
    }
}

