/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.internal.soa.esb.util.stax.ParsingSupport;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.util.StringPropertyReplacer;
import org.xml.sax.SAXException;

public class XMLHelper {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLHelper.getXMLInputFactory();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    public static XMLStreamReader getXMLStreamReader(Reader reader) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(reader);
    }

    public static XMLStreamReader getXMLStreamReader(InputStream is) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(is);
    }

    public static XMLStreamReader getXMLStreamReader(InputStream is, String encoding) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(is, encoding);
    }

    public static XMLStreamWriter getXMLStreamWriter(Writer writer) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
    }

    public static XMLStreamWriter getXMLStreamWriter(OutputStream os) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(os);
    }

    public static XMLStreamWriter getXMLStreamWriter(OutputStream os, String encoding) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(os, encoding);
    }

    public static void replaceSystemProperties(XMLStreamReader streamReader, XMLStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartDocument();
        StreamHelper.skipToStartElement(streamReader);
        QName elementName = streamReader.getName();
        String uri = StreamHelper.writeStartElement(streamWriter, elementName);
        new SystemPropertyReplacementParser(streamReader, streamWriter);
        StreamHelper.writeEndElement(streamWriter, elementName.getPrefix(), uri);
        streamWriter.writeEndDocument();
        streamWriter.flush();
    }

    public static Schema getSchema(String resource) throws SAXException {
        InputStream resourceIS = ClassUtil.getResourceAsStream(resource, XMLHelper.class);
        return SCHEMA_FACTORY.newSchema(new StreamSource(resourceIS));
    }

    public static boolean validate(Schema schema, String xml) {
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(new StringReader(xml)));
            return true;
        }
        catch (IOException ioe) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    private static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return xmlInputFactory;
    }

    private static final class SystemPropertyReplacementParser
    extends ParsingSupport {
        private final XMLStreamWriter out;

        SystemPropertyReplacementParser(XMLStreamReader in, XMLStreamWriter out) throws XMLStreamException {
            this.out = out;
            this.parse(in);
        }

        protected void putValue(XMLStreamReader in, String value) throws XMLStreamException {
            this.out.writeCharacters(StringPropertyReplacer.replaceProperties((String)value));
        }

        protected void putAttribute(XMLStreamReader in, QName attributeName, String attributeValue) throws XMLStreamException {
            StreamHelper.writeAttribute(this.out, attributeName, StringPropertyReplacer.replaceProperties((String)attributeValue));
        }

        protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
            String uri = StreamHelper.writeStartElement(this.out, elementName);
            new SystemPropertyReplacementParser(in, this.out);
            StreamHelper.writeEndElement(this.out, elementName.getPrefix(), uri);
        }
    }
}

