/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.FtpUtils;
import org.jboss.internal.soa.esb.util.SecureFtpUserInfo;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.eprs.SFTPEpr;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.soa.esb.util.FileUtil;
import org.jboss.soa.esb.util.RemoteFileSystem;
import org.jboss.soa.esb.util.RemoteFileSystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureFtpImpl
implements RemoteFileSystem {
    private static final Logger _logger = Logger.getLogger(SecureFtpImpl.class);
    private static final String TMP_SUFFIX = ".rosettaPart";
    private static final String SECURE_CHANNEL = "sftp";
    private JSch m_oJSch = new JSch();
    private Session session = null;
    private ChannelSftp m_oSftpChannel = null;
    private int m_iPort;
    private SFTPEpr m_oEpr;
    private ConfigTree m_oParms;
    private String m_sFtpServer;
    private String m_sUser;
    private String m_sPasswd;
    private String m_sRemoteDir;
    private String m_sLocalDir;
    private URI m_oCertificate;
    private String m_sPassphrase;

    public SecureFtpImpl(ConfigTree p_oP, boolean p_bConnect) throws ConfigurationException, RemoteFileSystemException {
        this.m_oParms = p_oP;
        this.initialize(p_bConnect);
    }

    public SecureFtpImpl(SFTPEpr p_oP, boolean p_bConnect) throws ConfigurationException, RemoteFileSystemException {
        URI uri;
        this.m_oEpr = p_oP;
        try {
            uri = this.m_oEpr.getURI();
        }
        catch (URISyntaxException e) {
            throw new RemoteFileSystemException(e);
        }
        this.m_sFtpServer = uri.getHost();
        String[] sa = null;
        if (uri.getUserInfo() != null) {
            sa = uri.getUserInfo().split(":");
        }
        int saLen = sa == null ? 0 : sa.length;
        switch (saLen) {
            case 2: {
                this.m_sPasswd = sa[1];
            }
            case 1: {
                this.m_sUser = sa[0];
            }
        }
        this.m_sRemoteDir = uri.getPath();
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (this.m_sRemoteDir == null || this.m_sRemoteDir.equals("")) {
            this.m_sRemoteDir = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.remotedir", tmpdir);
        }
        this.m_iPort = uri.getPort();
        this.m_sLocalDir = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.localdir", tmpdir);
        try {
            this.m_oCertificate = p_oP.getCertificateURI();
        }
        catch (URISyntaxException urise) {
            _logger.warn((Object)urise);
        }
        this.m_sPassphrase = p_oP.getPassphrase();
        this.configTreeFromEpr();
        this.initialize(p_bConnect);
    }

    public SecureFtpImpl(List<KeyValuePair> attribs, boolean connect) throws ConfigurationException, RemoteFileSystemException {
        this.m_oParms = new ConfigTree("fromProps");
        for (KeyValuePair oCurr : attribs) {
            this.m_oParms.setAttribute(oCurr.getKey(), oCurr.getValue());
        }
        this.initialize(connect);
    }

    private void initialize(boolean bConnect) throws ConfigurationException, RemoteFileSystemException {
        this.checkParms();
        if (bConnect) {
            try {
                this.session = this.m_iPort > 0 ? this.m_oJSch.getSession(this.m_sUser, this.m_sFtpServer, this.m_iPort) : this.m_oJSch.getSession(this.m_sUser, this.m_sFtpServer);
                if (this.m_sPasswd != null) {
                    this.session.setPassword(this.m_sPasswd);
                    this.session.setConfig("PreferredAuthentications", "password");
                } else if (this.m_oCertificate != null) {
                    String certificateName;
                    InputStream is;
                    String certificate = this.m_oCertificate.toString();
                    InputStream resourceIS = ClassUtil.getResourceAsStream(certificate, this.getClass());
                    if (resourceIS != null) {
                        is = resourceIS;
                        certificateName = SecureFtpImpl.getSimpleName(certificate);
                    } else {
                        certificateName = SecureFtpImpl.getSimpleName(this.m_oCertificate.getPath());
                        try {
                            if (this.m_oCertificate.isAbsolute()) {
                                is = this.m_oCertificate.toURL().openStream();
                            } else {
                                File file = new File(this.m_oCertificate.getPath());
                                is = file.toURL().openStream();
                            }
                        }
                        catch (IOException ioe) {
                            throw new ConfigurationException("Unexpected IOException accessing: " + certificate, ioe);
                        }
                    }
                    byte[] privateKey = StreamUtils.readStream(is);
                    this.m_oJSch.addIdentity(certificateName, privateKey, null, null);
                    SecureFtpUserInfo ui = new SecureFtpUserInfo(this.m_sPassphrase);
                    this.session.setUserInfo((UserInfo)ui);
                    this.session.setConfig("PreferredAuthentications", "publickey");
                }
                this.session.setConfig("StrictHostKeyChecking", "no");
                this.session.connect();
                Channel channel = this.session.openChannel(SECURE_CHANNEL);
                channel.connect();
                this.m_oSftpChannel = (ChannelSftp)channel;
                if (!this.session.isConnected()) {
                    throw new RemoteFileSystemException("Can't connect to FTP server");
                }
            }
            catch (JSchException ex) {
                if (this.session != null && this.session.isConnected()) {
                    this.session.disconnect();
                }
                _logger.error((Object)"Caught Secure FTP Exception.");
                _logger.debug((Object)"Caught Secure FTP Exception.", (Throwable)ex);
                throw new RemoteFileSystemException(ex);
            }
        }
    }

    private static String getSimpleName(String name) throws ConfigurationException {
        if (name == null) {
            throw new ConfigurationException("Null certificate name");
        }
        int lastIndex = name.lastIndexOf(47);
        if (lastIndex >= 0) {
            int startIndex = lastIndex + 1;
            if (startIndex == name.length()) {
                throw new ConfigurationException("Invalid certificate name: " + name);
            }
            return name.substring(startIndex);
        }
        return name;
    }

    private void checkParms() throws ConfigurationException {
        String att = this.m_oParms.getAttribute("URL");
        URI uri = null;
        try {
            if (att != null) {
                uri = new URI(att);
            }
        }
        catch (URISyntaxException ex) {
            throw new ConfigurationException(ex);
        }
        String string = this.m_sFtpServer = null != uri ? uri.getHost() : this.m_oParms.getAttribute("ftpServer");
        if (null == this.m_sFtpServer) {
            throw new ConfigurationException("No SFTP server specified");
        }
        String[] sa = null == uri ? null : uri.getUserInfo().split(":");
        String string2 = this.m_sUser = null != sa ? sa[0] : this.m_oParms.getAttribute("ftpUser");
        if (null == this.m_sUser) {
            throw new ConfigurationException("No username specified for SFTP");
        }
        this.m_sPasswd = null != sa && sa.length > 1 ? sa[1] : this.m_oParms.getAttribute("ftpPassword");
        String string3 = this.m_sRemoteDir = null != uri ? uri.getPath() : this.m_oParms.getAttribute("ftpRemoteDir");
        if (null == this.m_sRemoteDir) {
            this.m_sRemoteDir = "";
        }
        this.m_sLocalDir = this.m_oParms.getAttribute("ftpLocalDir");
        if (null == this.m_sLocalDir) {
            this.m_sLocalDir = ".";
        }
        String sAux = this.m_oParms.getAttribute("ftpPort");
        try {
            this.m_iPort = null != uri ? uri.getPort() : (null == sAux ? 22 : Integer.parseInt(sAux));
            String certificate = this.m_oParms.getAttribute("certificate");
            if (certificate != null) {
                this.m_oCertificate = new URI(certificate);
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
        this.m_sPassphrase = this.m_oParms.getAttribute("passphrase");
    }

    @Override
    public void deleteRemoteFile(String p_sFile) throws RemoteFileSystemException {
        try {
            this.m_oSftpChannel.cd(this.getRemoteDir());
            this.m_oSftpChannel.rm(p_sFile);
        }
        catch (SftpException ex) {
            throw new RemoteFileSystemException(ex);
        }
    }

    @Override
    public void remoteDelete(File p_oFile) throws RemoteFileSystemException {
        try {
            this.m_oSftpChannel.rm(FtpUtils.fileToFtpString(p_oFile));
        }
        catch (SftpException ex) {
            throw new RemoteFileSystemException(ex);
        }
    }

    @Override
    public String[] getFileListFromRemoteDir(String p_sSuffix) throws RemoteFileSystemException {
        try {
            this.m_oSftpChannel.cd(this.getRemoteDir());
            String sSuffix = null == p_sSuffix ? "*" : "*" + p_sSuffix;
            ArrayList<String> lFileList = new ArrayList<String>();
            Vector vFileList = this.m_oSftpChannel.ls(sSuffix);
            if (vFileList != null) {
                for (int i = 0; i < vFileList.size(); ++i) {
                    SftpATTRS oSftAttr;
                    Object obj = vFileList.elementAt(i);
                    if (!(obj instanceof ChannelSftp.LsEntry) || (oSftAttr = ((ChannelSftp.LsEntry)obj).getAttrs()).isDir()) continue;
                    lFileList.add(((ChannelSftp.LsEntry)obj).getFilename());
                }
            }
            return lFileList.toArray(new String[lFileList.size()]);
        }
        catch (SftpException ex) {
            if (ex.id == 2) {
                return null;
            }
            throw new RemoteFileSystemException(ex);
        }
    }

    @Override
    public void setRemoteDir(String p_sDir) throws RemoteFileSystemException {
        this.m_sRemoteDir = p_sDir;
    }

    @Override
    public void renameInRemoteDir(String p_sFrom, String p_sTo) throws RemoteFileSystemException {
        try {
            this.m_oSftpChannel.cd(this.getRemoteDir());
            this.m_oSftpChannel.rename(p_sFrom, p_sTo);
        }
        catch (SftpException se) {
            throw new RemoteFileSystemException("Faile to rename file", se);
        }
    }

    @Override
    public void remoteRename(File p_oFrom, File p_oTo) throws RemoteFileSystemException {
        try {
            this.m_oSftpChannel.cd(this.getRemoteDir());
            this.m_oSftpChannel.rename(FtpUtils.fileToFtpString(p_oFrom), FtpUtils.fileToFtpString(p_oTo));
        }
        catch (SftpException se) {
            throw new RemoteFileSystemException("Faile to rename file", se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadFile(File p_oFile, String p_sRemoteName) throws RemoteFileSystemException {
        try {
            this.m_oSftpChannel.cd(this.getRemoteDir());
            String sRemoteTmp = p_sRemoteName + TMP_SUFFIX;
            OutputStream os = this.m_oSftpChannel.put(sRemoteTmp);
            try {
                FileInputStream fis = new FileInputStream(p_oFile);
                try {
                    this.copyStream(fis, os);
                }
                finally {
                    fis.close();
                }
            }
            finally {
                os.flush();
                os.close();
            }
            this.m_oSftpChannel.rename(sRemoteTmp, p_sRemoteName);
        }
        catch (IOException ioe) {
            throw new RemoteFileSystemException(ioe);
        }
        catch (SftpException ex) {
            throw new RemoteFileSystemException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(String p_sFile, String p_sFinalName) throws IOException, RemoteFileSystemException {
        try {
            File toTmp;
            File oNewTmp;
            File oNew;
            File to = new File(p_sFinalName);
            File oLocalDir = new File(this.m_sLocalDir);
            File file = oNew = to.isAbsolute() ? to : new File(oLocalDir, p_sFinalName);
            if (oNew.exists()) {
                oNew.delete();
            }
            File file2 = oNewTmp = (toTmp = new File(p_sFinalName + TMP_SUFFIX)).isAbsolute() ? toTmp : new File(oLocalDir, p_sFinalName + TMP_SUFFIX);
            if (oNewTmp.exists()) {
                oNewTmp.delete();
            }
            this.m_oSftpChannel.cd(this.getRemoteDir());
            InputStream is = this.m_oSftpChannel.get(p_sFile);
            try {
                FileOutputStream fos = new FileOutputStream(oNewTmp);
                try {
                    this.copyStream(is, fos);
                }
                finally {
                    fos.close();
                }
            }
            finally {
                is.close();
            }
            FileUtil.renameTo(oNewTmp, oNew);
        }
        catch (SftpException ex) {
            throw new RemoteFileSystemException(ex);
        }
    }

    @Override
    public String getRemoteDir() {
        return this.m_sRemoteDir;
    }

    @Override
    public void quit() {
        this.m_oSftpChannel.disconnect();
        this.session.disconnect();
    }

    private void configTreeFromEpr() throws ConfigurationException {
        this.m_oParms = new ConfigTree("fromEpr");
        try {
            this.m_oParms.setAttribute("ftpServer", this.m_sFtpServer);
            this.m_oParms.setAttribute("ftpUser", this.m_sUser);
            if (this.m_sPasswd != null) {
                this.m_oParms.setAttribute("ftpPassword", this.m_sPasswd);
            }
            this.m_oParms.setAttribute("ftpRemoteDir", this.m_sRemoteDir);
            if (this.m_iPort > 0) {
                this.m_oParms.setAttribute("ftpPort", Integer.toString(this.m_iPort));
            }
            this.m_oParms.setAttribute("ftpLocalDir", this.m_sLocalDir);
            this.m_oParms.setAttribute("ftpAscii", Boolean.toString(false));
            if (this.m_oCertificate != null) {
                this.m_oParms.setAttribute("certificate", this.m_oCertificate.toString());
            }
            if (this.m_sPassphrase != null) {
                this.m_oParms.setAttribute("passphrase", this.m_sPassphrase);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private void copyStream(InputStream is, OutputStream os) throws IOException {
        int count;
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        byte[] buffer = new byte[256];
        while ((count = bis.read(buffer)) > 0) {
            bos.write(buffer, 0, count);
        }
        bos.flush();
    }
}

