/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.soap;

import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class OGNLUtils {
    private static Logger logger = Logger.getLogger(OGNLUtils.class);
    public static final String JBOSSESB_SOAP_NS = "http://jbossesb.jboss.org/soap";
    public static final String JBOSSESB_SOAP_NS_PREFIX = "jbossesb-soap:";
    public static final String OGNL_ATTRIB = "ognl";
    public static final String IS_COLLECTION_ATTRIB = "is-collection";

    public static Object getParameter(String ognl, Map params) {
        Object param;
        block3: {
            param = params.get(ognl);
            if (param == null) {
                try {
                    param = Ognl.getValue((String)ognl, (Object)params);
                }
                catch (OgnlException ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)"OGNL Error.", (Throwable)ex);
                }
            }
        }
        return param != null ? param : "";
    }

    public static String getOGNLExpression(Element element) {
        return OGNLUtils.getOGNLExpression(element, null);
    }

    public static String getOGNLExpression(Element element, String nameSpace) {
        String preassignedOgnl = element.getAttributeNS(JBOSSESB_SOAP_NS, OGNL_ATTRIB);
        if (preassignedOgnl != null && !preassignedOgnl.equals("")) {
            return preassignedOgnl;
        }
        StringBuffer ognlExpression = new StringBuffer();
        boolean isInBody = false;
        ognlExpression.append(OGNLUtils.getOGNLToken(element));
        for (Node parent = element.getParentNode(); parent != null && parent.getNodeType() == 1; parent = parent.getParentNode()) {
            Element parentElement = (Element)parent;
            String parentName = YADOMUtil.getName(parentElement);
            if (parentName.equalsIgnoreCase("body") && OGNLUtils.checkParentNameSpace(parent.getNamespaceURI(), nameSpace)) {
                isInBody = true;
                break;
            }
            preassignedOgnl = parentElement.getAttributeNS(JBOSSESB_SOAP_NS, OGNL_ATTRIB);
            if (preassignedOgnl != null && !preassignedOgnl.equals("")) {
                ognlExpression.insert(0, "." + preassignedOgnl);
                isInBody = true;
                break;
            }
            ognlExpression.insert(0, OGNLUtils.getOGNLToken(parentElement));
        }
        if (!isInBody) {
            return "";
        }
        ognlExpression.deleteCharAt(0);
        return ognlExpression.toString();
    }

    public static String getOGNLToken(Element element) {
        String ognlToken;
        String localName = element.getLocalName();
        if (OGNLUtils.assertIsParentCollection(element)) {
            int count = YADOMUtil.countElementsBefore(element, element.getTagName());
            ognlToken = "[" + count + "]";
        } else {
            ognlToken = "." + localName;
        }
        return ognlToken;
    }

    protected static boolean checkParentNameSpace(String parentNS, String namespace) {
        SOAPNameSpaces[] defaultNamespaces;
        if (parentNS == null) {
            return false;
        }
        for (SOAPNameSpaces defaultNS : defaultNamespaces = SOAPNameSpaces.values()) {
            if (!parentNS.equalsIgnoreCase(defaultNS.getNameSpace())) continue;
            return true;
        }
        return parentNS.equalsIgnoreCase(namespace);
    }

    private static boolean assertIsCollection(Element element) {
        if (element.getAttributeNS(JBOSSESB_SOAP_NS, IS_COLLECTION_ATTRIB).equals("true")) {
            return true;
        }
        Comment firstComment = (Comment)YADOMUtil.getFirstChildByType(element, 8);
        return firstComment != null && firstComment.getTextContent().indexOf("1 or more repetitions") != -1;
    }

    private static boolean assertIsParentCollection(Element element) {
        Node parent = element.getParentNode();
        return parent != null && parent.getNodeType() == 1 && OGNLUtils.assertIsCollection((Element)parent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SOAPNameSpaces {
        SOAP_1_1("http://schemas.xmlsoap.org/soap/envelope/"),
        SOAP_1_2("http://www.w3.org/2003/05/soap-envelope");

        private String nameSpace;

        private SOAPNameSpaces(String nameSpace) {
            this.nameSpace = nameSpace;
        }

        public String getNameSpace() {
            return this.nameSpace;
        }
    }
}

