/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.security;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.services.security.EsbCallbackHandler;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;

public class UserPassCallbackHandler
implements EsbCallbackHandler {
    private Logger log = Logger.getLogger(UserPassCallbackHandler.class);
    private AuthenticationRequest authRequest;

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (this.authRequest == null) {
            throw new IllegalStateException("No AuthenticationRequest has been set");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Nr of callback to handle : " + callbacks.length));
        }
        for (int i = 0; i < callbacks.length; ++i) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Callback" + callbacks[i].getClass().getName()));
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.authRequest.getPrincipal().getName());
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                for (Object object : this.authRequest.getCredentials()) {
                    if (object instanceof char[]) {
                        pc.setPassword((char[])object);
                        continue;
                    }
                    if (!(object instanceof String)) continue;
                    pc.setPassword(((String)object).toCharArray());
                }
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "UserPassCallbackHandler");
        }
    }

    public void setAuthenticationRequest(AuthenticationRequest authRequest) {
        this.authRequest = authRequest;
    }

    public void setSecurityConfig(SecurityConfig config) {
    }
}

