/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.security;

import com.sun.security.auth.login.ConfigFile;
import java.net.URL;
import java.security.Principal;
import java.security.Security;
import java.security.acl.Group;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.services.security.EsbCallbackHandler;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.SecurityContext;
import org.jboss.soa.esb.services.security.SecurityService;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.principals.Role;
import org.jboss.soa.esb.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JaasSecurityService
implements SecurityService {
    private static final String LOGIN_CONFIG_URL_PREFIX = "login.config.url.";
    private String callbackHandlerClassName;
    private javax.security.auth.login.Configuration containerConfig;
    private javax.security.auth.login.Configuration configuration;
    private final Logger log = Logger.getLogger(JaasSecurityService.class);

    @Override
    public void authenticate(SecurityConfig config, SecurityContext securityContext, AuthenticationRequest authRequest) throws SecurityServiceException {
        AssertArgument.isNotNull(config, "config");
        String runAs = config.getRunAs();
        try {
            LoginContext loginContext;
            EsbCallbackHandler callbackHandler = this.createCallbackHandler(config, authRequest);
            try {
                loginContext = new LoginContext(config.getModuleName(), securityContext.getSubject(), callbackHandler, this.getConfiguration());
            }
            catch (LoginException ignore) {
                loginContext = new LoginContext(config.getModuleName(), securityContext.getSubject(), callbackHandler, this.containerConfig);
            }
            loginContext.login();
            Subject subject = securityContext.getSubject();
            this.addRunAs(runAs, subject);
            Principal principal = this.getPrincipal(subject);
            SecurityAssociation.pushSubjectContext((Subject)subject, (Principal)principal, subject.getPublicCredentials());
            if (runAs != null) {
                SecurityAssociation.pushRunAsIdentity((RunAsIdentity)new RunAsIdentity(runAs, principal.getName()));
            }
        }
        catch (LoginException e) {
            throw new SecurityServiceException("Exception while trying to login:", e);
        }
    }

    @Override
    public boolean checkRolesAllowed(List<String> rolesAllowed, SecurityContext securityContext) {
        if (rolesAllowed.isEmpty()) {
            return true;
        }
        for (String roleName : rolesAllowed) {
            boolean isInRole = securityContext.isCallerInRole(roleName);
            if (!isInRole) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCallerInRole(Subject subject, Principal role) {
        Set<Group> principals = subject.getPrincipals(Group.class);
        for (Group group : principals) {
            if (!group.isMember(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void configure() throws ConfigurationException {
        try {
            this.containerConfig = javax.security.auth.login.Configuration.getConfiguration();
        }
        catch (SecurityException ignore) {
            this.log.warn((Object)"Could not locate a security configuration");
        }
        Properties securityProperties = Configuration.getSecurityServiceProperies();
        String loginConfigUrl = securityProperties.getProperty("org.jboss.soa.esb.services.security.configUrl");
        if (loginConfigUrl != null) {
            URL loginUrl = ClassUtil.getResource(loginConfigUrl, this.getClass());
            if (loginUrl == null) {
                String invalidPropertyMsg = "The value for property [org.jboss.soa.esb.services.security.configUrl] must be a valid URL. This property should point to a file on the local file system or on the classpath.";
                throw new ConfigurationException("The value for property [org.jboss.soa.esb.services.security.configUrl] must be a valid URL. This property should point to a file on the local file system or on the classpath.");
            }
            this.addLoginConfig(loginUrl);
        }
        this.callbackHandlerClassName = securityProperties.getProperty("org.jboss.soa.esb.services.security.callbackHandler");
    }

    @Override
    public void logout(SecurityConfig config) {
    }

    @Override
    public synchronized void refreshSecurityConfig() {
        if (this.configuration != null) {
            this.log.info((Object)"Refreshing Security configuration");
            this.configuration.refresh();
        }
    }

    private Principal getPrincipal(Subject subject) {
        Iterator<Principal> i$ = subject.getPrincipals().iterator();
        if (i$.hasNext()) {
            Principal principal = i$.next();
            return principal;
        }
        return null;
    }

    private EsbCallbackHandler createCallbackHandler(SecurityConfig config, AuthenticationRequest authRequest) throws SecurityServiceException {
        EsbCallbackHandler callbackHandler = null;
        String callbackImpl = config.getCallbackHandler();
        if (callbackImpl == null) {
            callbackImpl = this.callbackHandlerClassName;
        }
        if (callbackImpl != null) {
            callbackHandler = (EsbCallbackHandler)this.createNewInstance(callbackImpl);
            callbackHandler.setAuthenticationRequest(authRequest);
            callbackHandler.setSecurityConfig(config);
        }
        return callbackHandler;
    }

    private void addLoginConfig(URL loginConfigUrl) throws ConfigurationException {
        String registeredLoginUrl;
        if (loginConfigUrl == null) {
            throw new ConfigurationException("Could not locate the login config file at Url [" + loginConfigUrl + "]");
        }
        int urlIndex = 1;
        boolean loginUrlRegistered = false;
        while ((registeredLoginUrl = Security.getProperty(LOGIN_CONFIG_URL_PREFIX + urlIndex)) != null && !(loginUrlRegistered = registeredLoginUrl.equals(loginConfigUrl.toString()))) {
            ++urlIndex;
        }
        if (!loginUrlRegistered) {
            this.log.info((Object)("Adding file [ " + loginConfigUrl + "] as [" + LOGIN_CONFIG_URL_PREFIX + urlIndex + "]"));
            Security.setProperty(LOGIN_CONFIG_URL_PREFIX + urlIndex, loginConfigUrl.toExternalForm());
            this.setConfiguration(new ConfigFile());
        }
    }

    private synchronized javax.security.auth.login.Configuration getConfiguration() {
        return this.configuration;
    }

    private synchronized void setConfiguration(javax.security.auth.login.Configuration configuration) {
        this.configuration = configuration;
    }

    private void addRunAs(String runAs, Subject subject) {
        if (runAs != null) {
            Role runAsRole = new Role(runAs);
            Set<org.jboss.soa.esb.services.security.principals.Group> principals = subject.getPrincipals(org.jboss.soa.esb.services.security.principals.Group.class);
            if (principals.isEmpty()) {
                org.jboss.soa.esb.services.security.principals.Group group = new org.jboss.soa.esb.services.security.principals.Group("Roles");
                group.addMember(runAsRole);
                subject.getPrincipals().add((Principal)((Object)group));
            } else {
                for (org.jboss.soa.esb.services.security.principals.Group groups : principals) {
                    if (!"Roles".equals(groups.getName())) continue;
                    groups.addMember(runAsRole);
                }
            }
        }
    }

    private <T extends EsbCallbackHandler> T createNewInstance(String className) throws SecurityServiceException {
        try {
            Class forName = ClassUtil.forName(className, this.getClass());
            return (T)((EsbCallbackHandler)forName.newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new SecurityServiceException("ClassNotFoundException while trying to create an impl of [" + className + "]", e);
        }
        catch (InstantiationException e) {
            throw new SecurityServiceException("InstantiationException while trying to create an impl of [" + className + "]", e);
        }
        catch (IllegalAccessException e) {
            throw new SecurityServiceException("IllegalAccess while trying to create an impl of [" + className + "]", e);
        }
    }
}

