/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.services.registry.Registry;
import org.jboss.soa.esb.services.registry.RegistryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockRegistryImpl
implements Registry {
    private static Map<String, Category> categories = new HashMap<String, Category>();

    protected Service registerService(String categoryName, String serviceName, String serviceDescription) {
        Category category = categories.get(categoryName);
        if (category == null) {
            category = new Category();
            categories.put(categoryName, category);
        }
        Service service = new Service();
        service.setName(serviceName);
        service.setDescription(serviceDescription);
        category.getServices().add(service);
        return service;
    }

    @Override
    public void unRegisterService(String categoryName, String serviceName) throws RegistryException {
        Category category = categories.get(categoryName);
        if (category == null) {
            throw new RegistryException("Service not found");
        }
        List<Service> services = category.getServices();
        for (Service service : services) {
            if (!serviceName.equals(service.getName())) continue;
            services.remove(service);
        }
    }

    @Override
    public void registerEPR(String categoryName, String serviceName, String serviceDescription, EPR epr, String eprDescription) throws RegistryException {
        Service service = this.registerService(categoryName, serviceName, serviceDescription);
        ServiceBinding serviceBinding = new ServiceBinding();
        serviceBinding.setDescription(eprDescription);
        serviceBinding.setEpr(epr);
        service.getServiceBindings().add(serviceBinding);
    }

    @Override
    public void unRegisterEPR(String category, String serviceName, EPR toBeDeletedEPR) throws RegistryException {
        Service service = MockRegistryImpl.findService(category, serviceName);
        List<ServiceBinding> serviceBindings = service.getServiceBindings();
        for (ServiceBinding binding : serviceBindings) {
            if (!toBeDeletedEPR.equals(binding.getEpr())) continue;
            serviceBindings.remove(binding);
        }
    }

    @Override
    public List<String> findAllServices() throws RegistryException {
        ArrayList<String> serviceNames = new ArrayList<String>();
        for (Category category : categories.values()) {
            for (Service service : category.getServices()) {
                serviceNames.add(service.name);
            }
        }
        return serviceNames;
    }

    @Override
    public List<String> findServices(String categoryName) throws RegistryException {
        ArrayList<String> serviceNames = new ArrayList<String>();
        Category category = categories.get(categoryName);
        if (category == null) {
            throw new RegistryException("No category called " + categoryName + " exist");
        }
        for (Service service : category.getServices()) {
            serviceNames.add(service.name);
        }
        return serviceNames;
    }

    @Override
    public List<EPR> findEPRs(String categoryName, String serviceName) throws RegistryException {
        ArrayList<EPR> eprs = new ArrayList<EPR>();
        Service service = MockRegistryImpl.findService(categoryName, serviceName);
        for (ServiceBinding serviceBinding : service.serviceBindings) {
            eprs.add(serviceBinding.getEpr());
        }
        return eprs;
    }

    @Override
    public EPR findEPR(String categoryName, String serviceName) throws RegistryException {
        Service service = MockRegistryImpl.findService(categoryName, serviceName);
        Iterator<ServiceBinding> i$ = service.serviceBindings.iterator();
        if (i$.hasNext()) {
            ServiceBinding serviceBinding = i$.next();
            return serviceBinding.getEpr();
        }
        return null;
    }

    protected static synchronized Service findService(String categoryName, String serviceName) throws RegistryException {
        Category category = categories.get(categoryName);
        for (Service service : category.getServices()) {
            if (!serviceName.equals(service.getName())) continue;
            return service;
        }
        throw new RegistryException("No service called " + serviceName + " exists in category " + categoryName);
    }

    protected static synchronized Collection<Service> findServicesForCategory(String categoryName) {
        Category category = categories.get(categoryName);
        return category.getServices();
    }

    class ServiceBinding {
        String name;
        String description;
        EPR epr;

        ServiceBinding() {
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public EPR getEpr() {
            return this.epr;
        }

        public void setEpr(EPR epr) {
            this.epr = epr;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Service {
        String name;
        String description;
        List<ServiceBinding> serviceBindings = new ArrayList<ServiceBinding>();

        Service() {
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<ServiceBinding> getServiceBindings() {
            return this.serviceBindings;
        }

        public void setServiceBindings(List<ServiceBinding> serviceBindings) {
            this.serviceBindings = serviceBindings;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Category {
        List<Service> services = new ArrayList<Service>();

        Category() {
        }

        public List<Service> getServices() {
            return this.services;
        }

        public void setServices(List<Service> services) {
            this.services = services;
        }
    }
}

