/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.registry;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.internal.soa.esb.addressing.helpers.EPRHelper;
import org.jboss.internal.soa.esb.services.registry.JAXRConnectionFactory;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.MarshalException;
import org.jboss.soa.esb.UnmarshalException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.services.registry.Registry;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRRegistryImpl
implements Registry {
    private static Logger logger = Logger.getLogger(JAXRRegistryImpl.class);
    private JAXRConnectionFactory jaxrConnectionFactory = new JAXRConnectionFactory();
    private static Organization jbossESBOrganization;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Service registerService(String category, String serviceName, String serviceDescription) throws JAXRException {
        Service service = null;
        Organization organization = this.getJBossESBOrganization();
        Connection connection = this.jaxrConnectionFactory.getConnection();
        try {
            RegistryService rs = connection.getRegistryService();
            BusinessQueryManager bqm = rs.getBusinessQueryManager();
            BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
            service = blm.createService(blm.createInternationalString(serviceName));
            service.setDescription(blm.createInternationalString(serviceDescription));
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("andAllKeys");
            findQualifiers.add("sortByNameDesc");
            ClassificationScheme cScheme = bqm.findClassificationSchemeByName(findQualifiers, "org.jboss.soa.esb.:category");
            Classification classification = blm.createClassification(cScheme, "category", category);
            service.addClassification(classification);
            organization.addService(service);
            JAXRRegistryImpl.saveRegistryObject((RegistryObject)service, this.jaxrConnectionFactory);
        }
        finally {
            this.jaxrConnectionFactory.closeConnection(connection);
        }
        return service;
    }

    @Override
    public void unRegisterService(String category, String serviceName) throws RegistryException, ServiceNotFoundException {
        Connection connection = this.jaxrConnectionFactory.getConnection();
        Service service = null;
        try {
            service = this.findService(category, serviceName);
            if (service == null) {
                throw new ServiceNotFoundException("No such EPR found for service with name = " + serviceName);
            }
            RegistryService rs = connection.getRegistryService();
            BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
            ArrayList<Key> serviceKeys = new ArrayList<Key>();
            serviceKeys.add(service.getKey());
            blm.deleteServices(serviceKeys);
        }
        catch (JAXRException je) {
            throw new RegistryException(je.getLocalizedMessage(), je);
        }
        finally {
            this.jaxrConnectionFactory.closeConnection(connection);
        }
    }

    @Override
    public void registerEPR(String category, String serviceName, String serviceDescription, EPR epr, String eprDescription) throws RegistryException {
        Connection connection = this.jaxrConnectionFactory.getConnection();
        try {
            Service service = this.findService(category, serviceName);
            if (service == null) {
                logger.log((Priority)Level.DEBUG, (Object)("Service " + serviceName + " does not yet exist, creating now.."));
                service = this.registerService(category, serviceName, serviceDescription);
            }
            RegistryService rs = connection.getRegistryService();
            BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
            BusinessQueryManager bqm = rs.getBusinessQueryManager();
            ServiceBinding serviceBinding = blm.createServiceBinding();
            serviceBinding.setDescription(blm.createInternationalString(eprDescription));
            String xml = EPRHelper.toXMLString(epr);
            serviceBinding.setAccessURI(xml);
            ArrayList<ServiceBinding> serviceBindings = new ArrayList<ServiceBinding>();
            serviceBindings.add(serviceBinding);
            service.addServiceBindings(serviceBindings);
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("andAllKeys");
            findQualifiers.add("sortByNameDesc");
            ClassificationScheme cScheme = bqm.findClassificationSchemeByName(findQualifiers, "org.jboss.soa.esb.:category");
            Classification classification = blm.createClassification(cScheme, "category", category);
            service.addClassification(classification);
            JAXRRegistryImpl.saveRegistryObject((RegistryObject)serviceBinding, this.jaxrConnectionFactory);
        }
        catch (JAXRException je) {
            throw new RegistryException(je.getLocalizedMessage(), je);
        }
        catch (MarshalException me) {
            throw new RegistryException(me.getLocalizedMessage(), me);
        }
        finally {
            this.jaxrConnectionFactory.closeConnection(connection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unRegisterEPR(String category, String serviceName, EPR toBeDeletedEPR) throws RegistryException, ServiceNotFoundException {
        Connection connection = this.jaxrConnectionFactory.getConnection();
        Service service = null;
        try {
            service = this.findService(category, serviceName);
            if (service == null) {
                throw new ServiceNotFoundException("No such Service found for service with category= " + category + " and name = " + serviceName);
            }
            Collection<ServiceBinding> serviceBindings = this.findServiceBindings(service);
            service.addServiceBindings(serviceBindings);
            Iterator<ServiceBinding> i = serviceBindings.iterator();
            while (i.hasNext()) {
                ServiceBinding serviceBinding = i.next();
                String eprXML = serviceBinding.getAccessURI().trim();
                try {
                    EPR epr = EPRHelper.fromXMLString(eprXML);
                }
                catch (UnmarshalException unme) {
                    try {
                        eprXML = URLDecoder.decode(eprXML, "UTF-8").trim();
                    }
                    catch (UnsupportedEncodingException ue) {
                        logger.error((Object)unme.getMessage(), (Throwable)unme);
                        logger.error((Object)ue.getMessage(), (Throwable)ue);
                    }
                }
                String toBeDeletedEPRXml = EPRHelper.toXMLString(toBeDeletedEPR).trim();
                if (eprXML.equals(toBeDeletedEPRXml)) {
                    RegistryService rs = connection.getRegistryService();
                    BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
                    ArrayList<Key> serviceBindingKeys = new ArrayList<Key>();
                    serviceBindingKeys.add(serviceBinding.getKey());
                    blm.deleteServiceBindings(serviceBindingKeys);
                    return;
                }
            }
            throw new RegistryException("No such EPR found for service with name = " + serviceName + " and EPR=" + toBeDeletedEPR);
        }
        catch (JAXRException je) {
            throw new RegistryException(je.getLocalizedMessage(), je);
        }
        catch (MarshalException me) {
            throw new RegistryException(me.getLocalizedMessage(), me);
        }
        finally {
            this.jaxrConnectionFactory.closeConnection(connection);
        }
    }

    @Override
    public List<String> findAllServices() throws RegistryException {
        ArrayList<String> serviceNames = new ArrayList<String>();
        try {
            Collection services = this.getJBossESBOrganization().getServices();
            Iterator i = services.iterator();
            while (i.hasNext()) {
                String serviceName = ((Service)i.next()).getName().getValue();
                serviceNames.add(serviceName);
            }
        }
        catch (JAXRException je) {
            throw new RegistryException(je.getLocalizedMessage(), je);
        }
        return serviceNames;
    }

    @Override
    public List<String> findServices(String category) throws RegistryException {
        ArrayList<String> serviceNames = new ArrayList<String>();
        try {
            Collection<Service> services = this.findServicesForCategory(category);
            Iterator<Service> i = services.iterator();
            while (i.hasNext()) {
                String serviceName = i.next().getName().getValue();
                serviceNames.add(serviceName);
            }
        }
        catch (JAXRException je) {
            throw new RegistryException(je.getLocalizedMessage(), je);
        }
        return serviceNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<EPR> findEPRs(String category, String serviceName) throws RegistryException, ServiceNotFoundException {
        ArrayList<EPR> eprs = new ArrayList<EPR>();
        Connection connection = this.jaxrConnectionFactory.getConnection();
        try {
            Service service = this.findService(category, serviceName);
            if (service == null) {
                throw new ServiceNotFoundException("Could not find service with category=" + category + " and serviceName=" + serviceName);
            }
            Collection<ServiceBinding> serviceBindings = this.findServiceBindings(service);
            for (ServiceBinding serviceBinding : serviceBindings) {
                String eprXML = serviceBinding.getAccessURI();
                EPR epr = null;
                try {
                    epr = EPRHelper.fromXMLString(eprXML);
                    eprs.add(epr);
                }
                catch (UnmarshalException unme) {
                    try {
                        eprXML = URLDecoder.decode(eprXML, "UTF-8");
                        epr = EPRHelper.fromXMLString(eprXML);
                        eprs.add(epr);
                    }
                    catch (UnsupportedEncodingException ue) {
                        logger.error((Object)ue.getMessage(), (Throwable)ue);
                        throw new UnmarshalException(ue.getMessage(), ue);
                        return eprs;
                    }
                }
            }
        }
        catch (JAXRException je) {
            throw new RegistryException(je.getLocalizedMessage(), je);
        }
        catch (UnmarshalException me) {
            throw new RegistryException(me.getLocalizedMessage(), me);
        }
        finally {
            this.jaxrConnectionFactory.closeConnection(connection);
        }
    }

    @Override
    public EPR findEPR(String category, String serviceName) throws RegistryException, ServiceNotFoundException {
        EPR epr;
        block11: {
            epr = null;
            Connection connection = this.jaxrConnectionFactory.getConnection();
            try {
                Service service = this.findService(category, serviceName);
                if (service == null) {
                    throw new ServiceNotFoundException("Could not find service with category=" + category + " and serviceName=" + serviceName);
                }
                Collection<ServiceBinding> serviceBindings = this.findServiceBindings(service);
                if (!serviceBindings.iterator().hasNext()) break block11;
                ServiceBinding serviceBinding = serviceBindings.iterator().next();
                String eprXML = serviceBinding.getAccessURI();
                try {
                    epr = EPRHelper.fromXMLString(eprXML);
                }
                catch (UnmarshalException unme) {
                    try {
                        eprXML = URLDecoder.decode(eprXML, "UTF-8");
                        epr = EPRHelper.fromXMLString(eprXML);
                    }
                    catch (UnsupportedEncodingException ue) {
                        logger.error((Object)ue.getMessage(), (Throwable)ue);
                        throw new UnmarshalException(ue.getMessage(), ue);
                    }
                }
            }
            catch (JAXRException je) {
                throw new RegistryException(je.getLocalizedMessage(), je);
            }
            catch (UnmarshalException me) {
                throw new RegistryException(me.getLocalizedMessage(), me);
            }
            finally {
                this.jaxrConnectionFactory.closeConnection(connection);
            }
        }
        return epr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Organization findOrganization(String organizationName, JAXRConnectionFactory jaxrConnectionFactory) throws JAXRException {
        if (organizationName == null) {
            organizationName = "";
        }
        Connection connection = jaxrConnectionFactory.getConnection();
        try {
            Iterator orgIter;
            RegistryService rs = connection.getRegistryService();
            BusinessQueryManager bqm = rs.getBusinessQueryManager();
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("sortByNameAsc");
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add("%" + organizationName + "%");
            logger.log((Priority)Level.DEBUG, (Object)("Going to query the registry for name pattern " + namePatterns));
            BulkResponse response = bqm.findOrganizations(findQualifiers, namePatterns, null, null, null, null);
            if (response.getStatus() == 0 && (orgIter = response.getCollection().iterator()).hasNext()) {
                Organization org = (Organization)orgIter.next();
                logger.log((Priority)Level.DEBUG, (Object)("Organization name: " + org.getName().getValue()));
                logger.log((Priority)Level.DEBUG, (Object)("Description: " + org.getDescription().getValue()));
                logger.log((Priority)Level.DEBUG, (Object)("Key id: " + org.getKey().getId()));
                User primaryContact = org.getPrimaryContact();
                logger.log((Priority)Level.DEBUG, (Object)("Primary Contact: " + primaryContact.getPersonName().getFullName()));
                if (orgIter.hasNext()) {
                    logger.log((Priority)Level.ERROR, (Object)("Found " + response.getCollection().size() + " Organization, while expecting only one of name " + organizationName));
                }
                Organization organization = org;
                return organization;
            }
            Organization organization = null;
            return organization;
        }
        finally {
            jaxrConnectionFactory.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Service findService(String category, String serviceName) throws JAXRException {
        if (category == null) {
            category = "";
        }
        if (serviceName == null) {
            serviceName = "";
        }
        Connection connection = this.jaxrConnectionFactory.getConnection();
        try {
            Iterator servIter;
            RegistryService rs = connection.getRegistryService();
            BusinessQueryManager bqm = rs.getBusinessQueryManager();
            BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("andAllKeys");
            findQualifiers.add("exactNameMatch");
            findQualifiers.add("sortByNameDesc");
            ClassificationScheme cScheme = bqm.findClassificationSchemeByName(findQualifiers, "org.jboss.soa.esb.:category");
            ArrayList<Classification> classifications = new ArrayList<Classification>();
            Classification classification = blm.createClassification(cScheme, "category", category);
            classifications.add(classification);
            ArrayList<String> namePatterns = new ArrayList<String>();
            namePatterns.add(serviceName);
            logger.log((Priority)Level.DEBUG, (Object)("Going to query the registry for name pattern " + namePatterns));
            BulkResponse response = bqm.findServices(null, findQualifiers, namePatterns, classifications, null);
            if (response.getStatus() == 0 && (servIter = response.getCollection().iterator()).hasNext()) {
                Service service = (Service)servIter.next();
                logger.log((Priority)Level.DEBUG, (Object)("Service name: " + service.getName().getValue()));
                if (service.getDescription() != null) {
                    logger.log((Priority)Level.DEBUG, (Object)("Description: " + service.getDescription().getValue()));
                }
                logger.log((Priority)Level.DEBUG, (Object)("Key id: " + service.getKey().getId()));
                if (servIter.hasNext()) {
                    logger.log((Priority)Level.ERROR, (Object)("Found " + response.getCollection().size() + " Services, while expecting only one by the name of " + serviceName + " in category " + category));
                }
                Service service2 = service;
                return service2;
            }
            Service service = null;
            return service;
        }
        finally {
            this.jaxrConnectionFactory.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Service> findServicesForCategory(String category) throws JAXRException {
        Collection<Object> services = new ArrayList<Service>();
        if (category == null) {
            category = "";
        }
        Connection connection = this.jaxrConnectionFactory.getConnection();
        try {
            RegistryService rs = connection.getRegistryService();
            BusinessQueryManager bqm = rs.getBusinessQueryManager();
            BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
            ArrayList<String> findQualifiers = new ArrayList<String>();
            findQualifiers.add("andAllKeys");
            findQualifiers.add("sortByNameDesc");
            ClassificationScheme cScheme = bqm.findClassificationSchemeByName(findQualifiers, "org.jboss.soa.esb.:category");
            Classification classification = blm.createClassification(cScheme, "category", category);
            findQualifiers.add("sortByNameDesc");
            ArrayList<Classification> classifications = new ArrayList<Classification>();
            classifications.add(classification);
            logger.log((Priority)Level.DEBUG, (Object)("Going to query the registry for classification " + classifications));
            BulkResponse response = bqm.findServices(null, findQualifiers, null, classifications, null);
            if (response.getStatus() == 0) {
                services = response.getCollection();
            }
            ArrayList<Service> arrayList = services;
            return arrayList;
        }
        finally {
            this.jaxrConnectionFactory.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Organization createJBossESBOrganization(JAXRConnectionFactory jaxrConnectionFactory) throws JAXRException {
        Connection connection = jaxrConnectionFactory.getConnection();
        try {
            RegistryService rs = connection.getRegistryService();
            BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
            Organization organization = blm.createOrganization(blm.createInternationalString("Red Hat/JBossESB"));
            organization.setDescription(blm.createInternationalString("Red Hat/JBoss Professional Open Source, Services for the JBossESB"));
            User user = blm.createUser();
            organization.setPrimaryContact(user);
            PersonName personName = blm.createPersonName("JBossESB");
            TelephoneNumber telephoneNumber = blm.createTelephoneNumber();
            telephoneNumber.setNumber("404 467-8555");
            telephoneNumber.setType(null);
            PostalAddress address = blm.createPostalAddress("3340", "Peachtree Road, NE, Suite 1200", "Atlanta", "GA", "USA", "30326", "");
            ArrayList<PostalAddress> postalAddresses = new ArrayList<PostalAddress>();
            postalAddresses.add(address);
            ArrayList<EmailAddress> emailAddresses = new ArrayList<EmailAddress>();
            EmailAddress emailAddress = blm.createEmailAddress("jbossesb@jboss.com");
            emailAddresses.add(emailAddress);
            ArrayList<TelephoneNumber> numbers = new ArrayList<TelephoneNumber>();
            numbers.add(telephoneNumber);
            user.setPersonName(personName);
            user.setPostalAddresses(postalAddresses);
            user.setEmailAddresses(emailAddresses);
            user.setTelephoneNumbers(numbers);
            JAXRRegistryImpl.saveRegistryObject((RegistryObject)organization, jaxrConnectionFactory);
            Organization organization2 = organization;
            return organization2;
        }
        finally {
            jaxrConnectionFactory.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveRegistryObject(RegistryObject registryObject, JAXRConnectionFactory jaxrConnectionFactory) throws JAXRException {
        block14: {
            Connection connection = jaxrConnectionFactory.getConnection();
            try {
                BulkResponse br = null;
                RegistryService rs = connection.getRegistryService();
                BusinessLifeCycleManager blm = rs.getBusinessLifeCycleManager();
                Class<?>[] interfaces = registryObject.getClass().getInterfaces();
                String interfaceName = "";
                int i = 0;
                if (i < interfaces.length) {
                    interfaceName = interfaces[i].getName();
                    if (interfaceName.equals("javax.xml.registry.infomodel.Organization")) {
                        ArrayList<Organization> orginations = new ArrayList<Organization>();
                        orginations.add((Organization)registryObject);
                        br = blm.saveOrganizations(orginations);
                    } else if (interfaceName.equals("javax.xml.registry.infomodel.Service")) {
                        ArrayList<Service> services = new ArrayList<Service>();
                        services.add((Service)registryObject);
                        br = blm.saveServices(services);
                    } else if (interfaceName.equals("javax.xml.registry.infomodel.ServiceBinding")) {
                        ArrayList<ServiceBinding> serviceBindings = new ArrayList<ServiceBinding>();
                        serviceBindings.add((ServiceBinding)registryObject);
                        br = blm.saveServiceBindings(serviceBindings);
                    } else {
                        logger.log((Priority)Level.ERROR, (Object)"Trying to save an unsupported RegistryObject");
                        throw new JAXRException("Trying to save an unsupported RegistryObject");
                    }
                }
                if (br != null && br.getStatus() == 0) {
                    logger.log((Priority)Level.DEBUG, (Object)(interfaceName + " successfully saved"));
                    Collection coll = br.getCollection();
                    for (Key key : coll) {
                        registryObject.setKey(key);
                        logger.log((Priority)Level.DEBUG, (Object)("Saved Key=" + key.getId()));
                    }
                    break block14;
                }
                logger.log((Priority)Level.ERROR, (Object)"Errors occurred during save.");
                if (br != null) {
                    Collection exceptions = br.getExceptions();
                    Iterator iter = exceptions.iterator();
                    String errors = "";
                    JAXRException je = new JAXRException("JAXRExceptions occurred during save");
                    while (iter.hasNext()) {
                        Exception e = (Exception)iter.next();
                        errors = errors + e.getLocalizedMessage() + "\n";
                        je.setStackTrace(e.getStackTrace());
                        logger.log((Priority)Level.ERROR, (Object)e.getLocalizedMessage(), (Throwable)e);
                        if (iter.hasNext()) continue;
                        throw new JAXRException(errors, (Throwable)e);
                    }
                    throw new JAXRException("Errors occurred during save. Response status=" + br.getStatus());
                }
                throw new JAXRException("Errors occurred during save");
            }
            finally {
                jaxrConnectionFactory.closeConnection(connection);
            }
        }
    }

    private Organization getJBossESBOrganization() throws JAXRException {
        jbossESBOrganization = JAXRRegistryImpl.findOrganization("Red Hat/JBossESB", this.jaxrConnectionFactory);
        if (jbossESBOrganization == null) {
            jbossESBOrganization = JAXRRegistryImpl.createJBossESBOrganization(this.jaxrConnectionFactory);
        }
        return jbossESBOrganization;
    }

    private Collection<ServiceBinding> findServiceBindings(Service service) throws RegistryException {
        Collection<Object> serviceBindings = new ArrayList<ServiceBinding>();
        Connection connection = this.jaxrConnectionFactory.getConnection();
        try {
            RegistryService rs = connection.getRegistryService();
            BusinessQueryManager bqm = rs.getBusinessQueryManager();
            Collection findQualifiers = null;
            BulkResponse bulkResponse = bqm.findServiceBindings(service.getKey(), findQualifiers, null, null);
            if (bulkResponse.getStatus() == 0) {
                serviceBindings = bulkResponse.getCollection();
            }
            ArrayList<ServiceBinding> arrayList = serviceBindings;
            return arrayList;
        }
        catch (Exception je) {
            throw new RegistryException(je.getLocalizedMessage(), je);
        }
        finally {
            this.jaxrConnectionFactory.closeConnection(connection);
        }
    }
}

