/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.internal.soa.esb.couriers.InVMCourier;
import org.jboss.internal.soa.esb.services.registry.RegsitryEntry;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.services.registry.AbstractRegistryInterceptor;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InVMRegistryInterceptor
extends AbstractRegistryInterceptor {
    private Map<Service, List<RegsitryEntry>> regEntries = new ConcurrentHashMap<Service, List<RegsitryEntry>>();

    @Override
    public void registerEPR(String serviceCategoryName, String serviceName, String serviceDescription, EPR epr, String eprDescription) throws RegistryException {
        if (epr instanceof InVMEpr) {
            Service service = new Service(serviceCategoryName, serviceName);
            RegsitryEntry regEntry = new RegsitryEntry(service, serviceDescription, epr, eprDescription);
            List<RegsitryEntry> serviceEntries = this.getServiceEntries(service);
            serviceEntries.add(regEntry);
        } else {
            this.getRegistry().registerEPR(serviceCategoryName, serviceName, serviceDescription, epr, eprDescription);
        }
    }

    @Override
    public void unRegisterService(String category, String serviceName) throws RegistryException, ServiceNotFoundException {
        block2: {
            boolean entryRemoved = this.unRegisterInVMService(category, serviceName);
            try {
                this.getRegistry().unRegisterService(category, serviceName);
            }
            catch (ServiceNotFoundException snfe) {
                if (entryRemoved) break block2;
                throw snfe;
            }
        }
    }

    protected boolean unRegisterInVMService(String category, String serviceName) throws RegistryException, ServiceNotFoundException {
        if (this.isValidService(category, serviceName)) {
            this._unRegisterEPR(category, serviceName, null);
            return this.regEntries.remove(new Service(category, serviceName)) != null;
        }
        return false;
    }

    @Override
    public void unRegisterEPR(String serviceCategoryName, String serviceName, EPR epr) throws RegistryException, ServiceNotFoundException {
        if (epr instanceof InVMEpr) {
            this._unRegisterEPR(serviceCategoryName, serviceName, epr);
        } else {
            this.getRegistry().unRegisterEPR(serviceCategoryName, serviceName, epr);
        }
    }

    private void _unRegisterEPR(String serviceCategoryName, String serviceName, EPR epr) {
        Service service = new Service(serviceCategoryName, serviceName);
        List<RegsitryEntry> serviceEntries = this.getServiceEntries(service);
        Iterator<RegsitryEntry> iterator = serviceEntries.iterator();
        while (iterator.hasNext()) {
            InVMCourier courier;
            RegsitryEntry regsitryEntry = iterator.next();
            if (epr != null && !regsitryEntry.getEpr().getAddr().getAddress().equals(epr.getAddr().getAddress())) continue;
            if (regsitryEntry.getEpr() instanceof InVMEpr && (courier = CourierFactory.getInstance().getInVMCourier((InVMEpr)regsitryEntry.getEpr())) != null) {
                courier.setActive(false);
            }
            iterator.remove();
        }
    }

    @Override
    public List<String> findAllServices() throws RegistryException {
        List<String> services = this.findInVMServices(null);
        services.addAll(this.getRegistry().findAllServices());
        return services;
    }

    @Override
    public List<String> findServices(String serviceCategoryName) throws RegistryException {
        List<String> services = this.findInVMServices(serviceCategoryName);
        services.addAll(this.getRegistry().findServices(serviceCategoryName));
        return services;
    }

    private List<String> findInVMServices(String serviceCategoryName) throws RegistryException {
        Iterator<Service> iterator = this.regEntries.keySet().iterator();
        ArrayList<String> services = new ArrayList<String>();
        while (iterator.hasNext()) {
            Service service = iterator.next();
            if (serviceCategoryName != null && !service.getCategory().equals(serviceCategoryName)) continue;
            services.add(service.getName());
        }
        return services;
    }

    @Override
    public List<EPR> findEPRs(String serviceCategoryName, String serviceName) throws RegistryException, ServiceNotFoundException {
        List<EPR> eprs = this.findInVMEPRs(serviceCategoryName, serviceName);
        if (eprs.size() == 0) {
            return this.getRegistry().findEPRs(serviceCategoryName, serviceName);
        }
        try {
            eprs.addAll(this.getRegistry().findEPRs(serviceCategoryName, serviceName));
        }
        catch (ServiceNotFoundException snfe) {
            // empty catch block
        }
        return eprs;
    }

    @Override
    public EPR findEPR(String serviceCategoryName, String serviceName) throws RegistryException, ServiceNotFoundException {
        List<EPR> eprs = this.findInVMEPRs(serviceCategoryName, serviceName);
        if (!eprs.isEmpty()) {
            return eprs.get(0);
        }
        return this.getRegistry().findEPR(serviceCategoryName, serviceName);
    }

    private List<EPR> findInVMEPRs(String serviceCategoryName, String serviceName) throws RegistryException, ServiceNotFoundException {
        ArrayList<EPR> eprs = new ArrayList<EPR>();
        if (this.isValidService(serviceCategoryName, serviceName)) {
            Service service = new Service(serviceCategoryName, serviceName);
            List<RegsitryEntry> serviceEntries = this.getServiceEntries(service);
            for (RegsitryEntry serviceEntry : serviceEntries) {
                eprs.add(serviceEntry.getEpr());
            }
        }
        return eprs;
    }

    private synchronized List<RegsitryEntry> getServiceEntries(Service service) {
        List<Object> serviceEntries = null;
        Set<Map.Entry<Service, List<RegsitryEntry>>> entries = this.regEntries.entrySet();
        for (Map.Entry<Service, List<RegsitryEntry>> entry : entries) {
            if (!entry.getKey().equals(service)) continue;
            serviceEntries = entry.getValue();
            break;
        }
        if (serviceEntries == null) {
            serviceEntries = new ArrayList();
            this.regEntries.put(service, serviceEntries);
        }
        return serviceEntries;
    }

    private boolean isValidService(String category, String name) {
        return category != null && category.length() > 0 && name != null && name.length() > 0;
    }
}

