/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.registry.AbstractRegistryInterceptor;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingRegistryInterceptor
extends AbstractRegistryInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CachingRegistryInterceptor.class);
    private static final int DEFAULT_MAX_CACHE_SIZE = 100;
    private static final long DEFAULT_VALIDITY_PERIOD = 600000L;
    private static final int MAX_CACHE_SIZE;
    private static final long VALIDITY_PERIOD;
    private final LRUMap serviceInfoMap = new LRUMap(MAX_CACHE_SIZE);

    @Override
    public List<String> findAllServices() throws RegistryException {
        return this.getRegistry().findAllServices();
    }

    @Override
    public List<String> findServices(String category) throws RegistryException {
        return this.getRegistry().findServices(category);
    }

    @Override
    public EPR findEPR(String category, String name) throws RegistryException, ServiceNotFoundException {
        List<EPR> eprs = this.findEPRs(category, name);
        return eprs.get(0);
    }

    @Override
    public List<EPR> findEPRs(String category, String name) throws RegistryException, ServiceNotFoundException {
        Service service = new Service(category, name);
        return Collections.unmodifiableList(this.getEPRs(service));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEPR(String category, String name, String serviceDescription, EPR epr, String eprDescription) throws RegistryException {
        Service service = new Service(category, name);
        CachingRegistryInterceptor cachingRegistryInterceptor = this;
        synchronized (cachingRegistryInterceptor) {
            this.getRegistry().registerEPR(category, name, serviceDescription, epr, eprDescription);
            List<EPR> eprs = this.getCurrentEPRs(service);
            if (eprs != null) {
                eprs.add(epr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterEPR(String category, String name, EPR epr) throws RegistryException, ServiceNotFoundException {
        Service service = new Service(category, name);
        CachingRegistryInterceptor cachingRegistryInterceptor = this;
        synchronized (cachingRegistryInterceptor) {
            List<EPR> eprs = this.getCurrentEPRs(service);
            if (eprs != null && eprs.remove(epr) && eprs.size() == 0) {
                this.serviceInfoMap.remove((Object)service);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.debug((Object)("Cache removing service " + service));
                }
            }
            this.getRegistry().unRegisterEPR(category, name, epr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterService(String category, String name) throws RegistryException, ServiceNotFoundException {
        Service service = new Service(category, name);
        CachingRegistryInterceptor cachingRegistryInterceptor = this;
        synchronized (cachingRegistryInterceptor) {
            this.serviceInfoMap.remove((Object)service);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.debug((Object)("Cache removing service " + service));
            }
            this.getRegistry().unRegisterService(category, name);
        }
    }

    private synchronized List<EPR> getEPRs(Service service) throws RegistryException, ServiceNotFoundException {
        List<EPR> eprs = this.getCurrentEPRs(service);
        if (eprs != null) {
            return eprs;
        }
        List<EPR> currentEPRs = this.getRegistry().findEPRs(service.getCategory(), service.getName());
        ArrayList<EPR> copyEPRs = new ArrayList<EPR>(currentEPRs);
        ServiceInfo serviceInfo = new ServiceInfo(copyEPRs);
        this.serviceInfoMap.put((Object)service, (Object)serviceInfo);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.debug((Object)("Cache reloaded for service " + service));
        }
        return copyEPRs;
    }

    private synchronized List<EPR> getCurrentEPRs(Service service) {
        ServiceInfo serviceInfo = (ServiceInfo)this.serviceInfoMap.get((Object)service);
        if (serviceInfo != null) {
            boolean infoEnabled = LOGGER.isInfoEnabled();
            if (serviceInfo.isValid()) {
                if (infoEnabled) {
                    LOGGER.debug((Object)("Cache hit for service " + service));
                }
                return serviceInfo.getEPRs();
            }
            if (infoEnabled) {
                LOGGER.debug((Object)("Cache expiry for service " + service));
            }
            this.serviceInfoMap.remove((Object)service);
        }
        return null;
    }

    static {
        String maxCacheSizeVal = Configuration.getRegistryCacheMaxSize();
        int maxCacheSize = 100;
        if (maxCacheSizeVal != null) {
            try {
                maxCacheSize = Integer.parseInt(maxCacheSizeVal);
            }
            catch (NumberFormatException nfe) {
                LOGGER.warn((Object)"Failed to parse maximum cache size, falling back to default", (Throwable)nfe);
            }
        }
        String validityPeriodVal = Configuration.getRegistryCacheValidityPeriod();
        long validityPeriod = 600000L;
        if (validityPeriodVal != null) {
            try {
                validityPeriod = Long.parseLong(validityPeriodVal);
            }
            catch (NumberFormatException nfe) {
                LOGGER.warn((Object)"Failed to parse validity period, falling back to default", (Throwable)nfe);
            }
        }
        VALIDITY_PERIOD = validityPeriod;
        MAX_CACHE_SIZE = maxCacheSize;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Registry cache validity period: " + VALIDITY_PERIOD));
            LOGGER.debug((Object)("Registry cache maximum size: " + MAX_CACHE_SIZE));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceInfo {
        private final long expiryTime;
        private List<EPR> eprs;

        private ServiceInfo(List<EPR> eprs) {
            this.eprs = eprs;
            this.expiryTime = VALIDITY_PERIOD > 0L ? System.currentTimeMillis() + VALIDITY_PERIOD : Long.MAX_VALUE;
        }

        boolean isValid() {
            return System.currentTimeMillis() < this.expiryTime;
        }

        List<EPR> getEPRs() {
            return this.eprs;
        }
    }
}

