/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import java.io.Serializable;
import java.util.HashSet;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.internal.soa.esb.rosetta.pooling.SessionExecutorInit;

public class JmsSession
implements Session {
    private final Session session;
    private final long id;
    private HashSet<QueueBrowser> queueBrowserSet;
    private HashSet<MessageConsumer> messageConsumerSet;
    private HashSet<MessageProducer> messageProducerSet;

    JmsSession(Session session, long id) throws JMSException {
        this.id = id;
        this.session = session;
        if ("org.jboss.jms.client.JBossSession".equals(session.getClass().getName())) {
            SessionExecutorInit.initExecutor(session);
        }
    }

    public long getId() {
        return this.id;
    }

    public void close() throws JMSException {
        this.session.close();
    }

    public void commit() throws JMSException {
        this.session.commit();
    }

    public QueueBrowser createBrowser(Queue arg0, String arg1) throws JMSException {
        return this.trackQueueBrowser(this.session.createBrowser(arg0, arg1));
    }

    public QueueBrowser createBrowser(Queue arg0) throws JMSException {
        return this.trackQueueBrowser(this.session.createBrowser(arg0));
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.associate();
        return this.session.createBytesMessage();
    }

    public MessageConsumer createConsumer(Destination arg0, String arg1, boolean arg2) throws JMSException {
        return this.trackMessageConsumer(this.session.createConsumer(arg0, arg1, arg2));
    }

    public MessageConsumer createConsumer(Destination arg0, String arg1) throws JMSException {
        return this.trackMessageConsumer(this.session.createConsumer(arg0, arg1));
    }

    public MessageConsumer createConsumer(Destination arg0) throws JMSException {
        return this.trackMessageConsumer(this.session.createConsumer(arg0));
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1, String arg2, boolean arg3) throws JMSException {
        return this.trackTopicSubscriber(this.session.createDurableSubscriber(arg0, arg1, arg2, arg3));
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1) throws JMSException {
        return this.trackTopicSubscriber(this.session.createDurableSubscriber(arg0, arg1));
    }

    public MapMessage createMapMessage() throws JMSException {
        this.associate();
        return this.session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        this.associate();
        return this.session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.associate();
        return this.session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable arg0) throws JMSException {
        this.associate();
        return this.session.createObjectMessage(arg0);
    }

    public MessageProducer createProducer(Destination arg0) throws JMSException {
        return this.trackMessageProducer(this.session.createProducer(arg0));
    }

    public Queue createQueue(String arg0) throws JMSException {
        this.associate();
        return this.session.createQueue(arg0);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.associate();
        return this.session.createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.associate();
        return this.session.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.associate();
        return this.session.createTemporaryTopic();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.associate();
        return this.session.createTextMessage();
    }

    public TextMessage createTextMessage(String arg0) throws JMSException {
        this.associate();
        return this.session.createTextMessage(arg0);
    }

    public Topic createTopic(String arg0) throws JMSException {
        this.associate();
        return this.session.createTopic(arg0);
    }

    public int getAcknowledgeMode() throws JMSException {
        this.associate();
        return this.session.getAcknowledgeMode();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.associate();
        return this.session.getMessageListener();
    }

    public boolean getTransacted() throws JMSException {
        this.associate();
        return this.session.getTransacted();
    }

    public void recover() throws JMSException {
        this.associate();
        this.session.recover();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public void run() {
        this.session.run();
    }

    public void setMessageListener(MessageListener arg0) throws JMSException {
        this.associate();
        this.session.setMessageListener(arg0);
    }

    public void unsubscribe(String arg0) throws JMSException {
        this.associate();
        this.session.unsubscribe(arg0);
    }

    private synchronized QueueBrowser trackQueueBrowser(QueueBrowser queueBrowser) throws JMSException {
        this.associate();
        if (this.queueBrowserSet == null) {
            this.queueBrowserSet = new HashSet();
        }
        QueueBrowser result = this.getQueueBrowser(queueBrowser);
        this.queueBrowserSet.add(result);
        return result;
    }

    private synchronized MessageConsumer trackMessageConsumer(MessageConsumer messageConsumer) throws JMSException {
        this.associate();
        if (this.messageConsumerSet == null) {
            this.messageConsumerSet = new HashSet();
        }
        MessageConsumer result = this.getMessageConsumer(messageConsumer);
        this.messageConsumerSet.add(result);
        return result;
    }

    private synchronized TopicSubscriber trackTopicSubscriber(TopicSubscriber topicSubscriber) throws JMSException {
        this.associate();
        if (this.messageConsumerSet == null) {
            this.messageConsumerSet = new HashSet();
        }
        TopicSubscriber result = this.getTopicSubscriber(topicSubscriber);
        this.messageConsumerSet.add((MessageConsumer)result);
        return result;
    }

    private synchronized MessageProducer trackMessageProducer(MessageProducer messageProducer) throws JMSException {
        this.associate();
        if (this.messageProducerSet == null) {
            this.messageProducerSet = new HashSet();
        }
        MessageProducer result = this.getMessageProducer(messageProducer);
        this.messageProducerSet.add(result);
        return result;
    }

    synchronized void releaseResources() {
        if (this.queueBrowserSet != null) {
            for (QueueBrowser queueBrowser : this.queueBrowserSet) {
                try {
                    queueBrowser.close();
                }
                catch (JMSException jmse) {}
            }
            this.queueBrowserSet = null;
        }
        if (this.messageConsumerSet != null) {
            for (MessageConsumer messageConsumer : this.messageConsumerSet) {
                try {
                    messageConsumer.close();
                }
                catch (JMSException jmse) {}
            }
            this.messageConsumerSet = null;
        }
        if (this.messageProducerSet != null) {
            for (MessageProducer messageProducer : this.messageProducerSet) {
                try {
                    messageProducer.close();
                }
                catch (JMSException jMSException) {}
            }
            this.messageProducerSet = null;
        }
        try {
            this.recover();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected QueueBrowser getQueueBrowser(QueueBrowser queueBrowser) {
        return queueBrowser;
    }

    protected MessageConsumer getMessageConsumer(MessageConsumer messageConsumer) {
        return messageConsumer;
    }

    protected TopicSubscriber getTopicSubscriber(TopicSubscriber topicSubscriber) {
        return topicSubscriber;
    }

    protected MessageProducer getMessageProducer(MessageProducer messageProducer) {
        return messageProducer;
    }

    protected void handleCloseSession(JmsConnectionPool jmsConnectionPool) {
        jmsConnectionPool.handleCloseSession(this);
    }

    protected void handleReleaseSession(JmsConnectionPool jmsConnectionPool) {
        jmsConnectionPool.handleReleaseSession(this);
    }

    protected void associate() throws JMSException {
    }
}

