/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.lifecycle.LifecycleResource;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsConnectionPoolContainer {
    protected static Logger logger = Logger.getLogger(JmsConnectionPoolContainer.class);
    private static final LifecycleResourceFactory<Map<Map<String, String>, JmsConnectionPool>> lifecycleJMSPoolFactory = new JmsConnectionPoolFactory();
    private static final LifecycleResource<Map<Map<String, String>, JmsConnectionPool>> lifecycleJMSPoolResource = new LifecycleResource<Map<Map<String, String>, JmsConnectionPool>>(lifecycleJMSPoolFactory, 200000);
    protected static final HashMap<Object, JmsConnectionPool> transactions = new HashMap();

    public static JmsConnectionPool getPool(JMSEpr jmsEpr) throws ConnectionException, URISyntaxException {
        return JmsConnectionPoolContainer.getPool(jmsEpr.getJndiEnvironment(), jmsEpr.getConnectionFactory(), jmsEpr.getJMSSecurityPrincipal(), jmsEpr.getJMSSecurityCredential());
    }

    public static JmsConnectionPool getPool(Properties enviroment, String connectionFactory) throws ConnectionException {
        return JmsConnectionPoolContainer.getPool(enviroment, connectionFactory, null, null);
    }

    public static JmsConnectionPool getPool(Properties enviroment, String connectionFactory, String username, String password) throws ConnectionException {
        Map<String, String> poolKey = JmsConnectionPoolContainer.createPoolKey(enviroment, connectionFactory, username, password);
        Map<Map<String, String>, JmsConnectionPool> poolMap = JmsConnectionPoolContainer.getMap();
        if (poolMap.containsKey(poolKey)) {
            return poolMap.get(poolKey);
        }
        JmsConnectionPool pool = new JmsConnectionPool(poolKey);
        poolMap.put(poolKey, pool);
        return pool;
    }

    public static Map<String, String> createPoolKey(Properties environment, String connectionFactory) {
        return JmsConnectionPoolContainer.createPoolKey(environment, connectionFactory, null, null);
    }

    public static Map<String, String> createPoolKey(Properties environment, String connectionFactory, String username, String password) {
        HashMap<String, String> poolKey = new HashMap<String, String>();
        if (environment != null) {
            for (Object key : environment.keySet()) {
                poolKey.put(key.toString(), environment.getProperty(key.toString()));
            }
        }
        if (username != null && !username.equals("null") && password != null && !password.equals("null")) {
            poolKey.put("jms-security-principal", username);
            poolKey.put("jms-security-credential", password);
        }
        if (connectionFactory != null) {
            poolKey.put("connection-factory", connectionFactory);
        }
        return poolKey;
    }

    static Properties getJndiEnvironment(Map<String, String> poolKey) {
        Properties environment = new Properties();
        String[] jndiPrefixes = JMSEpr.getJndiPrefixes(environment.getProperty("jndi-prefixes"));
        block0: for (String key : poolKey.keySet()) {
            for (String jndiPrefix : jndiPrefixes) {
                if (!key.startsWith(jndiPrefix)) continue;
                environment.setProperty(key, poolKey.get(key));
                continue block0;
            }
        }
        return environment;
    }

    public static int getNumberOfPools() {
        try {
            return lifecycleJMSPoolResource.getLifecycleResource().size();
        }
        catch (LifecycleResourceException lre) {
            return 0;
        }
    }

    protected static void removePool(Map<String, String> poolKey) {
        block2: {
            try {
                Map<Map<String, String>, JmsConnectionPool> poolMap = lifecycleJMSPoolResource.getLifecycleResource();
                poolMap.remove(poolKey);
            }
            catch (LifecycleResourceException lre) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)"Unexpected lifecycle resource exception removing pool", (Throwable)lre);
            }
        }
    }

    protected static void addToPool(Map<String, String> poolKey, JmsConnectionPool pool) throws ConnectionException {
        Map<Map<String, String>, JmsConnectionPool> poolMap = JmsConnectionPoolContainer.getMap();
        if (!poolMap.containsKey(poolKey)) {
            poolMap.put(poolKey, pool);
        }
    }

    private static Map<Map<String, String>, JmsConnectionPool> getMap() throws ConnectionException {
        try {
            return lifecycleJMSPoolResource.getLifecycleResource();
        }
        catch (LifecycleResourceException lre) {
            throw new ConnectionException("Unexpected lifecycle resource exception", lre);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JmsConnectionPoolFactory
    implements LifecycleResourceFactory<Map<Map<String, String>, JmsConnectionPool>> {
        private JmsConnectionPoolFactory() {
        }

        @Override
        public Map<Map<String, String>, JmsConnectionPool> createLifecycleResource(String lifecycleIdentity) throws LifecycleResourceException {
            return new ConcurrentHashMap<Map<String, String>, JmsConnectionPool>();
        }

        @Override
        public void destroyLifecycleResource(Map<Map<String, String>, JmsConnectionPool> resource, String lifecycleIdentity) throws LifecycleResourceException {
            for (JmsConnectionPool pool : resource.values()) {
                pool.removeSessionPool();
            }
        }
    }
}

