/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPoolContainer;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsSession;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsXASession;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsConnectionPool {
    private static final int DEFAULT_POOL_SIZE = 20;
    private static final int DEFAULT_SLEEP = 30;
    private static int CONFIGURED_POOL_SIZE = 20;
    private static int CONFIGURED_SLEEP = 30;
    private static final Executor SESSION_EXECUTOR = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
    private static final CompletionService<JmsSession> COMPLETION_SERVICE = new ExecutorCompletionService<JmsSession>(SESSION_EXECUTOR);
    private int MAX_SESSIONS = 20;
    private int SLEEP_TIME = 30;
    private Map<Integer, ArrayList<JmsSession>> freeSessionsMap = new HashMap<Integer, ArrayList<JmsSession>>();
    private Map<Integer, ArrayList<JmsSession>> inUseSessionsMap = new HashMap<Integer, ArrayList<JmsSession>>();
    protected Connection jmsConnection;
    private Map<String, String> poolKey;
    private Map<Object, JmsXASession> transactionsToSessions = new HashMap<Object, JmsXASession>();
    private Map<JmsXASession, Object> sessionsToTransactions = new HashMap<JmsXASession, Object>();
    private Logger logger = Logger.getLogger(this.getClass());
    private boolean isXAAware;
    private boolean terminated;
    private long id;

    public JmsConnectionPool(Map<String, String> poolKey) {
        this(poolKey, CONFIGURED_POOL_SIZE, CONFIGURED_SLEEP);
    }

    public JmsConnectionPool(Map<String, String> poolKey, int poolSize, int sleepTime) {
        this.poolKey = poolKey;
        this.MAX_SESSIONS = poolSize;
        this.SLEEP_TIME = sleepTime;
        this.freeSessionsMap.put(1, new ArrayList());
        this.freeSessionsMap.put(2, new ArrayList());
        this.freeSessionsMap.put(3, new ArrayList());
        this.inUseSessionsMap.put(1, new ArrayList());
        this.inUseSessionsMap.put(2, new ArrayList());
        this.inUseSessionsMap.put(3, new ArrayList());
    }

    private synchronized void addAnotherSession(Map<String, String> poolKey, final boolean transacted, final int acknowledgeMode) throws JMSException {
        block5: {
            Future<JmsSession> future = COMPLETION_SERVICE.submit(new Callable<JmsSession>(){

                @Override
                public JmsSession call() throws JMSException {
                    JmsSession session = transacted ? new JmsXASession(JmsConnectionPool.this, ((XAConnection)JmsConnectionPool.this.jmsConnection).createXASession(), JmsConnectionPool.this.id) : new JmsSession(JmsConnectionPool.this.jmsConnection.createSession(transacted, acknowledgeMode), JmsConnectionPool.this.id);
                    return session;
                }
            });
            ArrayList<JmsSession> freeSessions = this.freeSessionsMap.get(acknowledgeMode);
            try {
                freeSessions.add(future.get());
            }
            catch (InterruptedException ie) {
            }
            catch (ExecutionException ee) {
                Throwable th = ee.getCause();
                if (th instanceof JMSException) {
                    throw (JMSException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (!(th instanceof RuntimeException)) break block5;
                throw (RuntimeException)th;
            }
        }
        this.logger.debug((Object)("Number of Sessions in the pool with acknowledgeMode: " + acknowledgeMode + " is now " + this.getSessionsInPool(acknowledgeMode)));
    }

    public synchronized JmsSession getSession(int acknowledgeMode) throws NamingException, JMSException, ConnectionException {
        JmsXASession currentSession;
        boolean transacted;
        try {
            this.initConnection();
        }
        catch (NamingContextException nce) {
            throw new ConnectionException("Unexpected exception accessing Naming Context", nce);
        }
        try {
            transacted = this.isXAAware && TransactionStrategy.getTransactionStrategy(true).isActive();
        }
        catch (TransactionStrategyException tse) {
            throw new ConnectionException("Failed to determine current transaction context", tse);
        }
        if (transacted && (currentSession = this.getXASession()) != null) {
            return currentSession;
        }
        int mode = transacted ? 0 : acknowledgeMode;
        long end = System.currentTimeMillis() + (long)(this.SLEEP_TIME * 1000);
        boolean emitExpiry = this.logger.isDebugEnabled();
        while (true) {
            long now;
            long delay;
            ArrayList<JmsSession> freeSessions = this.freeSessionsMap.get(mode);
            ArrayList<JmsSession> inUseSessions = this.inUseSessionsMap.get(mode);
            if (freeSessions.size() > 0) {
                JmsSession session = freeSessions.remove(freeSessions.size() - 1);
                inUseSessions.add(session);
                return session;
            }
            if (inUseSessions.size() < this.MAX_SESSIONS) {
                this.addAnotherSession(this.poolKey, transacted, mode);
                continue;
            }
            if (emitExpiry) {
                this.logger.debug((Object)"The connection pool was exhausted, waiting for a session to be released.");
                emitExpiry = false;
            }
            if ((delay = end - (now = System.currentTimeMillis())) <= 0L) {
                throw new ConnectionException("Could not obtain a JMS connection from the pool after " + this.SLEEP_TIME + "s.");
            }
            try {
                this.wait(delay);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    public JmsSession getSession() throws NamingException, JMSException, ConnectionException {
        return this.getSession(1);
    }

    public void closeSession(Session session) {
        if (session instanceof JmsSession) {
            this.closeSession((JmsSession)session);
        } else {
            this.logger.error((Object)("Invalid JMS Session type in closeSession: " + session));
        }
    }

    public void closeSession(JmsSession session) {
        session.handleCloseSession(this);
    }

    synchronized void handleCloseSession(JmsSession session) {
        if (session.getId() == this.id) {
            ArrayList<JmsSession> sessions;
            int mode;
            try {
                mode = session.getAcknowledgeMode();
            }
            catch (JMSException jmse) {
                this.logger.warn((Object)"JMSException while calling getAcknowledgeMode");
                this.logger.debug((Object)"JMSException while calling getAcknowledgeMode", (Throwable)jmse);
                return;
            }
            ArrayList<JmsSession> arrayList = sessions = this.freeSessionsMap == null ? null : this.freeSessionsMap.get(mode);
            if (sessions != null) {
                sessions.add(session);
            }
        }
        this.handleReleaseSession(session);
    }

    synchronized void handleReleaseSession(JmsSession session) {
        ArrayList<JmsSession> sessions;
        int mode;
        session.releaseResources();
        try {
            mode = session.getAcknowledgeMode();
        }
        catch (JMSException jmse) {
            this.logger.warn((Object)"JMSException while calling getAcknowledgeMode");
            this.logger.debug((Object)"JMSException while calling getAcknowledgeMode", (Throwable)jmse);
            return;
        }
        ArrayList<JmsSession> arrayList = sessions = this.inUseSessionsMap == null ? null : this.inUseSessionsMap.get(mode);
        if (sessions != null) {
            sessions.remove(session);
        }
        this.notifyAll();
    }

    public synchronized void releaseSession(JmsSession session) {
        session.handleReleaseSession(this);
    }

    public synchronized void releaseSession(Session session) {
        if (session instanceof JmsSession) {
            this.releaseSession((JmsSession)session);
        } else {
            this.logger.error((Object)("Invalid JMS Session type in releaseSession: " + session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanSessionPool() {
        Connection connection;
        JmsConnectionPool jmsConnectionPool = this;
        synchronized (jmsConnectionPool) {
            if (this.terminated) {
                return;
            }
            ++this.id;
            for (ArrayList<JmsSession> list : this.freeSessionsMap.values()) {
                list.clear();
            }
            for (ArrayList<JmsSession> list : this.inUseSessionsMap.values()) {
                list.clear();
            }
            this.transactionsToSessions.clear();
            this.sessionsToTransactions.clear();
            this.logger.debug((Object)"Cleared the session pool now closing the connection to the factory.");
            connection = this.jmsConnection;
            this.jmsConnection = null;
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void removeSessionPool() {
        this.freeSessionsMap = null;
        this.inUseSessionsMap = null;
        this.transactionsToSessions = null;
        this.sessionsToTransactions = null;
        this.logger.debug((Object)"Emptied the session pool now closing the connection to the factory.");
        if (this.jmsConnection != null) {
            try {
                this.jmsConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jmsConnection = null;
            this.terminated = true;
        }
        JmsConnectionPoolContainer.removePool(this.poolKey);
    }

    public int getSessionsInPool() {
        return this.getSessionsInPool(1) + this.getSessionsInPool(2) + this.getSessionsInPool(3) + this.getSessionsInPool(0);
    }

    public synchronized int getSessionsInPool(int acknowledgeMode) {
        return this.getFreeSessionsInPool(acknowledgeMode) + this.getInUseSessionsInPool(acknowledgeMode);
    }

    public synchronized int getFreeSessionsInPool(int acknowledgeMode) {
        ArrayList<JmsSession> freeSessionMap = this.freeSessionsMap == null ? null : this.freeSessionsMap.get(acknowledgeMode);
        int numFreeSessions = freeSessionMap == null ? 0 : freeSessionMap.size();
        return numFreeSessions;
    }

    public synchronized int getInUseSessionsInPool(int acknowledgeMode) {
        ArrayList<JmsSession> inUseSessionMap = this.inUseSessionsMap == null ? null : this.inUseSessionsMap.get(acknowledgeMode);
        int numInUseSessions = inUseSessionMap == null ? 0 : inUseSessionMap.size();
        return numInUseSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initConnection() throws ConnectionException, NamingContextException, NamingException, JMSException {
        if (this.terminated) {
            throw new ConnectionException("Connection pool has been terminated");
        }
        if (this.jmsConnection == null) {
            JmsConnectionPoolContainer.addToPool(this.poolKey, this);
            this.logger.debug((Object)("Creating a JMS Connection for poolKey : " + this.poolKey));
            Properties jndiEnvironment = JmsConnectionPoolContainer.getJndiEnvironment(this.poolKey);
            Context jndiContext = NamingContextPool.getNamingContext(jndiEnvironment);
            try {
                String connectionFactoryString = this.poolKey.get("connection-factory");
                Object factoryConnection = null;
                try {
                    factoryConnection = jndiContext.lookup(connectionFactoryString);
                }
                catch (NamingException ne) {
                    this.logger.info((Object)"Received NamingException, refreshing context.");
                    jndiContext = NamingContextPool.replaceNamingContext(jndiContext, JmsConnectionPoolContainer.getJndiEnvironment(this.poolKey));
                    factoryConnection = jndiContext.lookup(connectionFactoryString);
                }
                String username = this.poolKey.get("jms-security-principal");
                String password = this.poolKey.get("jms-security-credential");
                boolean useJMSSecurity = username != null && password != null;
                this.logger.debug((Object)("JMS Security principal [" + username + "] using JMS Security : " + useJMSSecurity));
                if (factoryConnection instanceof XAConnectionFactory) {
                    XAConnectionFactory factory = (XAConnectionFactory)factoryConnection;
                    this.jmsConnection = useJMSSecurity ? factory.createXAConnection(username, password) : factory.createXAConnection();
                    this.isXAAware = true;
                    this.freeSessionsMap.put(0, new ArrayList());
                    this.inUseSessionsMap.put(0, new ArrayList());
                } else if (factoryConnection instanceof ConnectionFactory) {
                    ConnectionFactory factory = (ConnectionFactory)factoryConnection;
                    this.jmsConnection = useJMSSecurity ? factory.createConnection(username, password) : factory.createConnection();
                }
                this.jmsConnection.setExceptionListener(new ExceptionListener(){

                    public void onException(JMSException arg0) {
                        JmsConnectionPool.this.cleanSessionPool();
                    }
                });
                this.jmsConnection.start();
            }
            finally {
                NamingContextPool.releaseNamingContext(jndiContext);
            }
        }
    }

    private Object getTransaction() throws ConnectionException {
        try {
            return TransactionStrategy.getTransactionStrategy(true).getTransaction();
        }
        catch (TransactionStrategyException tse) {
            throw new ConnectionException("Failed to determine current transaction context", tse);
        }
    }

    private synchronized JmsXASession getXASession() throws ConnectionException {
        Object tx = this.getTransaction();
        return this.transactionsToSessions.get(tx);
    }

    synchronized void associateTransaction(JmsXASession session) throws ConnectionException {
        Object tx = this.getTransaction();
        if (tx == null) {
            throw new ConnectionException("No active transaction");
        }
        this.transactionsToSessions.put(tx, session);
        this.sessionsToTransactions.put(session, tx);
    }

    synchronized void disassociateTransaction(JmsXASession session) {
        Object tx = this.sessionsToTransactions.remove(session);
        this.transactionsToSessions.remove(tx);
    }

    static {
        PropertyManager prop = ModulePropertyManager.getPropertyManager("transports");
        String value = prop.getProperty("org.jboss.soa.esb.jms.connectionPool");
        if (value != null) {
            try {
                CONFIGURED_POOL_SIZE = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        if ((value = prop.getProperty("org.jboss.soa.esb.jms.sessionSleep")) != null) {
            try {
                CONFIGURED_SLEEP = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = this.defaultFactory.newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

