/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.parameters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.parameters.ParamRepository;
import org.jboss.soa.esb.parameters.ParamRepositoryException;

public class ParamFileRepository
implements ParamRepository {
    public static final String FILE_PARAMS_REPOS_ROOT = "org.jboss.soa.esb.paramsRepository.file.root";
    private File root;
    private Logger logger = Logger.getLogger(ParamFileRepository.class);

    public ParamFileRepository() {
        String rootDir = ModulePropertyManager.getPropertyManager("core").getProperty(FILE_PARAMS_REPOS_ROOT);
        if (rootDir == null) {
            this.root = new File("./");
        } else {
            this.root = new File(rootDir);
            if (!this.root.exists()) {
                throw new IllegalStateException("Nonexistant directory specified in the [org.jboss.soa.esb.paramsRepository.file.root] System property: " + this.root.getAbsolutePath());
            }
        }
        this.logger.info((Object)("Setting parameter repository root dir to [" + this.root.getAbsolutePath() + "]."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name, String value) throws ParamRepositoryException {
        FileParamName nameParam = this.asserNameOK(name);
        if (value == null) {
            throw new IllegalArgumentException("null 'value' arg in method call.");
        }
        ParamFileRepository paramFileRepository = this;
        synchronized (paramFileRepository) {
            File paramFile = this.toParamFile(nameParam);
            File parentDir = paramFile.getParentFile();
            if (null == parentDir) {
                parentDir = new File("");
            }
            parentDir.mkdirs();
            FileOutputStream fileStream = null;
            try {
                fileStream = new FileOutputStream(paramFile);
                fileStream.write(value.getBytes("UTF-8"));
            }
            catch (IOException e) {
                throw new ParamRepositoryException("IO Error while storing param [" + nameParam + "].", e);
            }
            finally {
                try {
                    if (fileStream != null) {
                        fileStream.flush();
                        fileStream.close();
                    }
                }
                catch (IOException e) {
                    this.logger.warn((Object)("Unable to close param file: " + paramFile.getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(String name) throws ParamRepositoryException {
        FileParamName paramName = this.asserNameOK(name);
        ParamFileRepository paramFileRepository = this;
        synchronized (paramFileRepository) {
            File paramFile = new File(name);
            if (!paramFile.exists() && !(paramFile = this.toParamFile(paramName)).exists()) {
                return null;
            }
            FileInputStream fileStream = null;
            try {
                fileStream = new FileInputStream(paramFile);
                byte[] value = StreamUtils.readStream(fileStream);
                String string = new String(value, "UTF-8");
                return string;
            }
            catch (Exception e) {
                throw new ParamRepositoryException("Unable to load Param Value from file: " + paramFile.getAbsolutePath(), e);
            }
            finally {
                try {
                    if (fileStream != null) {
                        ((InputStream)fileStream).close();
                    }
                }
                catch (IOException e) {
                    this.logger.warn((Object)("Unable to close param file: " + paramFile.getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        FileParamName paramName = this.asserNameOK(name);
        ParamFileRepository paramFileRepository = this;
        synchronized (paramFileRepository) {
            File paramFile = this.toParamFile(paramName);
            if (paramFile.exists()) {
                paramFile.delete();
            }
        }
    }

    public File getRoot() {
        return this.root;
    }

    public File toParamFile(String name) {
        FileParamName paramName = this.asserNameOK(name);
        return new File(this.root, paramName.toString());
    }

    private File toParamFile(FileParamName paramName) {
        return new File(this.root, paramName.toString());
    }

    private FileParamName asserNameOK(String name) {
        FileParamName paramName;
        if (name == null) {
            throw new IllegalArgumentException("null 'name' arg in repository call.");
        }
        try {
            paramName = new FileParamName(name);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException("Invalid 'name' arg: " + name, e);
        }
        if (paramName.size() == 0) {
            throw new IllegalArgumentException("Invalid 'name' arg.  0 tokens: " + name);
        }
        return paramName;
    }

    private static class FileParamName
    extends CompoundName {
        private static final long serialVersionUID = 1L;
        private static final Properties nameSyntaxProperties = new Properties();

        public FileParamName(String name) throws InvalidNameException {
            super(name, nameSyntaxProperties);
        }

        static {
            nameSyntaxProperties.setProperty("jndi.syntax.direction", "left_to_right");
            nameSyntaxProperties.setProperty("jndi.syntax.separator", "/");
        }
    }
}

