/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.notification;

import java.net.URI;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.mapping.ObjectMapper;
import org.jboss.soa.esb.message.mapping.ObjectMappingException;

public class PropertySubstituter {
    public static String replaceArguments(String field, Message message) {
        String current = field;
        boolean foundReplacement = false;
        if (field == null) {
            return null;
        }
        String replaced = PropertySubstituter.replaceArgument(field, message);
        while (!current.equals(replaced)) {
            current = replaced;
            foundReplacement = true;
            replaced = PropertySubstituter.replaceArgument(current, message);
        }
        ObjectMapper om = new ObjectMapper();
        if (!foundReplacement) {
            try {
                Object obj = om.getObjectFromMessage(message, field);
                if (obj != null) {
                    if (obj instanceof String) {
                        replaced = (String)obj;
                    } else if (obj instanceof URI) {
                        replaced = obj.toString();
                    }
                }
            }
            catch (ObjectMappingException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return replaced;
    }

    protected static String replaceArgument(String value, Message message) {
        int startIndex = value.indexOf(123);
        if (startIndex == -1) {
            return value;
        }
        int endIndex = value.indexOf(125);
        if (endIndex == -1) {
            return value;
        }
        String propName = value.substring(startIndex + 1, endIndex);
        Object propValue = message.getProperties().getProperty(propName);
        if (propValue == null) {
            return value;
        }
        return value.substring(0, startIndex) + propValue + value.substring(endIndex + 1);
    }
}

