/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.dependencies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.juddi.registry.rmi.JNDIRegistration;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.dependencies.JuddiRMIServiceMBean;
import org.jboss.internal.soa.esb.util.PropertiesHelper;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;

public class JuddiRMIService
extends ServiceMBeanSupport
implements JuddiRMIServiceMBean {
    private Logger logger = Logger.getLogger(this.getClass());
    public static final String PROPNAME_JAVA_NAMING_FACTORY_INITIAL = "java.naming.factory.initial";
    public static final String PROPNAME_JAVA_NAMING_PROVIDER_URL = "java.naming.provider.url";
    public static final String PROPNAME_JAVA_NAMING_FACTORY_URL_PKGS = "java.naming.factory.url.pkgs";
    private static final String DEFAULT_PROPERTIES_RESOURCE_FILE = "esb.juddi.xml";
    private static final String JUDDI_PROPERTIES_RESOURCE_FILE = "esb.juddi.properties";
    private static final String JUDDI_PROPERTY_FILE_COMMENTS = "Auto generated property file, do not edit";
    private String propertiesResourceFile;

    public String getPropertiesResourceFile() {
        return this.propertiesResourceFile;
    }

    public void setPropertiesResourceFile(String propertiesResourceFile) {
        this.propertiesResourceFile = propertiesResourceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        Properties xmlProperties;
        byte[] propertyFileContents;
        InputStream xmlPropertyIS;
        this.logger.info((Object)"starting juddi RMI service");
        String propertiesResourceFileVal = this.propertiesResourceFile == null ? DEFAULT_PROPERTIES_RESOURCE_FILE : this.propertiesResourceFile;
        File baseFile = new File(propertiesResourceFileVal);
        if (baseFile.isAbsolute()) {
            xmlPropertyIS = new FileInputStream(baseFile);
        } else {
            URL url = Thread.currentThread().getContextClassLoader().getResource(propertiesResourceFileVal);
            xmlPropertyIS = url.openStream();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLHelper.replaceSystemProperties(XMLHelper.getXMLStreamReader(xmlPropertyIS), XMLHelper.getXMLStreamWriter(baos));
            propertyFileContents = baos.toByteArray();
        }
        finally {
            xmlPropertyIS.close();
        }
        ServerConfig serverConfig = ServerConfigLocator.locate();
        File dataDir = serverConfig.getServerDataDir();
        File juddiPropertyFile = new File(dataDir, JUDDI_PROPERTIES_RESOURCE_FILE);
        ByteArrayInputStream bais = new ByteArrayInputStream(propertyFileContents);
        FileOutputStream juddiPropertyOS = new FileOutputStream(juddiPropertyFile);
        try {
            xmlProperties = PropertiesHelper.translateXMLToText(bais, juddiPropertyOS, JUDDI_PROPERTY_FILE_COMMENTS);
        }
        finally {
            juddiPropertyOS.close();
        }
        System.setProperty("juddi.propertiesFile", juddiPropertyFile.getAbsolutePath());
        System.setProperty("javax.xml.registry.ConnectionFactoryClass", "org.apache.ws.scout.registry.ConnectionFactoryImpl");
        String factoryInitial = xmlProperties.getProperty(PROPNAME_JAVA_NAMING_FACTORY_INITIAL, null);
        String providerURL = xmlProperties.getProperty(PROPNAME_JAVA_NAMING_PROVIDER_URL, null);
        String factoryURLPkgs = xmlProperties.getProperty(PROPNAME_JAVA_NAMING_FACTORY_URL_PKGS, null);
        if (factoryInitial != null) {
            System.setProperty(PROPNAME_JAVA_NAMING_FACTORY_INITIAL, factoryInitial);
        }
        if (providerURL != null) {
            System.setProperty(PROPNAME_JAVA_NAMING_PROVIDER_URL, providerURL);
        }
        if (factoryURLPkgs != null) {
            System.setProperty(PROPNAME_JAVA_NAMING_FACTORY_URL_PKGS, factoryURLPkgs);
        }
        JNDIRegistration.register();
    }

    protected void stopService() throws Exception {
        this.logger.info((Object)"Unbinding juddi services");
        InitialContext ic = new InitialContext();
        ic.unbind(JNDIRegistration.INQUIRY_SERVICE);
        ic.unbind(JNDIRegistration.PUBLISH_SERVICE);
    }
}

