/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.dependencies;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.Server;
import org.jboss.internal.soa.esb.dependencies.H2DatabaseMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;

public class H2Database
extends ServiceMBeanSupport
implements H2DatabaseMBean {
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_USER = "sa";
    private static final String JDBC_DRIVER_CLASS = "org.h2.Driver";
    private static final String JDBC_URL_PREFIX = "jdbc:h2:";
    private static final String JDBC_MEM_URL_PREFIX = "jdbc:h2:mem:";
    private static final String DEFAULT_FLAGS = ";MVCC=TRUE;DB_CLOSE_ON_EXIT=FALSE";
    private static final String H2_DATA_DIR = "h2";
    private static final String DEFAULT_DATABASE_NAME = "default";
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private static final int DEFAULT_PORT = 9092;
    private static final long DEFAULT_DELAY = 5000L;
    private File dbPath;
    private String name = "default";
    private boolean inMemoryMode;
    private String user = "sa";
    private String password = "";
    private String flags = ";MVCC=TRUE;DB_CLOSE_ON_EXIT=FALSE";
    private Connection connection;
    private String address = "0.0.0.0";
    private int port = 9092;
    private boolean serverMode = false;
    private Thread serverThread;
    private Server remoteServer;
    private long delay = 5000L;

    public void setDatabase(String name) {
        if (name == null) {
            name = DEFAULT_DATABASE_NAME;
        }
        this.name = name;
    }

    public String getDatabase() {
        return this.name;
    }

    public String getDatabasePath() {
        if (this.dbPath != null) {
            return this.dbPath.toString();
        }
        return null;
    }

    public boolean isInMemoryMode() {
        return this.inMemoryMode;
    }

    public void setInMemoryMode(boolean b) {
        this.inMemoryMode = b;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public String getFlags() {
        return this.flags;
    }

    public void setPassword(String password) {
        if (password == null) {
            password = DEFAULT_PASSWORD;
        }
        this.password = password;
    }

    public void setUser(String user) {
        if (user == null) {
            user = DEFAULT_USER;
        }
        this.user = user;
    }

    public void setFlags(String flags) {
        if (flags == null) {
            flags = DEFAULT_FLAGS;
        }
        this.flags = flags;
    }

    public boolean isServerMode() {
        return this.serverMode;
    }

    public void setServerMode(boolean serverMode) {
        this.serverMode = serverMode;
    }

    public String getBindAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    protected void startService() throws Exception {
        if (this.serverMode) {
            this.startRemoteDatabase();
        } else if (this.inMemoryMode) {
            this.startInMemoryDatabase();
        } else {
            this.startStandaloneDatabase();
        }
    }

    protected void stopService() throws Exception {
        if (this.serverMode) {
            this.stopRemoteDatabase();
        } else if (this.inMemoryMode) {
            this.stopInMemoryDatabase();
        } else {
            this.stopStandaloneDatabase();
        }
    }

    private void startStandaloneDatabase() throws Exception {
        File h2Dir = this.checkDataDir();
        this.dbPath = new File(h2Dir, this.name);
        String dbURL = JDBC_URL_PREFIX + this.dbPath.toURI().toString() + this.flags;
        this.log.info((Object)dbURL);
        this.connection = this.getConnection(dbURL);
    }

    private void startInMemoryDatabase() throws Exception {
        String dbURL = JDBC_MEM_URL_PREFIX + this.name + this.flags;
        this.connection = this.getConnection(dbURL);
    }

    private void startRemoteDatabase() throws Exception {
        File h2Dir = this.checkDataDir();
        this.dbPath = new File(h2Dir, this.name);
        this.serverThread = new Thread("h2-" + this.name){

            public void run() {
                try {
                    H2Database.this.log.debug((Object)("Starting remote h2 db with port : " + H2Database.this.port));
                    String[] args = new String[]{"-baseDir", H2Database.this.dbPath.getAbsolutePath(), "-tcpPort", String.valueOf(H2Database.this.port), "-tcpAllowOthers", H2Database.DEFAULT_PASSWORD};
                    Server server = Server.createTcpServer((String[])args);
                    server.start();
                    H2Database.this.setRemoteServer(server);
                }
                catch (Exception e) {
                    H2Database.this.log.error((Object)"Failed to start database", (Throwable)e);
                }
            }
        };
        this.serverThread.start();
        if (this.delay > 0L) {
            this.log.debug((Object)("Waiting for Database initialisation: maximum " + this.delay + " milliseconds"));
            try {
                this.serverThread.join(this.delay);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            if (this.serverThread.isAlive()) {
                this.log.warn((Object)"Database initialisation is still active");
            } else {
                this.log.debug((Object)"Database initialisation completed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopStandaloneDatabase() throws Exception {
        try {
            Statement stmt = this.connection.createStatement();
            stmt.execute("shutdown");
        }
        finally {
            this.connection = null;
        }
        this.log.info((Object)"Database standalone closed clean");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInMemoryDatabase() throws Exception {
        try {
            this.connection.close();
        }
        finally {
            this.connection = null;
        }
        this.log.info((Object)"Database in memory closed clean");
    }

    private void stopRemoteDatabase() throws SQLException {
        Server server = this.getRemoteServer();
        if (server != null) {
            server.stop();
        }
    }

    private synchronized void setRemoteServer(Server remoteServer) {
        this.remoteServer = remoteServer;
    }

    private synchronized Server getRemoteServer() {
        return this.remoteServer;
    }

    private synchronized Connection getConnection(String dbURL) throws Exception {
        if (this.connection == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class.forName(JDBC_DRIVER_CLASS, true, cl).newInstance();
            this.connection = DriverManager.getConnection(dbURL, this.user, this.password);
        }
        return this.connection;
    }

    private File checkDataDir() throws IOException {
        File dataDir = this.getDataDir();
        File h2Dir = new File(dataDir, H2_DATA_DIR);
        if (!h2Dir.exists()) {
            h2Dir.mkdirs();
        } else if (!h2Dir.isDirectory()) {
            throw new IOException("Failed to create directory: " + h2Dir);
        }
        return h2Dir;
    }

    File getDataDir() {
        return ServerConfigLocator.locate().getServerDataDir();
    }
}

