/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers.tx;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.couriers.InVMCourier;
import org.jboss.soa.esb.message.Message;

public class InVMXAResource
implements XAResource {
    private InVMCourier _theCourier;
    private Message _msg;
    private operation _opcode;
    private int _timeout;
    protected static Logger _logger = Logger.getLogger(InVMXAResource.class);

    public InVMXAResource(InVMCourier courier, Message msg, operation op) {
        this._theCourier = courier;
        this._msg = msg;
        this._opcode = op;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this._opcode == operation.INSERT) {
            boolean problem = false;
            try {
                problem = !this._theCourier.doDeliver(this._msg);
            }
            catch (Exception ex) {
                _logger.debug((Object)"Unexpected exception received when delivering to the courier", (Throwable)ex);
                problem = true;
            }
            if (problem) {
                _logger.warn((Object)"InVMXAResource failed to commit to the InVM queue!");
                throw new XAException(8);
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return this._timeout;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public void rollback(Xid xid) throws XAException {
        if (this._opcode == operation.REMOVE) {
            boolean problem = false;
            try {
                problem = !this._theCourier.doRedeliver(this._msg);
            }
            catch (Exception ex) {
                _logger.debug((Object)"Unexpected exception received when delivering to the courier", (Throwable)ex);
                problem = true;
            }
            if (problem) {
                _logger.warn((Object)"InVMXAResource could not rollback and put Message on to InVM queue!");
                throw new XAException(8);
            }
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        this._timeout = seconds;
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
    }

    public Message getMessage() {
        return this._msg;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return xares == this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum operation {
        INSERT,
        REMOVE;

    }
}

