/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers.helpers;

import org.jboss.internal.soa.esb.couriers.helpers.FileHandler;
import org.jboss.internal.soa.esb.couriers.helpers.FtpFileHandler;
import org.jboss.internal.soa.esb.couriers.helpers.LocalFileHandler;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.couriers.CourierException;

public class FileHandlerFactory {
    private static final FileHandlerFactory _instance = new FileHandlerFactory();

    public static FileHandlerFactory getInstance() {
        return _instance;
    }

    public FileHandler getFileHandler(FileEpr epr) throws CourierException {
        if (epr instanceof FTPEpr) {
            return new FtpFileHandler((FTPEpr)epr);
        }
        if (epr instanceof FileEpr) {
            return new LocalFileHandler(epr);
        }
        throw new CourierException("Unable to obtain a file handler for supplied EPR");
    }
}

